/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.modelexplorer;

import java.io.File;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.modelexplorer.ModelContentProvider;

public class ModelLabelProvider
extends LabelProvider
implements IDescriptionProvider {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss");
    private Image modelImage = TLCUIActivator.getImageDescriptor("/icons/full/choice_sc_obj.gif").createImage();
    private Image modelNoError = TLCUIActivator.getImageDescriptor("/icons/full/model_no_error.gif").createImage();
    private Image modelWithError = TLCUIActivator.getImageDescriptor("/icons/full/model_with_error.gif").createImage();
    private Image modelCloudTLCRunning = TLCUIActivator.getImageDescriptor("/icons/full/thread_view.png").createImage();

    public Image getImage(Object element) {
        if (element instanceof ModelContentProvider.Group) {
            return this.modelImage;
        }
        if (element instanceof Model) {
            Model model = (Model)element;
            if (model.isSnapshot()) {
                if (model.isRunningRemotely()) {
                    return this.modelCloudTLCRunning;
                }
                if (model.hasError()) {
                    return this.modelWithError;
                }
                return this.modelNoError;
            }
            return this.modelImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof Model) {
            Model model = (Model)element;
            if (model.isSnapshot()) {
                return sdf.format(model.getSnapshotTimeStamp());
            }
            String modelName = model.getName();
            if (model.isStale()) {
                return modelName + " [ crashed ]";
            }
            if (model.isRunning()) {
                return modelName + " [ modelchecking ]";
            }
            return modelName;
        }
        if (element instanceof ModelContentProvider.Group) {
            return element.toString();
        }
        return null;
    }

    public String getDescription(Object element) {
        if (element instanceof Model) {
            Model model = (Model)element;
            String comments = model.getComments();
            if (comments.equals("")) {
                return this.getText(element) + " [ " + String.valueOf(model.getFolder().getLocation().toFile()) + File.separator + " ]";
            }
            return comments;
        }
        return null;
    }

    public void dispose() {
        if (this.modelImage != null) {
            this.modelImage.dispose();
        }
        this.modelImage = null;
        if (this.modelNoError != null) {
            this.modelNoError.dispose();
        }
        this.modelNoError = null;
        if (this.modelWithError != null) {
            this.modelWithError.dispose();
        }
        this.modelWithError = null;
        super.dispose();
    }
}

