/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.modelexplorer;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.util.UIHelper;

public class SavedModuleContributionItem
extends CompoundContributionItem {
    public SavedModuleContributionItem() {
    }

    public SavedModuleContributionItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        IFolder modelFolder;
        IEditorPart editor = UIHelper.getActiveEditor();
        if (editor instanceof ModelEditor && (modelFolder = ((ModelEditor)editor).getModel().getTargetDirectory()) != null && modelFolder.exists()) {
            try {
                ArrayList<CommandContributionItem> contributions = new ArrayList<CommandContributionItem>();
                IResource[] members = modelFolder.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i].exists() && members[i].getFileExtension() != null && members[i].getFileExtension().equals("tla") && !members[i].getName().equals("MC.tla") && !members[i].getName().equals("TE.tla")) {
                        HashMap<String, String> parameters = new HashMap<String, String>(1);
                        parameters.put("toolbox.tool.tlc.commands.open.savedModule.modulePath", members[i].getRawLocation().toPortableString());
                        contributions.add(new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)UIHelper.getActiveWindow(), "toolbox.command.model.open.savedModule.", "toolbox.tool.tlc.commands.open.savedModule", parameters, null, null, null, members[i].getName(), null, "Opens the version saved in the last run of TLC.", 8, null, true)));
                    }
                    ++i;
                }
                return contributions.toArray(new IContributionItem[contributions.size()]);
            }
            catch (CoreException e) {
                TLCUIActivator.getDefault().logError("Error getting members of model folder " + String.valueOf(modelFolder), e);
            }
        }
        return new IContributionItem[0];
    }
}

