/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractTableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final int m_minimumWidth;
    private final String[] m_columnTitles;
    private final double[] m_columnWidthPercentages;

    protected AbstractTableLabelProvider(int minWidth, String[] titles, double[] percentages) {
        this.m_minimumWidth = minWidth;
        this.m_columnTitles = titles;
        this.m_columnWidthPercentages = percentages;
    }

    public int getMinimumTotalWidth() {
        return this.m_minimumWidth;
    }

    public String getColumnTitle(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.m_columnTitles.length) {
            return this.m_columnTitles[columnIndex];
        }
        return null;
    }

    public void resizeColumns(int newTableWidth, Table table) {
        double tableWidth = newTableWidth;
        int currentWidthSum = 0;
        int i = 0;
        while (i < this.m_columnWidthPercentages.length - 1) {
            TableColumn column = table.getColumn(i);
            int newWidth = (int)(this.m_columnWidthPercentages[i] * tableWidth);
            column.setWidth(newWidth);
            currentWidthSum += newWidth;
            ++i;
        }
        TableColumn column = table.getColumn(this.m_columnWidthPercentages.length - 1);
        column.setWidth(newTableWidth - currentWidthSum);
    }
}

