/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import util.ExecutionStatisticsCollector;

public class ExecutionStatisticsDialog
extends MessageDialog {
    private static final String KEY = "BUTTON_KEY";
    private final ExecutionStatisticsCollector esc = new ExecutionStatisticsCollector();
    private final boolean isUserTriggered;

    public ExecutionStatisticsDialog(boolean isUserTriggered, Shell parentShell) {
        super(parentShell, "TLA+ execution statistics", null, "The TLA+ project needs your help!", 3, new String[0], 0);
        this.isUserTriggered = isUserTriggered;
        this.setShellStyle(this.getShellStyle() ^ 0x10000);
        this.setBlockOnOpen(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button[] buttons = new Button[3];
        buttons[0] = this.createButton(parent, 0, "&Always Share\nExecution Statistics", false);
        buttons[0].setData(KEY, (Object)ExecutionStatisticsCollector.Selection.ON);
        buttons[1] = this.createButton(parent, 1, "Share Without\n&Installation Identifier", false);
        buttons[1].setData(KEY, (Object)ExecutionStatisticsCollector.Selection.RANDOM_IDENTIFIER);
        buttons[2] = this.createButton(parent, 2, "&Never Share\nExecution Statistics", false);
        buttons[2].setData(KEY, (Object)ExecutionStatisticsCollector.Selection.NO_ESC);
        if (this.isUserTriggered) {
            ExecutionStatisticsCollector.Selection selection = this.esc.get();
            switch (selection) {
                case ON: {
                    buttons[0].setEnabled(false);
                    break;
                }
                case RANDOM_IDENTIFIER: {
                    buttons[1].setEnabled(false);
                    break;
                }
                case NO_ESC: {
                    buttons[2].setEnabled(false);
                }
            }
        }
        this.setButtons(buttons);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 72);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.buttonPressed((Integer)event.widget.getData())));
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createCustomArea(Composite parent) {
        Composite c = new Composite(parent, 2048);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        String txt = String.format("%s* Total number of cores and cores assigned to TLC\n* Heap and off-heap memory allocated to TLC\n* TLC's version (git commit SHA)\n* If breadth-first search, depth-first search or simulation mode is active\n* TLC's implementation for the sets of seen and unseen states\n* If TLC has been launched from the TLA Toolbox\n* Name, version, and architecture of your operating system\n* Vendor, version, and architecture of your Java virtual machine\n* The current date and time\n* An installation identifier which allows us to group execution statistics\n\nThe execution statistics do not contain personal information. If you wish to revoke\nyour consent to share execution statistics at a later point, please chose \n\"Never Share Execution Statistics\" below by re-opening this dialog via\nHelp > Opt In/Out Execution Statistics accessible from the Toolbox's main menu.", ExecutionStatisticsDialog.prettyPrintSelection2(this.esc));
        final StyledText st = new StyledText(c, 96);
        st.setLayoutData((Object)new GridData(4, 4, true, true));
        st.setEnabled(true);
        st.setEditable(false);
        st.setText(txt);
        StyleRange[] ranges = new StyleRange[3];
        ranges[0] = new StyleRange(txt.indexOf("(TLC) execution statistics"), "(TLC) execution statistics".length(), null, null);
        ranges[0].underline = true;
        ranges[0].underlineStyle = 4;
        ranges[0].data = "https://exec-stats.tlapl.us";
        ranges[1] = new StyleRange(txt.indexOf("publicly available"), "publicly available".length(), null, null);
        ranges[1].underline = true;
        ranges[1].underlineStyle = 4;
        ranges[1].data = "https://exec-stats.tlapl.us/tlaplus.csv";
        ranges[2] = new StyleRange(txt.indexOf("git commit SHA"), "git commit SHA".length(), null, null);
        ranges[2].underline = true;
        ranges[2].underlineStyle = 4;
        ranges[2].data = "https://git-scm.com/book/en/v2/Git-Internals-Git-Objects";
        st.setStyleRanges(ranges);
        st.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                int offset = st.getOffsetAtPoint(new Point(event.x, event.y));
                if (offset < 0 || offset >= st.getCharCount()) {
                    return;
                }
                StyleRange style = st.getStyleRangeAtOffset(offset);
                if (style != null && style.underline && style.underlineStyle == 4 && style.data instanceof String) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL((String)style.data));
                    }
                    catch (MalformedURLException | PartInitException notExpectedToHappen) {
                        notExpectedToHappen.printStackTrace();
                    }
                }
            }
        });
        return c;
    }

    private static String prettyPrintSelection2(ExecutionStatisticsCollector esc) {
        switch (esc.get()) {
            case ON: {
                return String.format("Thank you for sharing (TLC) execution statistics with installation identifier\n%s.\n\nExecution Statistics help us make informed decisions about future research and\ndevelopment directions. Execution statistics are made publicly available on the\nweb and contain the following information:\n\n", esc.getIdentifier());
            }
            case RANDOM_IDENTIFIER: {
                return "Thank you for sharing (TLC) execution statistics. Execution Statistics help us\nmake informed decisions about future research and development directions.\nExecution statistics are made publicly available on the web and contain the\nfollowing information:\n\n";
            }
        }
        return "Please opt-in and share (TLC) execution statistics. Execution statistics are made\npublicly available on the web and contain the following information:\n\n";
    }

    protected void buttonPressed(int buttonId) {
        final ExecutionStatisticsCollector.Selection col = (ExecutionStatisticsCollector.Selection)this.getButton(buttonId).getData(KEY);
        Job j = new Job("Write Execution Statistics Preference."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ExecutionStatisticsDialog.this.esc.set(col);
                }
                catch (IOException e) {
                    return new Status(1, "org.lamport.tla.toolbox.tool.tlc.ui", e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        super.buttonPressed(buttonId);
    }
}

