/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariable;

public class ErrorViewTraceFilterDialog
extends Dialog {
    private static final String[] MUTATED_VARIABLE_SELECTIONS = new String[]{"Show all variables", "Show only changed variables", "Show only changed variables in changed frames"};
    private CheckboxTableViewer tableViewer;
    private final List<TLCVariable> variables;
    private final HashSet<TLCVariable> selection;
    private Combo mutatedVariablesCombo;
    private MutatedFilter selectedFilter;

    public ErrorViewTraceFilterDialog(Shell parentShell, List<TLCVariable> variableList) {
        super(parentShell);
        this.variables = new ArrayList<TLCVariable>(variableList);
        this.selection = new HashSet();
    }

    public Set<TLCVariable> getSelection() {
        return this.selection;
    }

    public void setSelection(Set<TLCVariable> newSelection) {
        this.selection.clear();
        if (newSelection == null || newSelection.size() == 0) {
            return;
        }
        this.selection.addAll(newSelection);
        if (this.tableViewer != null) {
            this.tableViewer.setAllChecked(false);
            this.selection.stream().forEach(element -> {
                boolean bl = this.tableViewer.setChecked(element, true);
            });
        }
    }

    public MutatedFilter getMutatedFilterSelection() {
        return this.selectedFilter;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 9;
        container.setLayout((Layout)gl);
        Label l = new Label(container, 16384);
        l.setText("Selected variables and expressions will be hidden from the error trace.");
        l.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2564);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TLCVariable)element).getName();
            }
        });
        this.tableViewer.setInput(this.variables);
        this.selection.stream().forEach(element -> {
            boolean bl = this.tableViewer.setChecked(element, true);
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 333;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        Composite buttonPane = new Composite(container, 0);
        gl = new GridLayout(1, false);
        buttonPane.setLayout((Layout)gl);
        Button b = new Button(buttonPane, 8);
        b.setText("Select All");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ErrorViewTraceFilterDialog.this.tableViewer.setAllChecked(true);
            }
        });
        b = new Button(buttonPane, 8);
        b.setText("Deselect All");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ErrorViewTraceFilterDialog.this.tableViewer.setAllChecked(false);
            }
        });
        Composite mutatedVariablesComboPane = new Composite(container, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        mutatedVariablesComboPane.setLayoutData((Object)gd);
        gl = new GridLayout(2, false);
        mutatedVariablesComboPane.setLayout((Layout)gl);
        l = new Label(mutatedVariablesComboPane, 16384);
        l.setText("Filter by change:");
        l.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        this.mutatedVariablesCombo = new Combo(mutatedVariablesComboPane, 8);
        this.mutatedVariablesCombo.setItems(MUTATED_VARIABLE_SELECTIONS);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.mutatedVariablesCombo.setLayoutData((Object)gd);
        this.mutatedVariablesCombo.setText(MUTATED_VARIABLE_SELECTIONS[0]);
        return container;
    }

    protected void okPressed() {
        this.selection.clear();
        Arrays.stream(this.tableViewer.getCheckedElements()).forEach(element -> {
            boolean bl = this.selection.add((TLCVariable)element);
        });
        this.selectedFilter = MutatedFilter.values()[this.mutatedVariablesCombo.getSelectionIndex()];
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Error Trace Filter");
    }

    public static enum MutatedFilter {
        NO_FILTER,
        CHANGED_ALL_FRAMES,
        CHANGED_CHANGED_FRAMES;

    }
}

