/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page;

import java.util.Hashtable;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationDefaults;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.contribution.DynamicContributionItem;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.DataBindingManager;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ISectionConstants;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.ControlNavigationLocation;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.IModelOperationContainer;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.NavigationLocationComposite;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.TabNavigationLocation;
import org.lamport.tla.toolbox.tool.tlc.ui.util.DirtyMarkingListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.IgnoringListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.SemanticHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.TLCUIHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;

public abstract class BasicFormPage
extends FormPage
implements IModelConfigurationConstants,
IModelConfigurationDefaults,
ISectionConstants,
IModelOperationContainer,
INavigationLocationProvider {
    public static final String CRASHED_TITLE = " ( model checking has crashed )";
    public static final String RUNNING_TITLE = " ( model checking is in progress )";
    public static final String IMAGE_TEMPLATE_TOKEN = "[XXXXX]";
    protected static final String SECTION_EXPANSION_LISTENER = "_why_oh_why_..._sigh";
    private static final String TLC_ERROR_STRING = "TLC Error";
    protected ListenerList<DirtyMarkingListener> dirtyPartListeners = new ListenerList();
    protected boolean initialized = false;
    protected String helpId = null;
    private String imagePathTemplate;
    protected IExpansionListener formRebuildingListener = null;
    private Hashtable<String, Image> images = new Hashtable();
    private boolean isComplete = true;
    protected ToolBarManager headClientTBM = null;
    protected final FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent event) {
            INavigationHistory navigationHistory = BasicFormPage.this.getSite().getPage().getNavigationHistory();
            navigationHistory.markLocation((IEditorPart)BasicFormPage.this);
        }

        public void focusLost(FocusEvent e) {
        }
    };
    protected IHyperlinkListener errorMessageHyperLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            IMessage[] messages = (IMessage[])e.getHref();
            if (messages.length > 0 && messages[0].getMessage().equals(BasicFormPage.TLC_ERROR_STRING)) {
                if (BasicFormPage.this.getModel() != null) {
                    TLCErrorView.updateErrorView(BasicFormPage.this.getModelEditor());
                }
            } else {
                String pageId;
                Control control = null;
                boolean errorOnThisPage = false;
                int i = 0;
                while (i < messages.length) {
                    if (messages[i].getData() instanceof String && (pageId = (String)messages[i].getData()) != null && pageId == BasicFormPage.this.getId()) {
                        errorOnThisPage = true;
                        control = messages[i].getControl();
                    }
                    ++i;
                }
                if (!errorOnThisPage) {
                    i = 0;
                    while (i < messages.length) {
                        if (messages[i].getData() instanceof String && (pageId = (String)messages[i].getData()) != null) {
                            BasicFormPage.this.getEditor().setActivePage(pageId);
                            control = messages[i].getControl();
                            break;
                        }
                        ++i;
                    }
                }
                if (control != null) {
                    control.setFocus();
                    if (control.getParent().getParent() instanceof Section) {
                        Section section = (Section)control.getParent().getParent();
                        section.setExpanded(true);
                    }
                }
            }
        }
    };

    public BasicFormPage(FormEditor editor, String id, String title, String pageImagePathTemplate) {
        super(editor, id, title);
        this.imagePathTemplate = pageImagePathTemplate;
    }

    public Image getTitleImage() {
        return this.createRegisteredImage(16);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm formWidget = managedForm.getForm();
        formWidget.setText(this.getTitle());
        if (this.imagePathTemplate != null) {
            formWidget.setImage(this.createRegisteredImage(24));
        }
        Composite body = formWidget.getBody();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(formWidget.getForm());
        ToolBar headClientTB = new ToolBar(formWidget.getForm().getHead(), 524544);
        this.headClientTBM = new ToolBarManager(headClientTB);
        this.headClientTBM.add((IContributionItem)new DynamicContributionItem((IAction)new RunAction()));
        this.headClientTBM.add((IContributionItem)new DynamicContributionItem((IAction)new GenerateAction()));
        this.headClientTBM.add((IContributionItem)new DynamicContributionItem((IAction)new StopAction()));
        this.headClientTBM.update(true);
        formWidget.getForm().setHeadClient((Control)headClientTB);
        body.setLayout(this.getBodyLayout());
        this.createBodyContent(managedForm);
        super.createFormContent(managedForm);
        try {
            this.loadData();
        }
        catch (CoreException e) {
            TLCUIActivator.getDefault().logError("Error loading data from the model into the form fields", e);
        }
        this.refresh();
        this.pageInitializationComplete();
        TLCUIHelper.setHelp(this.getPartControl(), this.helpId);
        this.getManagedForm().getForm().getForm().addMessageHyperlinkListener(this.errorMessageHyperLinkListener);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        NavigationLocationComposite combinedFormNav = new NavigationLocationComposite();
        combinedFormNav.add(new TabNavigationLocation((IFormPage)this));
        Control focusControl = this.getSite().getShell().getDisplay().getFocusControl();
        if (focusControl != null) {
            combinedFormNav.add(new ControlNavigationLocation(focusControl));
        }
        return combinedFormNav;
    }

    public INavigationLocation createNavigationLocation() {
        return this.createEmptyNavigationLocation();
    }

    protected void loadData() throws CoreException {
    }

    protected void pageInitializationComplete() {
        Object[] listeners = this.dirtyPartListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IgnoringListener)listeners[i]).setIgnoreInput(false);
            ++i;
        }
        this.initialized = true;
    }

    protected abstract void createBodyContent(IManagedForm var1);

    public void commit(boolean onSave) {
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null) {
            managedForm.commit(onSave);
        }
    }

    protected Layout getBodyLayout() {
        return FormHelper.createFormTableWrapLayout(false, 2);
    }

    public IExpansionListener getExpansionListener() {
        if (this.formRebuildingListener == null) {
            this.formRebuildingListener = new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    BasicFormPage.this.getManagedForm().reflow(true);
                }
            };
        }
        return this.formRebuildingListener;
    }

    protected void compensateForExpandableCompositesPoorDesign(Section section, boolean expand) {
        Object o;
        section.setExpanded(expand);
        if (section.getData("_no_space_grab") == null) {
            GridData gd = (GridData)section.getLayoutData();
            gd.grabExcessVerticalSpace = expand;
            section.setLayoutData((Object)gd);
        }
        if ((o = section.getData(SECTION_EXPANSION_LISTENER)) != null) {
            ((Consumer)o).accept(expand);
        }
    }

    protected Image createRegisteredImage(int size) {
        ImageDescriptor id;
        String imagePath = this.imagePathTemplate.replace(IMAGE_TEMPLATE_TOKEN, Integer.toString(size));
        Image image = this.images.get(imagePath);
        if (image == null && (id = TLCUIActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)imagePath)) != null) {
            image = id.createImage();
            this.images.put(imagePath, image);
        }
        return image;
    }

    public Model getModel() {
        return this.getModelEditor().getModel();
    }

    public void validatePage(boolean switchToErrorPage) {
        this.handleProblemMarkers(false);
    }

    private void handleProblemMarkers(boolean switchToErrorPage) {
        this.getModelEditor().handleProblemMarkers(switchToErrorPage);
    }

    protected ModelEditor getModelEditor() {
        return (ModelEditor)this.getEditor();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public SemanticHelper getLookupHelper() {
        return ((ModelEditor)this.getEditor()).getHelper();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void expandSection(String sectionId) {
        this.getDataBindingManager().expandSection(sectionId);
    }

    public void expandSections(String[] sections) {
        String[] stringArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            this.expandSection(section);
            ++n2;
        }
    }

    public void setEnabled(boolean enabled) {
        this.getDataBindingManager().setAllSectionsEnabled(this.getId(), enabled);
    }

    public void dispose() {
        for (Image i : this.images.values()) {
            i.dispose();
        }
        super.dispose();
    }

    public void refresh() {
        IManagedForm mForm = this.getManagedForm();
        if (mForm != null) {
            IToolBarManager toolbarManager = mForm.getForm().getToolBarManager();
            boolean modelRunning = this.getModel().isRunning();
            String title = mForm.getForm().getText();
            int titleIndex = Math.max(title.indexOf(RUNNING_TITLE), title.indexOf(CRASHED_TITLE));
            if (titleIndex != -1) {
                title = title.substring(0, titleIndex);
            }
            if (modelRunning) {
                if (this.getModel().isStale()) {
                    mForm.getForm().setText(title + CRASHED_TITLE);
                } else {
                    mForm.getForm().setText(title + RUNNING_TITLE);
                }
            } else if (titleIndex != -1) {
                mForm.getForm().setText(title);
            }
            toolbarManager.markDirty();
            toolbarManager.update(true);
            if (this.headClientTBM != null) {
                this.headClientTBM.markDirty();
                this.headClientTBM.update(true);
            }
            this.setEnabled(!modelRunning);
            mForm.getForm().update();
        }
    }

    public void validateUsage(String attributeName, List<String> values, String errorMessagePrefix, String elementType, String listSourceDescription, boolean addToContext) {
        if (values == null) {
            return;
        }
        DataBindingManager dm = this.getDataBindingManager();
        String sectionId = dm.getSectionForAttribute(attributeName);
        if (sectionId == null) {
            throw new IllegalArgumentException("No section for attribute " + attributeName + " found");
        }
        Control widget = UIHelper.getWidget((Object)dm.getAttributeControl(attributeName));
        this.validateUsage(sectionId, widget, values, errorMessagePrefix, elementType, listSourceDescription, addToContext);
    }

    public void validateUsage(String sectionId, Control widget, List<String> values, String errorMessagePrefix, String elementType, String listSourceDescription, boolean addToContext) {
        IMessageManager mm = this.getManagedForm().getMessageManager();
        SemanticHelper helper = this.getLookupHelper();
        int i = 0;
        while (i < values.size()) {
            String value = values.get(i);
            Object usageHint = helper.getUsedHint(value);
            if (usageHint != null) {
                Object message = elementType + " " + value + " may not be used, since it is ";
                if (usageHint instanceof SymbolNode) {
                    message = (String)message;
                    SymbolNode node = (SymbolNode)usageHint;
                    Location location = node.getLocation();
                    message = location.source().equals("--TLA+ BUILTINS--") ? (String)message + "a built-in TLA+ definition." : (String)message + "an identifier already defined at " + location.toString() + ".";
                } else {
                    message = usageHint instanceof String ? ("KEYWORD".equals(usageHint) ? (String)message + "a TLA+ keyword." : (String)message + "already used in " + String.valueOf(usageHint)) : "Error during validation. This is a bug";
                }
                mm.addMessage((Object)(errorMessagePrefix + i), (String)message, (Object)value.toString(), 3, widget);
                this.setComplete(false);
                this.expandSection(sectionId);
            } else if (addToContext) {
                helper.addName(value, this, listSourceDescription);
            }
            ++i;
        }
    }

    public void validateId(String attributeName, List<String> values, String errorMessagePrefix, String elementType) {
        if (values == null) {
            return;
        }
        DataBindingManager dm = this.getDataBindingManager();
        String sectionId = dm.getSectionForAttribute(attributeName);
        if (sectionId == null) {
            throw new IllegalArgumentException("No section for attribute " + attributeName + " found");
        }
        Control widget = UIHelper.getWidget((Object)dm.getAttributeControl(attributeName));
        this.validateId(sectionId, widget, values, errorMessagePrefix, elementType);
    }

    public void validateId(String sectionId, Control widget, List<String> values, String errorMessagePrefix, String elementType) {
        IMessageManager mm = this.getManagedForm().getMessageManager();
        int i = 0;
        while (i < values.size()) {
            String value = values.get(i);
            if (!FormHelper.isIdentifier(value)) {
                String message = value.trim().equals("") ? elementType + " has been omitted." : elementType + " " + value + " may not be used, since it is not a valid identifier.\nAn identifier is a non-empty sequence of letters, digits and '_' with at least one letter.";
                mm.addMessage((Object)(errorMessagePrefix + i), message, (Object)value.toString(), 3, widget);
                this.setComplete(false);
                this.expandSection(sectionId);
            }
            ++i;
        }
    }

    public void modelCheckingWillBegin() {
    }

    public DataBindingManager getDataBindingManager() {
        return this.getModelEditor().getDataBindingManager();
    }

    @Override
    public void doRun() {
        this.getModelEditor().launchModel("modelcheck", true);
    }

    @Override
    public void doGenerate() {
        this.getModelEditor().launchModel("generate", true);
    }

    public void doStop() {
        this.getModelEditor().stop();
    }

    public void resetAllMessages(boolean applyChange) {
        this.getManagedForm().getMessageManager().setAutoUpdate(false);
        this.getManagedForm().getMessageManager().removeAllMessages();
        this.setComplete(true);
        this.getManagedForm().getMessageManager().setAutoUpdate(applyChange);
    }

    public void resetMessage(Object key) {
        this.getManagedForm().getMessageManager().setAutoUpdate(false);
        this.getManagedForm().getMessageManager().removeMessage(key);
        this.setComplete(true);
        this.getManagedForm().getMessageManager().setAutoUpdate(true);
    }

    public void addGlobalTLCErrorMessage(String key) {
        this.addGlobalTLCErrorMessage(key, TLC_ERROR_STRING);
    }

    public void addGlobalTLCErrorMessage(String key, String message) {
        IMessageManager mm = this.getManagedForm().getMessageManager();
        mm.addMessage((Object)key, message, null, 2);
    }

    class GenerateAction
    extends Action {
        GenerateAction() {
            super("Generate", TLCUIActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)"icons/full/debugt_obj.gif"));
            this.setDescription("Validate model");
            this.setToolTipText("Checks the model for errors but does not run TLC on it.");
        }

        public void run() {
            BasicFormPage.this.doGenerate();
        }

        public boolean isEnabled() {
            return !BasicFormPage.this.getModel().isRunning();
        }
    }

    class ModelRecoveryAction
    extends Action {
        ModelRecoveryAction() {
            super("Restore model", TLCUIActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)"icons/full/loop_obj.gif"));
            this.setDescription("Restore model");
            this.setToolTipText("Restores the model after the TLC crashed.");
        }

        public void run() {
            ((ModelEditor)BasicFormPage.this.getEditor()).getModel().recover();
        }

        public boolean isEnabled() {
            return BasicFormPage.this.getModel().isStale();
        }
    }

    class RunAction
    extends Action {
        RunAction() {
            super("Run", TLCUIActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)"icons/full/run_exc.png"));
            this.setDescription("Run TLC");
            this.setToolTipText("Runs TLC on the model.");
        }

        public void run() {
            BasicFormPage.this.doRun();
        }

        public boolean isEnabled() {
            return !BasicFormPage.this.getModel().isRunning();
        }
    }

    class StopAction
    extends Action {
        StopAction() {
            super("Stop", TLCUIActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)"icons/full/progress_stop.gif"));
            this.setDescription("Stop TLC");
            this.setToolTipText("Stops the current TLC model checker run.");
        }

        public void run() {
            BasicFormPage.this.doStop();
        }

        public boolean isEnabled() {
            return BasicFormPage.this.getModel().isRunning() || BasicFormPage.this.getModel().isRunningRemotely();
        }
    }
}

