/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import org.lamport.tla.toolbox.util.UIHelper;

public class ModelEditorPartListener
implements IPartListener2 {
    private static ModelEditorPartListener listener;

    public static ModelEditorPartListener getDefault() {
        if (listener == null) {
            listener = new ModelEditorPartListener();
        }
        return listener;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part instanceof ModelEditor) {
            ModelEditor editor = (ModelEditor)part;
            Model model = editor.getModel();
            TLCModelLaunchDataProvider provider = model.isOriginalTraceShown() ? TLCOutputSourceRegistry.getModelCheckSourceRegistry().getProvider(model) : TLCOutputSourceRegistry.getTraceExploreSourceRegistry().getProvider(model);
            TLCErrorView errorView = (TLCErrorView)UIHelper.findView((String)"toolbox.tool.tlc.view.TLCErrorView");
            if (errorView != null && provider != null) {
                if (provider.getErrors().size() > 0) {
                    TLCErrorView.updateErrorView(editor, !UIHelper.isInSameStack((IWorkbenchPart)editor, (String)"toolbox.tool.tlc.view.TLCErrorView"));
                } else {
                    errorView.clear();
                }
            }
        }
    }
}

