/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.util.ModelNameValidator;
import org.lamport.tla.toolbox.util.UIHelper;

public class RenameModelHandlerDelegate
extends AbstractHandler
implements IHandler,
IModelConfigurationConstants {
    private boolean reopenModelEditorAfterRename = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection) {
            final Model model = (Model)((IStructuredSelection)selection).getFirstElement();
            if (model.isRunning()) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Could not rename models", (String)("Could not rename the model " + model.getName() + ", because it is being model checked."));
                return null;
            }
            if (model.isSnapshot()) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Could not rename model", (String)("Could not rename the model " + model.getName() + ", because it is a snapshot."));
                return null;
            }
            ModelNameValidator modelNameInputValidator = new ModelNameValidator((Spec)model.getSpec());
            final InputDialog dialog = new InputDialog(UIHelper.getShell(), "Rename model...", "Please input the new name of the model", model.getName(), (IInputValidator)modelNameInputValidator);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                IEditorPart editor = (IEditorPart)model.getAdapter(ModelEditor.class);
                if (editor != null) {
                    this.reopenModelEditorAfterRename = true;
                    UIHelper.getActivePage().closeEditor(editor, true);
                }
                Collection snapshots = model.getSnapshots();
                for (Model snapshot : snapshots) {
                    editor = (IEditorPart)snapshot.getAdapter(ModelEditor.class);
                    if (editor == null) continue;
                    UIHelper.getActivePage().closeEditor(editor, true);
                }
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        final String newModelName = dialog.getValue();
                        model.rename(newModelName, monitor);
                        if (RenameModelHandlerDelegate.this.reopenModelEditorAfterRename) {
                            UIHelper.runUIAsync((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    HashMap<String, String> parameters = new HashMap<String, String>();
                                    parameters.put("toolbox.tool.tlc.commands.model.open.param", newModelName);
                                    UIHelper.runCommand((String)"toolbox.tool.tlc.commands.model.open", parameters);
                                }
                            });
                        }
                    }
                };
                ProgressMonitorDialog ctxt = new ProgressMonitorDialog(UIHelper.getShell());
                try {
                    ctxt.run(true, false, (IRunnableWithProgress)operation);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = ((IEvaluationContext)evaluationContext).getDefaultVariable();
        if (selection instanceof List) {
            List list = (List)selection;
            boolean modelEncountered = false;
            for (Object element : list) {
                if (!(element instanceof Model)) continue;
                if (((Model)element).isSnapshot()) {
                    this.setBaseEnabled(false);
                    return;
                }
                modelEncountered = true;
            }
            this.setBaseEnabled(modelEncountered);
        } else {
            this.setBaseEnabled(false);
        }
    }
}

