/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.source;

import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.lamport.tla.toolbox.tool.tlc.output.PartitionToolkit;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegion;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegionContainer;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class TagBasedTLCAnalyzer {
    public static final int OPEN_TAG_LENGTH = 27;
    public static final int CLOSE_TAG_LENGTH = 24;
    private static final int START = 1;
    private static final int END = 2;
    private TLCRegion taggedRegion = null;
    private final IDocument document;
    private Stack<ITypedRegion> stack;
    private Vector<ITypedRegion> userOutput;

    public TagBasedTLCAnalyzer(IDocument document) {
        this.document = document;
        this.stack = new Stack();
        this.resetUserPartitions();
    }

    public void addTagStart(ITypedRegion start) {
        ITypedRegion userRegion = this.getUserRegion();
        if (userRegion != null) {
            this.stack.push(userRegion);
        }
        TLCRegion startRegion = new TLCRegion(start.getOffset(), start.getLength(), start.getType());
        startRegion.setMessageCode(this.getMessageCode(start, 1));
        startRegion.setSeverity(this.getSeverity(start));
        this.stack.push(startRegion);
    }

    public void addTagEnd(ITypedRegion end) {
        ITypedRegion userRegion = this.getUserRegion();
        if (userRegion != null) {
            this.stack.push(userRegion);
        }
        this.processTag(end);
    }

    public void addUserRegion(ITypedRegion userRegion) {
        this.userOutput.add(userRegion);
    }

    public boolean hasUserPartitions() {
        return !this.userOutput.isEmpty();
    }

    public boolean inTag() {
        return !this.stack.isEmpty();
    }

    Stack<ITypedRegion> getStack() {
        return this.stack;
    }

    public void resetUserPartitions() {
        this.userOutput = new Vector();
    }

    private void processTag(ITypedRegion end) {
        TLCRegion region;
        int messageCode = this.getMessageCode(end, 2);
        ITypedRegion[] stackContent = this.getFindStart(messageCode);
        TLCRegion start = (TLCRegion)stackContent[stackContent.length - 1];
        int length = end.getOffset() - start.getLength() - start.getOffset();
        int offset = start.getOffset() + start.getLength();
        if (stackContent.length > 1) {
            region = new TLCRegionContainer(offset, length - 1);
            Vector<ITypedRegion> regions = new Vector<ITypedRegion>();
            int i = 0;
            while (i < stackContent.length - 1) {
                regions.add(stackContent[i]);
                if (stackContent[i] instanceof TLCRegion) {
                    int shift;
                    if (offset == stackContent[i].getOffset() - 27) {
                        if (length - 24 == stackContent[i].getLength()) {
                            length = -1;
                            offset = -1;
                        } else {
                            shift = 27 + stackContent[i].getLength();
                            offset += shift;
                            length -= shift;
                        }
                    } else if (offset + length - 24 == stackContent[i].getOffset() + stackContent[i].getLength()) {
                        shift = stackContent[i].getLength();
                        length -= shift;
                    } else {
                        throw new IllegalArgumentException("Bug parsing the regions");
                    }
                }
                ++i;
            }
            ((TLCRegionContainer)region).setSubRegions(regions);
        } else {
            region = new TLCRegion(offset, length - 1);
        }
        region.setMessageCode(start.getMessageCode());
        region.setSeverity(start.getSeverity());
        if (this.inTag()) {
            this.stack.push(region);
        } else {
            this.taggedRegion = region;
        }
    }

    private ITypedRegion[] getFindStart(int code) {
        Assert.isTrue((!this.stack.isEmpty() ? 1 : 0) != 0, (String)"Bug. Empty stack, start tag expected");
        Vector<ITypedRegion> elements = new Vector<ITypedRegion>();
        while (!this.stack.isEmpty()) {
            ITypedRegion region = this.stack.pop();
            elements.add(region);
            if (!"__tlc_tag_open".equals(region.getType())) continue;
            TLCRegion startRegion = (TLCRegion)region;
            Assert.isTrue((startRegion.getMessageCode() == code ? 1 : 0) != 0, (String)"Found a non-matching start. This is a bug.");
            break;
        }
        return elements.toArray(new ITypedRegion[elements.size()]);
    }

    public ITypedRegion getUserRegion() {
        if (this.hasUserPartitions()) {
            ITypedRegion region = PartitionToolkit.mergePartitions((ITypedRegion[])this.userOutput.toArray(new TypedRegion[this.userOutput.size()]));
            this.resetUserPartitions();
            return region;
        }
        return null;
    }

    public TLCRegion getTaggedRegion() {
        return this.taggedRegion;
    }

    private int getMessageCode(ITypedRegion region, int type) {
        try {
            int index;
            String text = this.document.get(region.getOffset(), region.getLength());
            switch (type) {
                case 1: {
                    index = text.indexOf(":");
                    break;
                }
                case 2: {
                    index = text.lastIndexOf(" @!@!@");
                    break;
                }
                default: {
                    index = -1;
                }
            }
            if (index == -1) {
                Assert.isTrue((index != -1 ? 1 : 0) != 0, (String)"Could not read message code");
            }
            String number = text.substring(text.indexOf(" ") + 1, index);
            return Integer.parseInt(number);
        }
        catch (BadLocationException e) {
            TLCUIActivator.getDefault().logError("Error retrieving the TLC message code", e);
        }
        catch (NumberFormatException e) {
            TLCUIActivator.getDefault().logError("Error retrieving the TLC message code", e);
        }
        return -1;
    }

    private int getSeverity(ITypedRegion region) {
        try {
            String text = this.document.get(region.getOffset(), region.getLength());
            int index = text.indexOf(":");
            String number = text.substring(index + 1, text.indexOf(" ", index));
            return Integer.parseInt(number);
        }
        catch (BadLocationException e) {
            TLCUIActivator.getDefault().logError("Error retrieving the TLC message severity", e);
            return -1;
        }
    }
}

