/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.internal;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.IProcessOutputSink;

public class BroadcastStreamListener
implements IStreamListener {
    private IProcessOutputSink[] listeners = null;

    public BroadcastStreamListener(Model model, int kind) {
        this.listeners = this.getRegisteredStreamManagers(model, kind);
    }

    public synchronized void streamAppended(String text, IStreamMonitor monitor) {
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] != null) {
                try {
                    this.listeners[i].appendText(text);
                }
                catch (Exception e) {
                    TLCActivator.logError("Error broadcasting the message", e);
                }
            }
            ++i;
        }
    }

    public synchronized void streamClosed() {
        int i = 0;
        while (i < this.listeners.length) {
            try {
                if (this.listeners[i] != null) {
                    this.listeners[i].processFinished();
                }
            }
            catch (Exception e) {
                TLCActivator.logError("Error broadcasting the stream closed event", e);
            }
            ++i;
        }
    }

    private IProcessOutputSink[] getRegisteredStreamManagers(Model model, int type) {
        IConfigurationElement[] decls = Platform.getExtensionRegistry().getConfigurationElementsFor("org.lamport.tla.toolbox.tlc.processOutputSink");
        Vector<IProcessOutputSink> validExtensions = new Vector<IProcessOutputSink>();
        int i = 0;
        while (i < decls.length) {
            try {
                IProcessOutputSink extension = (IProcessOutputSink)decls[i].createExecutableExtension("class");
                extension.initializeSink(model, type);
                validExtensions.add(extension);
            }
            catch (CoreException e) {
                TLCActivator.logError("Error instatiating the IProcessSink extension", e);
            }
            ++i;
        }
        return validExtensions.toArray(new IProcessOutputSink[validExtensions.size()]);
    }
}

