/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.IProcessOutputSink;
import org.lamport.tla.toolbox.util.ResourceHelper;

public class FileProcessOutputSink
implements IProcessOutputSink {
    protected ISchedulingRule rule;
    protected IFile outFile;
    private Model model;

    @Override
    public synchronized void appendText(final String text) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FileProcessOutputSink.this.outFile.appendContents((InputStream)new ByteArrayInputStream(text.getBytes()), 1, monitor);
                }
            }, this.rule, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            TLCActivator.logError("Error writing the TLC process output file for " + this.model.getName(), e);
        }
    }

    @Override
    public void initializeSink(Model model, int sinkType) {
        boolean isTraceExplore = sinkType == 3;
        this.model = model;
        this.outFile = model.getOutputLogFile(isTraceExplore);
        this.rule = ResourceHelper.getModifyRule((IResource)this.outFile);
    }

    @Override
    public void processFinished() {
    }
}

