/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.util;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.util.ResourceHelper;

public abstract class ChangedSpecModulesGatheringDeltaVisitor
implements IResourceDeltaVisitor {
    private final IContainer rootFileParent;
    private Vector<IResource> modules = new Vector();
    private IResource model = null;
    private boolean checkpointsChanged = false;
    private final IFolder modelDir;

    public ChangedSpecModulesGatheringDeltaVisitor(Model model) {
        this.modelDir = model.getTargetDirectory();
        this.rootFileParent = Activator.getSpecManager().getSpecLoaded().getRootFile().getParent();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (1 == resource.getType()) {
            if (ResourceHelper.isModule((IResource)resource) && resource.getParent().equals((Object)this.rootFileParent)) {
                this.modules.add(resource);
            } else if (this.getModel() != null && this.getModel().equals((Object)resource)) {
                this.model = resource;
                return false;
            }
        } else if (2 == resource.getType() && this.modelDir != null && this.modelDir.exists() && this.modelDir.equals((Object)resource)) {
            this.checkpointsChanged = true;
            return false;
        }
        return true;
    }

    public List<IResource> getModules() {
        return this.modules;
    }

    public abstract IResource getModel();

    public boolean isModelChanged() {
        return this.model != null;
    }

    public boolean getCheckpointChanged() {
        return this.checkpointsChanged;
    }
}

