/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.model;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.model.AbstractModelStateChangeListener;
import org.lamport.tla.toolbox.tool.tlc.model.ModelCoverage;
import org.lamport.tla.toolbox.tool.tlc.model.TLCModelFactory;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tlc2.model.Formula;
import tlc2.model.MCState;

public class Model
implements IModelConfigurationConstants,
IAdaptable {
    private static final String TLC_MODEL_ERROR_MARKER = "org.lamport.tla.toolbox.tlc.modelErrorMarker";
    private static final String IS_ORIGINAL_TRACE_SHOWN = "isOriginalTraceShown";
    private static final String TLC_MODEL_IN_USE_MARKER = "org.lamport.tla.toolbox.tlc.modelMarker";
    private static final String TLC_CRASHED_MARKER = "org.lamport.tla.toolbox.tlc.crashedModelMarker";
    private static final String TRACE_EXPLORER_MARKER = "org.lamport.tla.toolbox.tlc.traceExplorerMarker";
    private static final Collection<Model> EMPTY_MODEL_SET = Collections.unmodifiableList(new ArrayList());
    public static final String SPEC_MODEL_DELIM = "___";
    private final Set<AbstractModelStateChangeListener> listeners = new CopyOnWriteArraySet<AbstractModelStateChangeListener>();
    private TLCSpec spec;
    private ILaunchConfiguration launchConfig;
    private ILaunchConfigurationWorkingCopy workingCopy;
    private ILaunch launch;
    public static final String TLC_MODEL_ERROR_MARKER_SANY = "org.lamport.tla.toolbox.tlc.modelErrorSANY";
    private boolean isRunningRemotely = false;
    private static final String SNAP_SHOT = "_SnapShot_";
    static final String SNAPSHOT_REGEXP = "_SnapShot_[0-9]*$";
    private static final String DOT_FILE_EXT = ".dot";
    private static final String CHECKPOINT_STATES = "MC.st.chkpt";
    private static final String CHECKPOINT_QUEUE = "queue.chkpt";
    private static final String CHECKPOINT_VARS = "vars.chkpt";

    static String sanitizeName(String aModelName) {
        Assert.isNotNull((Object)aModelName);
        if (aModelName.contains(SPEC_MODEL_DELIM)) {
            aModelName = aModelName.split(SPEC_MODEL_DELIM)[1];
        }
        if (aModelName.endsWith(".launch")) {
            aModelName = aModelName.substring(0, aModelName.length() - ".launch".length());
        }
        return aModelName;
    }

    public static Model getByName(String modelName) {
        return TLCModelFactory.getByName(modelName);
    }

    public static String fullyQualifiedNameFromSpecNameAndModelName(String specName, String modelName) {
        return specName + SPEC_MODEL_DELIM + modelName;
    }

    protected Model(ILaunchConfiguration launchConfig) {
        Assert.isNotNull((Object)launchConfig);
        this.launchConfig = launchConfig;
    }

    public boolean add(AbstractModelStateChangeListener stateChangeListener) {
        return this.listeners.add(stateChangeListener);
    }

    public boolean remove(AbstractModelStateChangeListener stateChangeListener) {
        return this.listeners.remove(stateChangeListener);
    }

    private void notifyListener(AbstractModelStateChangeListener.ChangeEvent event) {
        for (AbstractModelStateChangeListener scl : this.listeners) {
            if (!scl.handleChange(event)) continue;
            this.listeners.remove(scl);
        }
    }

    public TLCSpec getSpec() {
        if (this.spec == null) {
            String launchName = this.launchConfig.getName();
            Assert.isTrue((boolean)launchName.contains(SPEC_MODEL_DELIM));
            Spec spec = ToolboxHandle.getSpecByName((String)launchName.split(SPEC_MODEL_DELIM)[0]);
            Assert.isNotNull((Object)spec, (String)("Failed to lookup spec with name " + launchName.split(SPEC_MODEL_DELIM)[0] + " (" + launchName + ")"));
            this.spec = (TLCSpec)((Object)spec.getAdapter(TLCSpec.class));
        }
        return this.spec;
    }

    public Model copy(String newModelName) {
        String sanitizedNewName = Model.sanitizeName(newModelName);
        try {
            String fullyQualified = Model.fullyQualifiedNameFromSpecNameAndModelName(this.spec.getName(), sanitizedNewName);
            ILaunchConfigurationWorkingCopy copy = this.launchConfig.copy(fullyQualified);
            copy.setAttribute("specName", this.spec.getName());
            copy.setAttribute("configurationName", sanitizedNewName);
            return (Model)copy.doSave().getAdapter(Model.class);
        }
        catch (CoreException e) {
            TLCActivator.logError("Error cloning model.", e);
            return null;
        }
    }

    public Model copyIntoForeignSpec(Spec foreignSpec, String newModelName) {
        IProject foreignProject = foreignSpec.getProject();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.lamport.tla.toolbox.tool.tlc.modelCheck");
        String sanitizedNewName = Model.sanitizeName(newModelName);
        String wholeName = Model.fullyQualifiedNameFromSpecNameAndModelName(foreignSpec.getName(), sanitizedNewName);
        try {
            ILaunchConfigurationWorkingCopy copy = launchConfigurationType.newInstance((IContainer)foreignProject, wholeName);
            this.copyAttributesFromForeignModelToWorkingCopy(this, copy);
            copy.setAttribute("specName", foreignSpec.getName());
            copy.setAttribute("configurationName", sanitizedNewName);
            return (Model)copy.doSave().getAdapter(Model.class);
        }
        catch (CoreException e) {
            TLCActivator.logError("Error cloning foreign model.", e);
            return null;
        }
    }

    private void copyAttributesFromForeignModelToWorkingCopy(Model foreignModel, ILaunchConfigurationWorkingCopy copy) throws CoreException {
        ILaunchConfiguration foreignILC = foreignModel.getLaunchConfiguration();
        Map workingCopyAttributes = copy.getAttributes();
        Map foreignAttributes = foreignILC.getAttributes();
        for (Map.Entry me : foreignAttributes.entrySet()) {
            copy.setAttribute((String)me.getKey(), me.getValue());
            workingCopyAttributes.remove(me.getKey());
        }
        for (String key : workingCopyAttributes.keySet()) {
            copy.removeAttribute(key);
        }
    }

    public void rename(String newModelName, IProgressMonitor monitor) throws CoreException {
        Collection<Model> snapshots = this.getSnapshots();
        IFolder modelDir = this.getTargetDirectory();
        if (modelDir != null && modelDir.exists()) {
            IPath src = modelDir.getFullPath();
            IPath dst = src.removeLastSegments(1).append(newModelName);
            modelDir.move(dst, true, monitor);
        }
        this.renameLaunch(this.getSpec(), Model.sanitizeName(newModelName));
        for (Model snapshot : snapshots) {
            snapshot.rename(newModelName + snapshot.getSnapshotSuffix(), monitor);
        }
    }

    void specRename(Spec newSpec) {
        Collection<Model> snapshots = this.getSnapshots();
        this.renameLaunch(newSpec, this.getName());
        this.spec = null;
        for (Model snapshot : snapshots) {
            snapshot.specRename(newSpec);
        }
    }

    private void renameLaunch(Spec newSpec, String newModelName) {
        try {
            String fullyQualifiedName = Model.fullyQualifiedNameFromSpecNameAndModelName(newSpec.getName(), newModelName);
            ILaunchConfigurationWorkingCopy copy = this.launchConfig.copy(fullyQualifiedName);
            copy.setAttribute("specName", newSpec.getName());
            copy.setAttribute("configurationName", newModelName);
            copy.setContainer((IContainer)newSpec.getProject());
            ILaunchConfiguration renamed = copy.doSave();
            IFileStore ifs = ((LaunchConfiguration)this.launchConfig).getFileStore();
            if (ifs != null) {
                IPath newToolboxName = renamed.getFile().getFullPath().removeLastSegments(1);
                URI u = ifs.toURI();
                File oldLaunchConfigFile = new File(u);
                File grandParentDirectory = oldLaunchConfigFile.getParentFile().getParentFile();
                String newToolboxDirectoryName = newToolboxName.toString() + ".toolbox";
                File fileToDelete = Paths.get(grandParentDirectory.getAbsolutePath(), newToolboxDirectoryName, oldLaunchConfigFile.getName()).toFile();
                if (!fileToDelete.delete()) {
                    TLCActivator.logInfo("Could not delete old launch file [" + fileToDelete.getAbsolutePath() + "] - will attempt on app exit, which is better than nothing.");
                    fileToDelete.deleteOnExit();
                }
            } else {
                TLCActivator.logInfo("Could not get filestore for the original launch config; this is problematic.");
            }
            this.launchConfig.delete();
            this.launchConfig = renamed;
        }
        catch (CoreException e) {
            TLCActivator.logError("Error renaming model.", e);
        }
    }

    public String getName() {
        try {
            return this.launchConfig.getAttribute("configurationName", null);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            return null;
        }
    }

    public String getComments() {
        try {
            return this.launchConfig.getAttribute("modelComments", "");
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            return "";
        }
    }

    public boolean isRunning() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.getLaunchConfiguration() != null && launch.getLaunchConfiguration().contentsEqual(this.launchConfig) && !launch.isTerminated()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setRunning(boolean isRunning) {
        if (isRunning) {
            this.recover();
        }
        this.notifyListener(new AbstractModelStateChangeListener.ChangeEvent(this, isRunning ? AbstractModelStateChangeListener.State.RUNNING : AbstractModelStateChangeListener.State.NOT_RUNNING));
    }

    public boolean isStale() {
        IFile resource = this.getFile();
        if (resource.exists()) {
            try {
                IMarker[] foundMarkers = resource.findMarkers(TLC_CRASHED_MARKER, false, 0);
                return foundMarkers.length > 0;
            }
            catch (CoreException shouldNotHappen) {
                TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            }
        }
        return false;
    }

    public void setStale() {
        try {
            this.getFile().createMarker(TLC_CRASHED_MARKER);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public boolean isRunningRemotely() {
        return this.isRunningRemotely;
    }

    public void setRunningRemotely(boolean isRunning) {
        this.isRunningRemotely = isRunning;
        this.notifyListener(new AbstractModelStateChangeListener.ChangeEvent(this, isRunning ? AbstractModelStateChangeListener.State.REMOTE_RUNNING : AbstractModelStateChangeListener.State.REMOTE_NOT_RUNNING));
    }

    private String getSnapshotSuffix() {
        if (this.isSnapshot()) {
            int idx = this.getName().lastIndexOf(SNAP_SHOT);
            return this.getName().substring(idx, this.getName().length());
        }
        return "";
    }

    public long getSnapshotTimeStamp() {
        int idx = this.getName().lastIndexOf(SNAP_SHOT) + 10;
        return Long.valueOf(this.getName().substring(idx));
    }

    public Collection<Model> getSnapshots() {
        if (this.isSnapshot()) {
            return EMPTY_MODEL_SET;
        }
        return this.getSpec().getModels(Pattern.quote(this.getName()) + SNAPSHOT_REGEXP, true).values();
    }

    public boolean isSnapshot() {
        String name = this.getName();
        if (name == null) {
            return false;
        }
        return name.matches(".*_SnapShot_[0-9]*$");
    }

    public boolean hasSnapshots() {
        return !this.getSpec().getModels(Pattern.quote(this.getName()) + SNAPSHOT_REGEXP, true).isEmpty();
    }

    public Model getSnapshotFor() {
        return this.getSpec().getModel(this.getName().replaceFirst(SNAPSHOT_REGEXP, ""));
    }

    public Model snapshot() throws CoreException {
        IMarker[] markers;
        Model snapshot = this.copy(this.getName() + SNAP_SHOT + System.currentTimeMillis());
        IMarker[] iMarkerArray = markers = this.getMarkers();
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            snapshot.setMarker(iMarker.getAttributes(), iMarker.getType());
            ++n2;
        }
        IPath snapshotPath = this.getSpec().getProject().getFolder(snapshot.getName()).getLocation();
        IPath modelFolder = this.getSpec().getProject().getFolder(this.getName()).getLocation();
        try {
            FileUtils.copyDirectory((File)modelFolder.toFile(), (File)snapshotPath.toFile(), (FileFilter)new NotFileFilter(DirectoryFileFilter.DIRECTORY));
            if (this.hasStateGraphDump()) {
                IPath oldDotFile = this.getSpec().getProject().getFolder(snapshot.getName() + File.separator + this.getName() + DOT_FILE_EXT).getLocation();
                IPath newDotFile = this.getSpec().getProject().getFolder(snapshot.getName() + File.separator + snapshot.getName() + DOT_FILE_EXT).getLocation();
                FileUtils.moveFile((File)oldDotFile.toFile(), (File)newDotFile.toFile());
            }
            this.pruneOldestSnapshots();
            snapshot.getFolder().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", e.getMessage(), (Throwable)e));
        }
        return snapshot;
    }

    private void pruneOldestSnapshots() throws CoreException {
        int snapshotKeepCount = TLCActivator.getDefault().getPreferenceStore().getInt("numberOfSnapshotsToKeep");
        ArrayList snapshotModels = new ArrayList(this.getSnapshots().stream().filter(m -> !m.isRunning() && !m.isRunningRemotely()).collect(Collectors.toList()));
        if (snapshotModels.size() > snapshotKeepCount) {
            int pruneCount = snapshotModels.size() - snapshotKeepCount;
            Collections.sort(snapshotModels, new Comparator<Model>(){

                @Override
                public int compare(Model model1, Model model2) {
                    long ts1 = model1.getSnapshotTimeStamp();
                    long ts2 = model2.getSnapshotTimeStamp();
                    return Long.compare(ts1, ts2);
                }
            });
            int i = 0;
            while (i < pruneCount) {
                Model model = (Model)snapshotModels.get(i);
                model.delete((IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    public boolean hasStateGraphDump() {
        String name = this.getName().concat(DOT_FILE_EXT);
        File file = this.getFolder().getFile(name).getLocation().toFile();
        return file.exists();
    }

    public IFile getStateGraphDump() {
        String name = this.getName().concat(DOT_FILE_EXT);
        return this.getFolder().getFile(name);
    }

    public boolean isOriginalTraceShown() {
        return this.isMarkerSet(TRACE_EXPLORER_MARKER, IS_ORIGINAL_TRACE_SHOWN);
    }

    public void setOriginalTraceShown(boolean isOriginalTraceShown) {
        this.setMarker(TRACE_EXPLORER_MARKER, IS_ORIGINAL_TRACE_SHOWN, isOriginalTraceShown);
    }

    public boolean hasError() {
        return this.getMarkers().length > 0;
    }

    private boolean isMarkerSet(String markerType, String attributeName) {
        IFile resource = this.getFile();
        if (resource.exists()) {
            try {
                IMarker[] foundMarkers = resource.findMarkers(markerType, false, 0);
                if (foundMarkers.length > 0) {
                    boolean set = foundMarkers[0].getAttribute(attributeName, false);
                    int i = 1;
                    while (i < foundMarkers.length) {
                        foundMarkers[i].delete();
                        ++i;
                    }
                    return set;
                }
                return false;
            }
            catch (CoreException shouldNotHappen) {
                TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            }
        }
        return false;
    }

    private void setMarker(String markerType, String attributeName, boolean value) {
        IFile resource = this.getFile();
        if (resource.exists()) {
            try {
                IMarker marker;
                IMarker[] foundMarkers = resource.findMarkers(markerType, false, 0);
                if (foundMarkers.length > 0) {
                    marker = foundMarkers[0];
                    int i = 1;
                    while (i < foundMarkers.length) {
                        foundMarkers[i].delete();
                        ++i;
                    }
                } else {
                    marker = resource.createMarker(markerType);
                }
                marker.setAttribute(attributeName, value);
            }
            catch (CoreException shouldNotHappen) {
                TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            }
        }
    }

    public IMarker setMarker(Map<String, Object> properties, String markerType) {
        try {
            IMarker[] existingMarkers;
            IMarker[] iMarkerArray = existingMarkers = this.getFile().findMarkers(markerType, false, 0);
            int n = existingMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                if (properties.equals(iMarker.getAttributes())) {
                    iMarker.delete();
                }
                ++n2;
            }
            IMarker marker = this.getFile().createMarker(markerType);
            marker.setAttributes(properties);
            return marker;
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            return null;
        }
    }

    public IMarker[] getMarkers() {
        IFile resource = this.getFile();
        if (resource.exists()) {
            try {
                return resource.findMarkers(TLC_MODEL_ERROR_MARKER, true, 0);
            }
            catch (CoreException shouldNotHappen) {
                TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            }
        }
        return new IMarker[0];
    }

    public void removeMarkers(String markerType) {
        try {
            IMarker[] foundMarkers = this.getFile().findMarkers(markerType, true, 1);
            int i = 0;
            while (i < foundMarkers.length) {
                foundMarkers[i].delete();
                ++i;
            }
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public void recover() {
        IFile resource = this.getFile();
        if (resource.exists()) {
            try {
                IMarker[] foundMarkers = resource.findMarkers(TLC_CRASHED_MARKER, false, 0);
                if (foundMarkers.length == 0) {
                    return;
                }
                int i = 0;
                while (i < foundMarkers.length) {
                    foundMarkers[i].delete();
                    ++i;
                }
                foundMarkers = resource.findMarkers(TLC_MODEL_IN_USE_MARKER, false, 0);
                i = 0;
                while (i < foundMarkers.length) {
                    foundMarkers[i].delete();
                    ++i;
                }
            }
            catch (CoreException shouldNotHappen) {
                TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            }
        }
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfig;
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        Collection<Model> snapshots = this.getSnapshots();
        for (Model model : snapshots) {
            model.delete((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        }
        this.notifyListener(new AbstractModelStateChangeListener.ChangeEvent(this, AbstractModelStateChangeListener.State.DELETED));
        IFolder modelFolder = this.getTargetDirectory();
        final IResource[] members = modelFolder != null ? new IResource[]{modelFolder, this.getLaunchConfiguration().getFile()} : new IResource[]{this.getLaunchConfiguration().getFile()};
        ISchedulingRule deleteRule = ResourceHelper.getDeleteRule((IResource[])members);
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor subMonitor) throws CoreException {
                subMonitor.beginTask("Deleting files", members.length);
                try {
                    int i = 0;
                    while (i < members.length) {
                        members[i].delete(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (int)1));
                        ++i;
                    }
                }
                catch (CoreException e) {
                    TLCActivator.logError("Error deleting a file " + e.getMessage(), e);
                    throw e;
                }
                subMonitor.done();
            }
        }, deleteRule, 1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)members.length));
    }

    public IFolder getTargetDirectory() {
        return (IFolder)this.getSpec().getProject().findMember(this.getName());
    }

    public List<IFile> getSavedTLAFiles() {
        try {
            ArrayList<IFile> res = new ArrayList<IFile>();
            IFolder targetDirectory = this.getTargetDirectory();
            if (targetDirectory == null) {
                return res;
            }
            List<IResource> asList = Arrays.asList(targetDirectory.members());
            for (IResource iResource : asList) {
                IFile f;
                if (!(iResource instanceof IFile) || !(f = (IFile)iResource).exists() || !"tla".equalsIgnoreCase(f.getFileExtension())) continue;
                res.add(f);
            }
            return res;
        }
        catch (CoreException e) {
            return new ArrayList<IFile>();
        }
    }

    public IFile getTLAFile() {
        return this.getFile("MC.tla");
    }

    public IFile getTEFile() {
        return this.getFile("TE.tla");
    }

    public IFile getOutputLogFile() {
        return this.getOutputLogFile(false);
    }

    public IFile getOutputLogFile(boolean getTraceExplorerOutput) {
        if (getTraceExplorerOutput) {
            return this.getFile("TE.out");
        }
        return this.getFile("MC.out");
    }

    public IFile getTraceExplorerTLAFile() {
        return this.getFile("TE.tla");
    }

    private IFile getFile(String id) {
        IFile teFile;
        IFolder targetFolder = this.getTargetDirectory();
        if (targetFolder != null && targetFolder.exists() && (teFile = (IFile)targetFolder.findMember(id)) != null && teFile.exists()) {
            return teFile;
        }
        return null;
    }

    public IFile getTraceSourceFile() {
        IFolder targetFolder = this.getTargetDirectory();
        if (targetFolder != null && targetFolder.exists()) {
            IFile logFile = targetFolder.getFile("MC_TE.out");
            Assert.isNotNull((Object)logFile);
            return logFile;
        }
        return null;
    }

    public void createModelOutputLogFile(InputStream is, IProgressMonitor monitor) throws CoreException {
        IFolder targetFolder = this.getTargetDirectory();
        if (targetFolder == null || !targetFolder.exists()) {
            String modelName = this.getName();
            targetFolder = this.getSpec().getProject().getFolder(modelName);
            targetFolder.create(true, true, monitor);
        }
        if (targetFolder != null && targetFolder.exists()) {
            targetFolder.refreshLocal(2, monitor);
            IFile mcOutFile = targetFolder.getFile("MC.out");
            if (mcOutFile.exists()) {
                mcOutFile.delete(true, monitor);
            }
            mcOutFile.create(is, true, monitor);
            IFile mcTEOutfile = targetFolder.getFile("MC_TE.out");
            if (mcTEOutfile.exists()) {
                mcTEOutfile.delete(true, monitor);
            }
            mcOutFile.copy(mcTEOutfile.getFullPath(), true, monitor);
        }
    }

    public IFolder getFolder() {
        return this.getSpec().getProject().getFolder(this.getName());
    }

    public IResource[] getCheckpoints(boolean doRefresh) throws CoreException {
        Pattern pattern = Pattern.compile("[0-9]{2}-[0-9]{2}-[0-9]{2}-[0-9]{2}-[0-9]{2}-[0-9]{2}");
        Vector<IResource> checkpoints = new Vector<IResource>();
        IFolder directory = this.getTargetDirectory();
        if (directory != null && directory.exists()) {
            if (doRefresh) {
                directory.refreshLocal(1, null);
            }
            IResource[] members = directory.members();
            int i = 0;
            while (i < members.length) {
                Matcher matcher;
                if (members[i].getType() == 2 && (matcher = pattern.matcher(members[i].getName())).matches()) {
                    if (doRefresh) {
                        members[i].refreshLocal(1, null);
                    }
                    if (((IFolder)members[i]).findMember(CHECKPOINT_QUEUE) != null && ((IFolder)members[i]).findMember(CHECKPOINT_VARS) != null && ((IFolder)members[i]).findMember(CHECKPOINT_STATES) != null) {
                        checkpoints.add(members[i]);
                    }
                }
                ++i;
            }
        }
        IResource[] result = checkpoints.toArray(new IResource[checkpoints.size()]);
        Arrays.sort(result, new Comparator<IResource>(){

            @Override
            public int compare(IResource arg0, IResource arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return result;
    }

    public List<MCState> getErrorTrace() {
        FileEditorInput logFileEditorInput = new FileEditorInput(this.getTraceSourceFile());
        FileDocumentProvider logFileDocumentProvider = new FileDocumentProvider();
        try {
            logFileDocumentProvider.connect((Object)logFileEditorInput);
            IDocument logFileDocument = logFileDocumentProvider.getDocument((Object)logFileEditorInput);
            FindReplaceDocumentAdapter logFileSearcher = new FindReplaceDocumentAdapter(logFileDocument);
            String regExStartTag = "@!@!@STARTMSG [0-9]{4}:4 @!@!@\n";
            String regExEndTag = "@!@!@ENDMSG [0-9]{4} @!@!@";
            IRegion startTagRegion = logFileSearcher.find(0, regExStartTag, true, true, false, true);
            ArrayList<MCState> trace = new ArrayList<MCState>();
            while (startTagRegion != null) {
                IRegion endTagRegion = logFileSearcher.find(startTagRegion.getOffset() + startTagRegion.getLength(), regExEndTag, true, true, false, true);
                if (endTagRegion != null) {
                    int stateInputStart = startTagRegion.getOffset() + startTagRegion.getLength();
                    int stateInputLength = endTagRegion.getOffset() - stateInputStart;
                    String stateInputString = logFileDocument.get(stateInputStart, stateInputLength);
                    trace.add(MCState.parseState((String)stateInputString));
                } else {
                    TLCActivator.logDebug("Found start tag region in model log file without end tag for model " + this.getName() + ".");
                }
                startTagRegion = logFileSearcher.find(startTagRegion.getOffset() + startTagRegion.getLength(), regExStartTag, true, true, false, true);
            }
            ArrayList<MCState> arrayList = trace;
            return arrayList;
        }
        catch (CoreException e) {
            TLCActivator.logError("Error connecting to model log file for model " + this.getName() + ".", e);
        }
        catch (BadLocationException e) {
            TLCActivator.logError("Error searching model log file for " + this.getName() + ".", e);
        }
        finally {
            logFileDocumentProvider.disconnect((Object)logFileEditorInput);
        }
        return new Vector<MCState>();
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public String getFullyQualifiedName() {
        return Model.fullyQualifiedNameFromSpecNameAndModelName(this.getSpec().getName(), this.getName());
    }

    public void setTraceExplorerExtends(Set<String> modules) {
        try {
            this.getWorkingCopy().setAttribute("traceExploreExtends", modules);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public Set<String> getTraceExplorerExtends() {
        HashSet<String> defaultValue = new HashSet<String>();
        try {
            return this.launchConfig.getAttribute("traceExploreExtends", defaultValue);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            return defaultValue;
        }
    }

    public List<String> getTraceExplorerExpressions() {
        Vector<String> defaultValue = new Vector<String>();
        try {
            return this.launchConfig.getAttribute("traceExploreExpressions", defaultValue);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            return defaultValue;
        }
    }

    public List<Formula> getTraceExplorerExpressionsAsFormula() {
        List<String> traceExplorerExpressions = this.getTraceExplorerExpressions();
        return Formula.deserializeFormulaList(traceExplorerExpressions);
    }

    public Map<String, Formula> getNamedTraceExplorerExpressionsAsFormula() {
        List<Formula> traceExplorerExpressionsAsFormula = this.getTraceExplorerExpressionsAsFormula();
        HashMap<String, Formula> result = new HashMap<String, Formula>();
        for (Formula formula : traceExplorerExpressionsAsFormula) {
            if (!formula.isNamed()) continue;
            result.put(formula.getLeftHandSide(), formula);
        }
        return result;
    }

    public void setTraceExplorerExpression(List<String> serializedInput) {
        try {
            this.getWorkingCopy().setAttribute("traceExploreExpressions", serializedInput);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public void setModelVersion(int version) {
        try {
            this.getWorkingCopy().setAttribute("modelVersion", version);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public int getModelVersion() {
        try {
            return this.getWorkingCopy().getAttribute("modelVersion", 0);
        }
        catch (CoreException shouldNotHappen) {
            return -1;
        }
    }

    public void setOpenTabsValue(int value) {
        try {
            this.getWorkingCopy().setAttribute("modelEditorOpenTabs", value);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public int getOpenTabsValue() {
        try {
            return this.getWorkingCopy().getAttribute("modelEditorOpenTabs", 0);
        }
        catch (CoreException shouldNotHappen) {
            return -1;
        }
    }

    public IFile getFile() {
        return this.getLaunchConfiguration().getFile();
    }

    public ILaunch getLastLaunch() {
        return this.launch;
    }

    public void launch(String mode, IProgressMonitor subProgressMonitor, boolean build) throws CoreException {
        Assert.isTrue((this.workingCopy == null ? 1 : 0) != 0, (String)"Cannot launch dirty model, save first.");
        this.launch = this.launchConfig.launch(mode, subProgressMonitor, build);
    }

    public Model save(IProgressMonitor monitor) {
        this.setModelVersion(20191005);
        if (this.workingCopy != null) {
            if (Thread.currentThread().equals(Display.getDefault().getThread())) {
                TLCActivator.logInfo("Model save is occurring on the SWT thread, this should be addressed.");
            }
            try {
                this.launchConfig = this.workingCopy.doSave();
                this.workingCopy = null;
            }
            catch (CoreException shouldNotHappen) {
                TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            }
        }
        return this;
    }

    private ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        if (this.workingCopy == null) {
            this.workingCopy = this.launchConfig.getWorkingCopy();
        }
        return this.workingCopy;
    }

    public void unsavedSetEvalExpression(String expression) {
        this.setAttribute("modelExpressionEval", expression);
    }

    public String getEvalExpression() {
        try {
            return this.launchConfig.getAttribute("modelExpressionEval", "");
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
            return "";
        }
    }

    public boolean hasAttribute(String key) throws CoreException {
        return this.launchConfig.hasAttribute(key);
    }

    public long getAttribute(String key, long defaultValue) throws CoreException {
        String l = this.launchConfig.getAttribute(key, Long.toString(defaultValue));
        return Long.valueOf(l);
    }

    public int getAttribute(String key, int defaultValue) throws CoreException {
        return this.launchConfig.getAttribute(key, defaultValue);
    }

    public String getAttribute(String key, String defaultValue) throws CoreException {
        return this.launchConfig.getAttribute(key, defaultValue);
    }

    public boolean getAttribute(String key, boolean defaultValue) throws CoreException {
        return this.launchConfig.getAttribute(key, defaultValue);
    }

    public List<String> getAttribute(String key, List<String> defaultValue) throws CoreException {
        return this.launchConfig.getAttribute(key, defaultValue);
    }

    public void setAttribute(String key, int value) {
        try {
            this.getWorkingCopy().setAttribute(key, value);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public void setAttribute(String key, long value) {
        this.setAttribute(key, Long.toString(value));
    }

    public void setAttribute(String key, String value) {
        try {
            this.getWorkingCopy().setAttribute(key, value);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public void setAttribute(String key, boolean value) {
        try {
            this.getWorkingCopy().setAttribute(key, value);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public void setAttribute(String key, List<String> value) {
        try {
            this.getWorkingCopy().setAttribute(key, value);
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
    }

    public ModelCoverage setCoverage(ModelCoverage c) {
        this.setAttribute("collectCoverage", c.ordinal());
        return c;
    }

    public ModelCoverage getCoverage() {
        try {
            int ordinal = this.getAttribute("collectCoverage", 1);
            return ModelCoverage.values()[ordinal];
        }
        catch (DebugException ordinal) {
        }
        catch (CoreException shouldNotHappen) {
            TLCActivator.logError(shouldNotHappen.getMessage(), shouldNotHappen);
        }
        return ModelCoverage.ACTION;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

