/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox;

import java.net.URL;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.lamport.tla.toolbox.AbstractTLCActivator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.WorkspaceSpecManager;
import org.lamport.tla.toolbox.spec.nature.TLAParsingBuilder;
import org.lamport.tla.toolbox.spec.parser.ParserDependencyStorage;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractTLCActivator {
    public static final String PLUGIN_ID = "org.lamport.tla.toolbox";
    public static final String IMG_SPEC_OPEN = "img_spec_open";
    public static final String IMG_SPEC_CLOSED = "img_spec_closed";
    private static Activator plugin;
    private static WorkspaceSpecManager specManager;
    private static final CountDownLatch latch;
    private static ParserDependencyStorage parserDependencyStorage;

    static {
        latch = new CountDownLatch(1);
    }

    public Activator() {
        super(PLUGIN_ID);
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getImageRegistry().put(IMG_SPEC_OPEN, ImageDescriptor.createFromURL((URL)Platform.getBundle((String)PLUGIN_ID).getEntry("/icons/full/obj16/prj_obj.png")));
        this.getImageRegistry().put(IMG_SPEC_CLOSED, ImageDescriptor.createFromURL((URL)Platform.getBundle((String)PLUGIN_ID).getEntry("/icons/full/obj16/cprj_obj.png")));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        WorkspaceJob initializerJob = new WorkspaceJob("Initializing workspace..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int state = context.getBundle().getState();
                while (state != 32 && state != 4) {
                    try {
                        Thread thread = this.getThread();
                        synchronized (thread) {
                            this.getThread().wait(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        Activator.this.logError(e.getMessage(), e);
                    }
                    state = context.getBundle().getState();
                }
                specManager = new WorkspaceSpecManager(monitor);
                latch.countDown();
                return Status.OK_STATUS;
            }
        };
        initializerJob.setRule(workspace.getRuleFactory().buildRule());
        initializerJob.setPriority(30);
        initializerJob.schedule();
        Job.getJobManager().resume();
        workspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    TLAParsingBuilder.OutOfBuildSpecModulesGatheringDeltaVisitor moduleFinder = new TLAParsingBuilder.OutOfBuildSpecModulesGatheringDeltaVisitor();
                    try {
                        if (Activator.isSpecManagerInstantiated()) {
                            Spec spec;
                            delta.accept((IResourceDeltaVisitor)moduleFinder);
                            if (!moduleFinder.getModules().isEmpty() && (spec = Activator.getSpecManager().getSpecLoaded()) != null) {
                                spec.setStatus(-99);
                            }
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error during post save status update", e);
                    }
                }
            }
        }, 1);
    }

    public void stop(BundleContext context) throws Exception {
        if (specManager != null) {
            specManager.terminate();
        }
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        WorkspaceJob saveJob = new WorkspaceJob("Saving workspace..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                return workspace.save(true, monitor);
            }
        };
        saveJob.setRule(workspace.getRuleFactory().buildRule());
        saveJob.schedule();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static WorkspaceSpecManager getSpecManager() {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        return specManager;
    }

    public static synchronized ParserDependencyStorage getModuleDependencyStorage() {
        if (parserDependencyStorage == null) {
            parserDependencyStorage = new ParserDependencyStorage();
        }
        return parserDependencyStorage;
    }

    public static boolean isSpecManagerInstantiated() {
        return specManager != null;
    }
}

