/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.parser;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.nature.TLAParsingBuilderConstants;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.spec.parser.ParseResultBroadcaster;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.RCPNameToFileIStream;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.TLAMarkerHelper;
import org.lamport.tla.toolbox.util.TLAMarkerInformationHolder;
import tla2sany.drivers.SANY;
import tla2sany.drivers.SemanticException;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.LogLevel;
import tla2sany.output.SanyOutput;
import tla2sany.output.SimpleSanyOutput;
import tla2sany.parser.ParseException;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import util.FilenameToStream;
import util.ToolIO;
import util.UniqueString;

public class ModuleParserLauncher {
    public ParseResult parseModule(IResource parseResource, IProgressMonitor monitor) {
        return this.parseModule(parseResource, monitor, true, true);
    }

    public ParseResult parseModule(IResource parseResource, IProgressMonitor monitor, boolean installMarkers, boolean updateStorage) {
        IProject project = parseResource.getProject();
        ToolIO.setUserDir((String)ResourceHelper.getParentDirName(parseResource.getLocation().toOSString()));
        if (installMarkers) {
            TLAMarkerHelper.removeProblemMarkers(parseResource, monitor, "toolbox.markers.TLAParserProblemMarker");
        }
        ParseResult result = this.parseModule(parseResource, monitor, updateStorage);
        this.checkCancel(monitor);
        if (updateStorage && AdapterFactory.isProblemStatus(result.getStatus())) {
            Activator.getModuleDependencyStorage().parseFailed(parseResource.getProjectRelativePath().toString());
        }
        this.processParsingErrors(project, result);
        if (installMarkers) {
            TLAMarkerHelper.installProblemMarkers(result.getDetectedErrors(), monitor);
        }
        return result;
    }

    private ParseResult parseModule(IResource parseResource, IProgressMonitor monitor, boolean updateStorage) {
        String moduleFilename = parseResource.getLocation().toOSString();
        int specStatus = 0;
        Errors parseErrors = null;
        Errors semanticErrors = null;
        Spec spec = (Spec)parseResource.getProject().getAdapter(Spec.class);
        RCPNameToFileIStream resolver = new RCPNameToFileIStream(spec.getTLALibraryPath());
        ToolIO.reset();
        ToolIO.setDefaultResolver((FilenameToStream)resolver);
        ToolIO.setMode((int)1);
        SpecObj moduleSpec = new SpecObj(ResourceHelper.getModuleName(moduleFilename), (FilenameToStream)resolver);
        long parserCallTime = System.currentTimeMillis();
        try {
            this.checkCancel(monitor);
            SANY.frontEndInitialize();
            this.checkCancel(monitor);
            SimpleSanyOutput out = new SimpleSanyOutput(ToolIO.out, LogLevel.INFO);
            SANY.frontEndParse((SpecObj)moduleSpec, (SanyOutput)out, (boolean)false);
            this.checkCancel(monitor);
            SANY.frontEndSemanticAnalysis((SpecObj)moduleSpec, (SanyOutput)out, (boolean)true);
            this.checkCancel(monitor);
        }
        catch (ParseException e) {
            specStatus = -3;
            parseErrors = moduleSpec.getParseErrors();
        }
        catch (SemanticException e) {
            specStatus = -2;
        }
        if (specStatus > -3 && (semanticErrors = moduleSpec.semanticErrors) != null && semanticErrors.getNumMessages() > 0) {
            specStatus = semanticErrors.isSuccess() ? -1 : -2;
        }
        Vector<Module> userModules = new Vector<Module>();
        boolean rootModuleFound = false;
        final Vector<IResource> resourcesToTimeStamp = new Vector<IResource>();
        Enumeration enumerate = moduleSpec.parseUnitContext.keys();
        while (enumerate.hasMoreElements()) {
            ExternalModuleTable.ExternalModuleTableEntry emt;
            IResource moduleResource;
            this.checkCancel(monitor);
            String moduleName = (String)enumerate.nextElement();
            ParseUnit parseUnit = (ParseUnit)moduleSpec.parseUnitContext.get(moduleName);
            Module module = new Module(parseUnit);
            if (!module.isLibraryModule() && updateStorage && (moduleResource = ResourceHelper.getResourceByModuleName(moduleName)) != null && moduleResource.exists()) {
                resourcesToTimeStamp.add(moduleResource);
                module.setResource(moduleResource);
            }
            if (specStatus > -2 && (emt = (ExternalModuleTable.ExternalModuleTableEntry)moduleSpec.getExternalModuleTable().moduleHashTable.get(UniqueString.uniqueStringOf((String)module.getModuleName()))) != null) {
                module.setNode(emt.getModuleNode());
            }
            if (module.getModuleName().equals(ResourceHelper.getModuleName(moduleFilename))) {
                rootModuleFound = true;
                module.setRoot(true);
            }
            if (module.isLibraryModule()) continue;
            userModules.addElement(module);
            if (module.getAbsolutePath().indexOf(parseResource.getProject().getLocation().toOSString()) == 0) continue;
            ResourceHelper.getLinkedFile((IContainer)parseResource.getProject(), module.getAbsolutePath(), true);
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (IResource resource : resourcesToTimeStamp) {
                        resource.setPersistentProperty(TLAParsingBuilderConstants.LAST_BUILT, String.valueOf(System.currentTimeMillis()));
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error while setting build timestamp on resource.", e);
        }
        if (!rootModuleFound) {
            specStatus = -5;
        }
        if (updateStorage) {
            Activator.getModuleDependencyStorage().put(parseResource.getName(), AdapterFactory.adaptModules(parseResource.getName(), userModules));
        }
        ParseResult parseResult = new ParseResult(specStatus, moduleSpec, parseResource, parseErrors, semanticErrors, parserCallTime);
        ParseResultBroadcaster.getParseResultBroadcaster().broadcastParseResult(parseResult);
        return parseResult;
    }

    private void processParsingErrors(IProject project, ParseResult result) {
        switch (result.getStatus()) {
            case -3: {
                String[] output = ToolIO.getAllMessages();
                int nextMsg = 0;
                while (nextMsg < output.length && output[nextMsg].indexOf("Parsing module") != -1) {
                    ++nextMsg;
                }
                if (nextMsg != 0 && nextMsg != output.length) {
                    String[] aborts;
                    int parsingModuleIndex = output[nextMsg - 1].indexOf("Parsing module") + 15;
                    String nameToFind = output[nextMsg - 1].substring(parsingModuleIndex, output[nextMsg - 1].indexOf(" ", parsingModuleIndex + 1));
                    for (Errors.ErrorDetails abortDetails : result.getParseErrors().getErrorDetails()) {
                        if (abortDetails.getCode() != ErrorCode.MODULE_FILE_CANNOT_BE_FOUND) continue;
                        String abortMsg = abortDetails.getMessage();
                        parsingModuleIndex = abortMsg.indexOf("imported in module ") + 19;
                        nameToFind = abortMsg.substring(parsingModuleIndex, abortMsg.indexOf(".", parsingModuleIndex + 1));
                    }
                    nameToFind = ModuleParserLauncher.correctModuleNameCapitalization(nameToFind, result);
                    IFile module = ResourceHelper.getLinkedFile(result.getParsedResource().getParent(), ResourceHelper.getModuleFileName(nameToFind), false);
                    int[] coordinates = new int[]{-1, -1, -1, -1};
                    Object message = output[nextMsg];
                    if (((String)message).indexOf("Lexical error") != -1 || ((String)message).indexOf("***Parse Error***") != -1) {
                        int[] val = ModuleParserLauncher.findLineAndColumn(0, (String)message);
                        int beginLine = val[0];
                        int beginColumn = val[1];
                        int endLine = 0;
                        int endColumn = 0;
                        if ((val = ModuleParserLauncher.findLineAndColumn(val[2], (String)message))[0] > beginLine || val[0] == beginLine && val[1] >= beginColumn) {
                            endLine = val[0];
                            endColumn = val[1];
                        }
                        coordinates = new int[]{beginLine, beginColumn, endLine, endColumn};
                        String beforeModuleName = ((String)message).substring(0, ModuleParserLauncher.findLineAndColumn(0, (String)message)[2]);
                        String afterModuleName = ((String)message).substring(ModuleParserLauncher.findLineAndColumn(0, (String)message)[2]);
                        message = beforeModuleName + " in module " + module.getName().substring(0, module.getName().length() - 4) + afterModuleName;
                        result.addMarker(new TLAMarkerInformationHolder((IResource)module, module.getName(), 2, coordinates, (String)message));
                        break;
                    }
                    if (((String)message).indexOf("Lexical {error: EOF reached, possibly open comment starting around line ") != -1) {
                        int beginLine = Integer.parseInt(((String)message).substring("Lexical {error: EOF reached, possibly open comment starting around line ".length()));
                        int[] nArray = new int[4];
                        nArray[0] = beginLine;
                        nArray[2] = beginLine;
                        coordinates = nArray;
                        result.addMarker(new TLAMarkerInformationHolder((IResource)module, module.getName(), 2, coordinates, (String)message));
                        break;
                    }
                    if (result.getParseErrors() != null && (aborts = result.getParseErrors().getErrors()).length > 0) {
                        message = aborts[aborts.length - 1];
                    }
                    if (message != null && ((String)message).indexOf("does not match the name") == -1) {
                        coordinates = new int[]{-1, -1, -1, -1};
                    }
                    if (module == null) {
                        result.addMarker(new TLAMarkerInformationHolder((IResource)project, project.getName(), 2, coordinates, (String)message));
                        break;
                    }
                    result.addMarker(new TLAMarkerInformationHolder((IResource)module, module.getName(), 2, coordinates, (String)message));
                    break;
                }
                throw new RuntimeException("Bug Spec.ProcessParsingErrorMessages:1869.\nCan't find module name");
            }
            case -2: 
            case -1: {
                if (result.getSemanticErrors() != null) {
                    String[][] errors = new String[][]{result.getSemanticErrors().getErrors(), result.getSemanticErrors().getWarnings()};
                    int[] holderType = new int[]{2, 1};
                    int j = 0;
                    while (j < errors.length) {
                        int i = 0;
                        while (i < errors[j].length) {
                            int endModuleIdx;
                            int beginModuleIdx;
                            IFile module = null;
                            int[] val = ModuleParserLauncher.findLineAndColumn(0, errors[j][i]);
                            int beginLine = val[0];
                            int beginColumn = val[1];
                            int endLine = 0;
                            int endColumn = 0;
                            if ((val = ModuleParserLauncher.findLineAndColumn(val[2], errors[j][i]))[0] > beginLine || val[0] == beginLine && val[1] >= beginColumn) {
                                endLine = val[0];
                                endColumn = val[1];
                            }
                            if ((beginModuleIdx = errors[j][i].indexOf(" module ")) != -1 && (endModuleIdx = errors[j][i].indexOf("\n", beginModuleIdx += " module ".length())) != -1) {
                                String nameToFind = ModuleParserLauncher.correctModuleNameCapitalization(errors[j][i].substring(beginModuleIdx, endModuleIdx), result);
                                module = ResourceHelper.getLinkedFile(result.getParsedResource().getParent(), ResourceHelper.getModuleFileName(nameToFind), false);
                            }
                            int[] coordinates = new int[]{beginLine, beginColumn, endLine, endColumn};
                            if (module == null) {
                                result.addMarker(new TLAMarkerInformationHolder((IResource)project, project.getName(), holderType[j], coordinates, errors[j][i]));
                            } else {
                                result.addMarker(new TLAMarkerInformationHolder((IResource)module, module.getName(), holderType[j], coordinates, errors[j][i]));
                            }
                            ++i;
                        }
                        ++j;
                    }
                    break;
                }
                throw new RuntimeException("Bug Spec.ProcessParsingErrorMsgs.1418:\nSemantic error detected but no error message found.");
            }
            case -5: {
                result.addMarker(new TLAMarkerInformationHolder((IResource)project, project.getName(), 2, new int[]{-1, -1, -1, -1}, "Could not find module"));
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("No default expected. Still spec.getStatus() returned a value of " + result.getStatus());
            }
        }
    }

    private static final String correctModuleNameCapitalization(String nameToFind, ParseResult result) {
        try {
            IResource[] resources = result.getParsedResource().getParent().members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() == 1) {
                    String resourceName = resources[i].getName().substring(0, resources[i].getName().length() - 4);
                    if (nameToFind.toLowerCase().equals(resourceName.toLowerCase())) {
                        nameToFind = resourceName;
                        break;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error finding modules", e);
        }
        return nameToFind;
    }

    private static final int[] findLineAndColumn(int idx, String message) {
        int[] val = new int[]{-1, -1, message.length()};
        int beginIndex = message.indexOf("line ", idx);
        int offset = 5;
        if (beginIndex != idx) {
            beginIndex = -1;
        }
        if (beginIndex == -1) {
            beginIndex = message.indexOf(" line ", idx);
            offset = 6;
        }
        if (beginIndex != -1) {
            beginIndex += offset;
            while (beginIndex < message.length() && !Character.isDigit(message.charAt(beginIndex))) {
                ++beginIndex;
            }
            int endIndex = beginIndex + 1;
            while (endIndex < message.length() && Character.isDigit(message.charAt(endIndex))) {
                ++endIndex;
            }
            if (beginIndex < message.length()) {
                int otherIndex;
                try {
                    val[0] = Integer.parseInt(message.substring(beginIndex, endIndex));
                }
                catch (Exception e) {
                    val[0] = -1;
                }
                beginIndex = message.indexOf(" column ", endIndex);
                int colOffset = 0;
                if (beginIndex != -1) {
                    colOffset = 8;
                }
                if ((otherIndex = message.indexOf(" col ", endIndex)) != -1 && (beginIndex == -1 || otherIndex < beginIndex)) {
                    beginIndex = otherIndex;
                    colOffset = 5;
                }
                if (beginIndex != -1) {
                    beginIndex += colOffset;
                    while (beginIndex < message.length() && !Character.isDigit(message.charAt(beginIndex))) {
                        ++beginIndex;
                    }
                    endIndex = beginIndex + 1;
                    while (endIndex < message.length() && Character.isDigit(message.charAt(endIndex))) {
                        ++endIndex;
                    }
                    if (beginIndex < message.length()) {
                        try {
                            val[1] = Integer.parseInt(message.substring(beginIndex, endIndex));
                        }
                        catch (Exception e) {
                            val[1] = -1;
                        }
                        val[2] = endIndex;
                    }
                }
            }
        }
        return val;
    }

    protected void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

