/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.WorkspaceSpecManager;
import org.lamport.tla.toolbox.ui.handler.CloseSpecHandler;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class DeleteSpecHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null && (selection = activePage.getSelection("toolbox.view.ToolboxExplorer")) != null && selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
            for (Object next : (IStructuredSelection)selection) {
                CloseSpecHandler handler;
                Boolean result;
                if (!(next instanceof Spec)) continue;
                final Spec spec = (Spec)next;
                boolean answer = MessageDialog.openQuestion((Shell)UIHelper.getShellProvider().getShell(), (String)"Delete specification?", (String)("Do you really want the Toolbox to forget the specification " + spec.getName() + " and delete all its models?"));
                if (!answer) continue;
                WorkspaceSpecManager specManager = Activator.getSpecManager();
                if (specManager.isSpecLoaded(spec) && (result = (Boolean)(handler = new CloseSpecHandler()).execute(event)) != null && !result.booleanValue()) {
                    return null;
                }
                ToolboxJob j = new ToolboxJob("Deleting spec..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        Activator.getSpecManager().removeSpec(spec, monitor, false);
                        return Status.OK_STATUS;
                    }
                };
                j.schedule();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        if (UIHelper.getActivePage() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

