/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.view;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.lamport.tla.toolbox.lifecycle.ToolboxLifecycleParticipant;
import org.lamport.tla.toolbox.ui.view.ProblemView;
import org.lamport.tla.toolbox.util.TLAMarkerHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;

public class ProblemViewResourceListener
extends ToolboxLifecycleParticipant
implements IResourceChangeListener {
    public void postWorkbenchWindowOpen() {
        this.showOrHideProblemView();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 16);
    }

    private void showOrHideProblemView() {
        boolean showProblems = PreferenceStoreHelper.getInstancePreferenceStore().getBoolean("parserPopupErrors");
        if (showProblems) {
            if (TLAMarkerHelper.currentSpecHasProblems()) {
                ProblemView view = (ProblemView)UIHelper.getActivePage().findView("toolbox.view.ProblemView");
                if (view != null) {
                    UIHelper.hideView("toolbox.view.ProblemView");
                }
                UIHelper.openViewNoFocus("toolbox.view.ProblemView");
            } else {
                UIHelper.hideView("toolbox.view.ProblemView");
            }
        }
    }

    private boolean hasMarkerDelta(IResourceChangeEvent event) {
        IMarkerDelta[] deltas = event.findMarkerDeltas("toolbox.markers.ToolboxProblemMarker", true);
        return deltas.length > 0;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.hasMarkerDelta(event)) {
            return;
        }
        UIHelper.runUIAsync(new Runnable(){

            @Override
            public void run() {
                ProblemViewResourceListener.this.showOrHideProblemView();
            }
        });
    }
}

