/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.compare.ResourceNameComparator;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;
import pcal.TLAtoPCalMapping;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.Context;
import tla2sany.semantic.ExternalModuleTable;
import util.UniqueString;

public class Spec
implements IAdaptable {
    private final Map<String, TLAtoPCalMapping> spec2mappings = new HashMap<String, TLAtoPCalMapping>();
    private final Deque<Pair> openDecls = new ArrayDeque<Pair>();
    private String moduleToShow = null;
    private IMarker[] markersToShow = null;
    private int currentSelection = 0;
    private long size = 0L;
    private final IProject project;
    private IFile rootFile;
    private int status;
    private SpecObj specObj;
    private final Lock lock = new ReentrantLock(true);

    public Spec(IProject project) {
        Assert.isNotNull((Object)project);
        this.project = project;
        this.initProjectProperties();
    }

    public Spec(IProject project, IFile rootFile) {
        Assert.isNotNull((Object)project);
        this.project = project;
        Assert.isNotNull((Object)rootFile);
        this.rootFile = rootFile;
    }

    public static Spec createNewSpec(String name, String rootFilename, boolean importExisting, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourceHelper.getProject(name, rootFilename, true, importExisting, monitor);
        PreferenceStoreHelper.storeRootFilename(project, rootFilename);
        Spec spec = new Spec(project);
        spec.setLastModified();
        return spec;
    }

    private void initProjectProperties() {
        this.rootFile = PreferenceStoreHelper.readProjectRootFile(this.project);
        this.specObj = null;
        this.status = -99;
        this.size = ResourceHelper.getSizeOfJavaFileResource((IResource)this.project);
        if (this.rootFile == null) {
            Activator.getDefault().logError("A spec did not load correctly, probably because it was modified outside the Toolbox.\n Error occurred in toolbox/spec/Spec.initProjectProperties()", null);
        } else {
            this.getTpMapping(this.rootFile.getName());
        }
    }

    public Date getLastModified() {
        if (-1L == this.project.getModificationStamp()) {
            return null;
        }
        return new Date(this.project.getModificationStamp());
    }

    public void setLastModified() {
        try {
            this.project.touch((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error changing the timestamp of the spec", e);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.project.getName();
    }

    public String getRootFilename() {
        IPath location = this.rootFile.getLocation();
        return location.toOSString();
    }

    public IFile getRootFile() {
        return this.rootFile;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        Activator.getSpecManager().specParsed(this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        IAdapterManager manager = Platform.getAdapterManager();
        return (T)manager.getAdapter((Object)this, adapter);
    }

    public IResource[] getModuleResources() {
        IResource[] modules = null;
        try {
            modules = this.getProject().members(0);
            ArrayList<IResource> moduleList = new ArrayList<IResource>(Arrays.asList(modules));
            Collections.sort(moduleList, new ResourceNameComparator());
            return moduleList.toArray(new IResource[moduleList.size()]);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error retrieving the the spec modules", e);
            modules = new IResource[]{};
            return modules;
        }
    }

    public SpecObj getRootModule() {
        return this.specObj;
    }

    public String getRootModuleName() {
        String fileExtension = this.rootFile.getFileExtension();
        return this.rootFile.getName().replaceFirst("." + fileExtension + "$", "");
    }

    public SpecObj getValidRootModule() {
        if (AdapterFactory.isProblemStatus(this.status)) {
            return null;
        }
        return this.getRootModule();
    }

    public void setSpecObj(SpecObj specObj) {
        this.specObj = specObj;
    }

    public void setOpenDeclModuleName(ITextEditor editor) {
        this.setOpenDeclModuleName(editor, (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public void setOpenDeclModuleName(ITextEditor editor, ITextSelection selection) {
        this.openDecls.push(new Pair(editor, selection));
    }

    public Pair getOpenDeclModuleName() {
        return this.openDecls.poll();
    }

    public void setModuleToShow(String moduleToShow) {
        this.moduleToShow = moduleToShow;
    }

    public String getModuleToShow() {
        return this.moduleToShow;
    }

    public void setMarkersToShow(IMarker[] markersToShow) {
        this.markersToShow = markersToShow;
    }

    public IMarker[] getMarkersToShow() {
        return this.markersToShow;
    }

    public void setCurrentSelection(int currentSelection) {
        this.currentSelection = currentSelection;
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String[] getTLALibraryPath() {
        return ResourceHelper.getTLALibraryPath(this.project);
    }

    public String getTLALibraryPathAsVMArg() {
        String[] tlaLibraryPath = this.getTLALibraryPath();
        if (tlaLibraryPath.length > 0) {
            StringBuffer buf = new StringBuffer(tlaLibraryPath.length * 2);
            buf.append("-DTLA-Library=");
            String[] stringArray = tlaLibraryPath;
            int n = tlaLibraryPath.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                buf.append(location);
                buf.append(File.pathSeparator);
                ++n2;
            }
            String vmArg = buf.toString();
            return vmArg.substring(0, vmArg.length() - 1);
        }
        return "";
    }

    public String getTLALibraryPathAsClassPath() {
        String[] tlaLibraryPath = this.getTLALibraryPath();
        if (tlaLibraryPath.length > 0) {
            StringBuffer buf = new StringBuffer(tlaLibraryPath.length * 2);
            String[] stringArray = tlaLibraryPath;
            int n = tlaLibraryPath.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                if (new File(location).isDirectory()) {
                    buf.append(location + File.separator + "*");
                } else {
                    buf.append(location);
                }
                buf.append(File.pathSeparator);
                ++n2;
            }
            String vmArg = buf.toString();
            return vmArg.substring(0, vmArg.length() - 1);
        }
        return "";
    }

    public TLAtoPCalMapping getTpMapping(String filename) {
        this.lock.lock();
        try {
            TLAtoPCalMapping mapping = this.spec2mappings.get(filename);
            if (mapping == null) {
                mapping = ResourceHelper.readTLAtoPCalMapping(this.project, filename);
                if (mapping == null) {
                    mapping = new NullTLAtoPCalMapping();
                }
                this.spec2mappings.put(filename, mapping);
            }
            if (mapping instanceof NullTLAtoPCalMapping) {
                return null;
            }
            TLAtoPCalMapping tLAtoPCalMapping = mapping;
            return tLAtoPCalMapping;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TLAtoPCalMapping setTpMapping(TLAtoPCalMapping mapping, String filename, IProgressMonitor monitor) {
        if (mapping == null || filename == null || monitor == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            TLAtoPCalMapping oldMapping = this.spec2mappings.put(filename, mapping);
            if (!mapping.equals((Object)oldMapping)) {
                SubMonitor subProgressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                subProgressMonitor.setTaskName("Writing TLA+ to PCal mapping for " + filename);
                try {
                    Assert.isTrue((boolean)ResourceHelper.writeTLAtoPCalMapping(this.project, filename, mapping, (IProgressMonitor)subProgressMonitor));
                }
                finally {
                    subProgressMonitor.done();
                }
            }
            TLAtoPCalMapping tLAtoPCalMapping = oldMapping;
            return tLAtoPCalMapping;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCurrentSpec() {
        return Activator.getSpecManager().getSpecLoaded() == this;
    }

    public Module getModule(String moduleName) {
        List<Module> modules = this.getModules();
        for (Module module : modules) {
            if (!moduleName.equals(module.getModuleName())) continue;
            return module;
        }
        return null;
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        IResource[] moduleResources = this.getModuleResources();
        int i = 0;
        while (i < moduleResources.length) {
            if (ResourceHelper.isModule(moduleResources[i])) {
                Module module = new Module(moduleResources[i]);
                module.setRoot(ResourceHelper.isRoot((IFile)moduleResources[i]));
                modules.add(module);
            }
            ++i;
        }
        return modules;
    }

    public boolean declares(String str) {
        return this.declares(UniqueString.uniqueStringOf((String)str));
    }

    public boolean declares(UniqueString us) {
        ExternalModuleTable externalModuleTable;
        Context context;
        if (this.getRootModule() != null && (context = (externalModuleTable = this.getRootModule().getExternalModuleTable()).getContextForRootModule()) != null) {
            return context.occurSymbol((Object)us);
        }
        return false;
    }

    public void deleteMarker(String markerType) throws CoreException {
        this.getRootFile().deleteMarkers(markerType, true, 2);
        IResource[] iResourceArray = this.getModuleResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            r.deleteMarkers(markerType, true, 2);
            ++n2;
        }
    }

    private static class NullTLAtoPCalMapping
    extends TLAtoPCalMapping {
        private NullTLAtoPCalMapping() {
        }
    }

    public static class Pair {
        public final ITextEditor editor;
        public final ITextSelection selection;

        public Pair(ITextEditor editor, ITextSelection selection) {
            this.editor = editor;
            this.selection = selection;
        }
    }
}

