/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.linter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.SymbolNode;
import util.UniqueString;

public class Linter {
    public void lint(ModuleNode m, ExternalModuleTable moduleTable, Errors errors) {
        this.lintRecords(m, errors);
    }

    private void lintRecords(ModuleNode m, Errors errors) {
        List<OpApplNode> records = Arrays.asList(m.getRecords());
        List allRecords = m.getExtendedModuleSet(true).stream().flatMap(mod -> Arrays.stream(mod.getRecords())).collect(Collectors.toList());
        allRecords.addAll(records);
        for (OpApplNode record : records) {
            List<OpApplNode> fieldPairs = Linter.getFieldPairs(record);
            for (OpApplNode fp : fieldPairs) {
                StringNode lhs = (StringNode)fp.getArgs()[0];
                ExprOrOpArgNode rhs = fp.getArgs()[1];
                SymbolNode s = m.getContext().getSymbol(lhs.getRep());
                if (s == null || Linter.isBuiltFromDeclarations(rhs) || fieldPairs.stream().anyMatch(Linter::isBuiltFromDeclarations) || allRecords.stream().filter(r -> Records.sameDomain(r, record)).flatMap(r -> Linter.getFieldPairs(r).stream()).anyMatch(Linter::isBuiltFromDeclarations)) continue;
                errors.addWarning(ErrorCode.RECORD_CONSTRUCTOR_FIELD_NAME_CLASH, lhs.getLocation(), String.format("The field name \"%1$s\" in the record constructor is identical to the existing definition or declaration\nnamed %1$s, located at %2$s.\nThe field in the record will not take the value of the %1$s definition or declaration.\nIn TLA+, field names in records are strings, regardless of any similarly named declarations or definitions.\nTherefore, DOMAIN [%1$s |-> ...] = {\"%1$s\"} holds true.", lhs.getRep(), s.getLocation()));
            }
        }
    }

    private static List<OpApplNode> getFieldPairs(OpApplNode record) {
        return Arrays.asList(record.getArgs()).stream().filter(arg -> arg instanceof OpApplNode).map(arg -> (OpApplNode)arg).collect(Collectors.toList());
    }

    private static boolean isBuiltFromDeclarations(ExprOrOpArgNode expr) {
        return expr.walkChildren(new SemanticNode.ChildrenVisitor<Boolean>(){
            private boolean found;

            @Override
            public void preVisit(SemanticNode node) {
                if (node instanceof OpApplNode) {
                    SymbolNode operator = ((OpApplNode)node).getOperator();
                    if (operator instanceof OpDeclNode) {
                        this.found = true;
                    }
                    if (operator instanceof FormalParamNode) {
                        this.found = true;
                    }
                    if (operator instanceof OpDefNode) {
                        if (operator.getName() == UniqueString.of("BOOLEAN")) {
                            this.found = true;
                            return;
                        }
                        ModuleNode moduleNode = ((OpDefNode)operator).getOriginallyDefinedInModuleNode();
                        if (moduleNode != null && moduleNode.getName() == UniqueString.of("Integers") && operator.getName() == UniqueString.of("Int")) {
                            this.found = true;
                            return;
                        }
                        if (moduleNode != null && moduleNode.getName() == UniqueString.of("Naturals") && operator.getName() == UniqueString.of("Nat")) {
                            this.found = true;
                            return;
                        }
                        if (moduleNode != null && moduleNode.getName() == UniqueString.of("Reals") && operator.getName() == UniqueString.of("Reals")) {
                            this.found = true;
                            return;
                        }
                        operator.walkChildren(this);
                    }
                }
            }

            @Override
            public boolean preempt(SemanticNode node) {
                return this.found;
            }

            @Override
            public Boolean get() {
                return this.found;
            }
        }).get();
    }

    private static class Records {
        private Records() {
        }

        public static boolean sameDomain(OpApplNode r1, OpApplNode r2) {
            if (r1 == r2) {
                return true;
            }
            if (r1.getArgs().length != r2.getArgs().length) {
                return false;
            }
            int i = 0;
            while (i < r1.getArgs().length) {
                block5: {
                    OpApplNode f1 = (OpApplNode)r1.getArgs()[i];
                    StringNode s1 = (StringNode)f1.getArgs()[0];
                    int j = 0;
                    while (j < r2.getArgs().length) {
                        OpApplNode f2 = (OpApplNode)r2.getArgs()[j];
                        StringNode s2 = (StringNode)f2.getArgs()[0];
                        if (s1.getRep() != s2.getRep()) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

