/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Date;
import java.util.Vector;
import tla2tex.Misc;
import tla2tex.TLA2TexException;
import util.ToolIO;

public class Debug {
    public static void ReportError(String msg) {
        ToolIO.out.println("");
        ToolIO.out.println("TLATeX unrecoverable error:");
        ToolIO.out.println("");
        ToolIO.out.println(" -- " + msg + ".");
        ToolIO.out.println("");
        throw new TLA2TexException("TLATeX unrecoverable error: -- " + msg + ".");
    }

    public static void Assert(boolean val) {
        if (!val) {
            Debug.ReportBug("Assertion failure");
        }
    }

    public static void Assert(boolean val, String msg) {
        if (!val) {
            Debug.ReportBug("Failure of assertion: " + msg);
        }
    }

    public static void ReportBug(String msg) {
        ToolIO.out.println("");
        ToolIO.out.println("You have discovered a bug in TLATeX.");
        ToolIO.out.println("Send the following information and the");
        ToolIO.out.println("input file to the current maintainer(s).");
        ToolIO.out.println("");
        ToolIO.out.println(" -- " + msg + ".");
        ToolIO.out.println("");
        throw new Error();
    }

    public static void printArray(Object[] array, String name) {
        if (array == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null) {
                ToolIO.out.println(name + "[" + i + "] = null");
            } else {
                ToolIO.out.println(name + "[" + i + "] = " + array[i].toString());
            }
            ++i;
        }
        if (array.length == 0) {
            ToolIO.out.println(name + " = zero-length array");
        }
    }

    public static void print2DArray(Object[][] array, String name) {
        if (array == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                ToolIO.out.println(name + "[" + i + "][" + j + "] = " + array[i][j].toString());
                ++j;
            }
            if (array[i].length == 0) {
                ToolIO.out.println(name + "[" + i + "] = null");
            }
            ++i;
        }
        if (array.length == 0) {
            ToolIO.out.println(name + " = zero-length array");
        }
    }

    public static void printVector(Vector vec, String name) {
        if (vec == null) {
            ToolIO.out.println(name + " == null");
            return;
        }
        int i = 0;
        while (i < vec.size()) {
            if (vec.elementAt(i) == null) {
                ToolIO.out.println(name + "[" + i + "] = null");
            } else {
                ToolIO.out.println(name + "[" + i + "] = " + vec.elementAt(i).toString());
            }
            ++i;
        }
        if (vec.size() == 0) {
            ToolIO.out.println(name + " = zero-length vec");
        }
    }

    public static String pair(int i, int j) {
        return "(" + i + ", " + j + ")";
    }

    public static void printPair(int i, int j) {
        ToolIO.out.println(Debug.pair(i, j));
    }

    public static long now() {
        Date date = new Date();
        return date.getTime();
    }

    public static void printElapsedTime(long start, String msg) {
        Debug.printTimeDiff(Debug.now() - start, msg);
    }

    public static void printTimeDiff(long diff, String msg) {
        ToolIO.out.println(msg + " " + Misc.floatToString((float)diff / 1000.0f, 2) + " seconds");
    }
}

