/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.impl.DebugTool;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.UniqueString;

public class TLCStateStackFrame
extends TLCStackFrame {
    public static final DebuggerValue NOT_EVAL = new DebuggerValue();
    public static final String SCOPE = "State";
    public static final String TRACE = "Trace";
    protected final transient TLCState state;
    protected final transient int stateId;

    public TLCStateStackFrame(TLCStackFrame parent, SemanticNode node, Context ctxt, Tool tool, TLCState state) {
        this(parent, node, ctxt, tool, state, null);
    }

    public TLCStateStackFrame(TLCStackFrame parent, SemanticNode node, Context ctxt, Tool tool, TLCState state, RuntimeException e) {
        super(parent, node, ctxt, tool, e);
        this.state = state.deepCopy();
        assert (this.state instanceof TLCStateMutExt);
        this.stateId = rnd.nextInt(0x7FFFFFFE) + 1;
    }

    @Override
    protected TLCState getS() {
        return this.getT();
    }

    @Override
    protected TLCState getT() {
        return this.state;
    }

    Variable[] getTrace() {
        return this.getVariables(this.stateId + 1);
    }

    @Override
    public Variable[] getVariables(int vr) {
        if (vr == this.stateId) {
            return this.tool.eval(() -> new Variable[]{this.toVariable()});
        }
        if (vr == this.stateId + 1) {
            return ((DebugTool)this.tool).eval(() -> {
                try {
                    TLCStateInfo[] prefix;
                    TLCState t = this.getT();
                    if (t.isInitial()) {
                        assert (t.getPredecessor() == null);
                        return new Variable[]{this.getStateAsVariable(new RecordValue(t, (Value)NOT_EVAL), "1: " + (t.hasAction() ? t.getAction().getLocation() : "<Initial predicate>"))};
                    }
                    ArrayDeque<Variable> trace = new ArrayDeque<Variable>();
                    if (this.addT()) {
                        trace.add(this.getStateAsVariable(new RecordValue(t, (Value)NOT_EVAL), t.getLevel() + ": " + (t.hasAction() ? t.getAction().getLocation() : "<???>")));
                    }
                    if (TLCGlobals.simulator != null) {
                        prefix = (TLCStateInfo[])TLCGlobals.simulator.getTrace(t).stream().filter(s -> s.allAssigned()).map(s -> new TLCStateInfo((TLCState)s)).collect(Collectors.toList()).toArray(TLCStateInfo[]::new);
                    } else {
                        TLCState last = t;
                        TLCState s2 = t;
                        while ((s2 = s2.getPredecessor()) != null) {
                            if (s2.isInitial()) {
                                trace.add(this.getStateAsVariable(new RecordValue(s2, (Value)NOT_EVAL), "1: " + (s2.hasAction() ? s2.getAction().getLocation() : "<Initial predicate>")));
                                return trace.toArray(new Variable[trace.size()]);
                            }
                            trace.add(this.getStateAsVariable(new RecordValue(s2, (Value)NOT_EVAL), s2.getLevel() + ": " + (s2.hasAction() ? s2.getAction().getLocation() : "<???>")));
                            last = s2;
                        }
                        ArrayList<TLCStateInfo> arrayList = new ArrayList<TLCStateInfo>(Arrays.asList(TLCGlobals.mainChecker.getTraceInfo(last)));
                        prefix = (TLCStateInfo[])arrayList.toArray(TLCStateInfo[]::new);
                    }
                    int i = prefix.length - 1;
                    while (i >= 0) {
                        TLCStateInfo ti = prefix[i];
                        trace.add(this.getStateAsVariable(new RecordValue(ti.state), ti.state.getLevel() + ": " + ti.info.toString()));
                        --i;
                    }
                    return trace.toArray(new Variable[trace.size()]);
                }
                catch (IOException e) {
                    return new Variable[0];
                }
            });
        }
        return super.getVariables(vr);
    }

    protected boolean addT() {
        return false;
    }

    protected Variable toVariable() {
        return this.getStateAsVariable(this.toRecordValue(), this.state.getLevel() + ": " + this.getActionName(this.getT()));
    }

    private String getActionName(TLCState t) {
        return t.hasAction() ? t.getAction().getLocation() : "<???>";
    }

    protected RecordValue toRecordValue() {
        return new RecordValue(this.getT(), (Value)NOT_EVAL);
    }

    Variable[] getStateVariables() {
        return this.getVariables(this.stateId);
    }

    @Override
    protected Variable getStateAsVariable(IValue value, String varName) {
        Variable variable = this.getVariable(value, UniqueString.of(varName));
        try {
            if (this.getT().allAssigned()) {
                variable.setType(String.format("FP64: %s", Long.toString(this.getT().fingerPrint())));
                return variable;
            }
        }
        catch (EvalException | FingerprintException | Assert.TLCRuntimeException runtimeException) {
            // empty catch block
        }
        return super.getStateAsVariable(value, varName);
    }

    @Override
    protected Variable getVariable(LinkedList<SemanticNode> path) {
        assert (!path.isEmpty());
        if (!this.isPrimeScope(path)) {
            SymbolNode var = this.tool.getVar(path.getFirst(), this.ctxt, false, this.tool.getId());
            if (var != null) {
                IValue value = this.getS().lookup(var.getName());
                if (value != null) {
                    return this.getVariable(value, var.getName());
                }
                Variable v = new Variable();
                v.setName(var.getName().toString());
                v.setValue("?");
                return v;
            }
        } else if (this.isPrimeScope(path)) {
            Variable variable = new Variable();
            variable.setName(path.getFirst().getHumanReadableImage());
            variable.setValue(path.getFirst().getLocation().toString());
            return variable;
        }
        return super.getVariable(path);
    }

    @Override
    public EvaluateResponse getWatch(String name) {
        if (name == null) {
            return new EvaluateResponse();
        }
        IValue lookup = this.getT().lookup(name);
        if (lookup != null) {
            Variable variable = this.getVariable(lookup, name);
            EvaluateResponse er = new EvaluateResponse();
            er.setResult(variable.getValue());
            er.setVariablesReference(variable.getVariablesReference());
            return er;
        }
        return super.getWatch(name);
    }

    protected boolean isPrimeScope(LinkedList<SemanticNode> path) {
        for (SemanticNode semanticNode : path) {
            OpApplNode oan;
            if (!(semanticNode instanceof OpApplNode) || ASTConstants.OP_prime != (oan = (OpApplNode)semanticNode).getOperator().getName()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasScope() {
        return true;
    }

    @Override
    public Scope[] getScopes() {
        Scope scope;
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.addAll(Arrays.asList(super.getScopes()));
        if (this.hasScope()) {
            scope = new Scope();
            scope.setName(this.getScope());
            scope.setVariablesReference(this.stateId);
            scopes.add(scope);
        }
        scope = new Scope();
        scope.setName(TRACE);
        scope.setVariablesReference(this.stateId + 1);
        scopes.add(scope);
        return scopes.toArray(new Scope[scopes.size()]);
    }

    protected String getScope() {
        return SCOPE;
    }

    @Override
    protected Object unlazy(LazyValue lv) {
        return this.unlazy(lv, null);
    }

    @Override
    protected Object unlazy(LazyValue lv, Object fallback) {
        try {
            return this.tool.eval(() -> lv.eval(this.tool, this.getS()));
        }
        catch (EvalException | FingerprintException | Assert.TLCRuntimeException e) {
            return fallback == null ? e : fallback;
        }
    }

    @Override
    public boolean matches(TLCSourceBreakpoint bp) {
        if (super.matches(bp)) {
            boolean fire = true;
            if (bp.getHits() > 0) {
                fire = this.getT().getLevel() >= bp.getHits();
            }
            return this.matchesExpression(bp, fire);
        }
        return false;
    }

    protected boolean matchesExpression(TLCSourceBreakpoint bp, boolean fire) {
        return bp.matchesExpression(this.tool, this.getS(), this.getT(), this.getContext(), fire);
    }

    public static class DebuggerValue
    extends StringValue {
        static final String NOT_EVALUATED = "?";

        private DebuggerValue() {
            super(UniqueString.of(NOT_EVALUATED));
        }

        @Override
        public StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
            return sb.append(NOT_EVALUATED);
        }

        @Override
        public String getKindString() {
            return this.getTypeString();
        }

        @Override
        public String getTypeString() {
            return "Evaluation pending... (value has not been determined yet)";
        }
    }
}

