/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.util.Hashtable;
import tlc2.tool.EvalException;
import tlc2.util.Vect;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueVec;

public class TransitiveClosure
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;

    public static Value Warshall(Value rel) {
        if (!(rel instanceof Enumerable)) {
            throw new EvalException(2176, new String[]{"TransitiveClosure", "an enumerable set", Values.ppr(rel.toString())});
        }
        int maxLen = 2 * rel.size();
        boolean[][] matrix = new boolean[maxLen][maxLen];
        ValueEnumeration elems = ((Enumerable)((Object)rel)).elements();
        Vect<Value> elemList = new Vect<Value>();
        Hashtable<Value, Integer> fps = new Hashtable<Value, Integer>();
        int cnt = 0;
        Value elem = null;
        while ((elem = elems.nextElement()) != null) {
            TupleValue tv = (TupleValue)elem.toTuple();
            if (tv == null || tv.size() != 2) {
                throw new EvalException(2157, Values.ppr(elem.toString()));
            }
            Value elem1 = tv.elems[0];
            Value elem2 = tv.elems[1];
            int num1 = cnt;
            Integer num = (Integer)fps.get(elem1);
            if (num == null) {
                fps.put(elem1, cnt);
                elemList.addElement(elem1);
            } else {
                num1 = num;
            }
            int num2 = ++cnt;
            num = (Integer)fps.get(elem2);
            if (num == null) {
                fps.put(elem2, cnt);
                elemList.addElement(elem2);
                ++cnt;
            } else {
                num2 = num;
            }
            matrix[num1][num2] = true;
        }
        int y = 0;
        while (y < cnt) {
            int x = 0;
            while (x < cnt) {
                if (matrix[x][y]) {
                    int z = 0;
                    while (z < cnt) {
                        if (matrix[y][z]) {
                            matrix[x][z] = true;
                        }
                        ++z;
                    }
                }
                ++x;
            }
            ++y;
        }
        ValueVec newElems = new ValueVec();
        int i = 0;
        while (i < cnt) {
            int j = 0;
            while (j < cnt) {
                if (matrix[i][j]) {
                    Value elem1 = (Value)elemList.elementAt(i);
                    Value elem2 = (Value)elemList.elementAt(j);
                    TupleValue newElem = new TupleValue(elem1, elem2);
                    newElems.addElement(newElem);
                }
                ++j;
            }
            ++i;
        }
        return new SetEnumValue(newElems, false);
    }
}

