/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.BEGraph;
import tlc2.tool.liveness.BEGraphNode;
import tlc2.tool.liveness.BTGraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LiveCounterExampleException;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.FP64;
import tlc2.util.LongObjTable;
import tlc2.util.MemObjectStack;
import tlc2.util.ObjectStack;
import tlc2.util.SetOfStates;
import tlc2.util.Vect;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.value.impl.CounterExample;

public class LiveCheck1
implements ILiveCheck {
    private final AtomicBoolean errorFound;
    private ITool myTool;
    private String metadir = "";
    private Action[] actions;
    private OrderOfSolution[] solutions;
    private BEGraph[] bgraphs;
    private StateVec stateTrace = null;
    private static final long MAX_FIRST = 0x2000000000000000L;
    private static final long MAX_SECOND = 0x5000000000000000L;
    private OrderOfSolution currentOOS = null;
    private PossibleErrorModel currentPEM = null;
    private ObjectStack comStack = null;
    private long firstNum = 1L;
    private long secondNum;
    private long startSecondNum = this.secondNum = 0x2000000000000001L;
    private long thirdNum;
    private long startThirdNum = this.thirdNum = 0x5000000000000001L;
    private long numFirstCom = this.secondNum;
    private long numSecondCom = this.thirdNum;
    private BEGraphNode initNode = null;

    public LiveCheck1(ITool tool) {
        this(tool, new AtomicBoolean(false), false);
    }

    public LiveCheck1(ITool tool, AtomicBoolean errorFound, boolean silent) {
        this.myTool = tool;
        this.solutions = Liveness.processLiveness(this.myTool, silent);
        this.bgraphs = new BEGraph[0];
        this.errorFound = errorFound;
    }

    public void init(ITool tool, Action[] acts, String mdir) {
        this.myTool = tool;
        this.metadir = mdir;
        this.actions = acts;
        this.solutions = Liveness.processLiveness(this.myTool);
        this.bgraphs = new BEGraph[this.solutions.length];
        int i = 0;
        while (i < this.solutions.length) {
            this.bgraphs[i] = new BEGraph(this.metadir, this.solutions[i].hasTableau());
            ++i;
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.bgraphs.length) {
            this.bgraphs[i].resetNumberField();
            ++i;
        }
    }

    private void initSccParams(OrderOfSolution os) {
        this.currentOOS = os;
        this.comStack = new MemObjectStack(this.metadir, "comstack");
        this.firstNum = 1L;
        this.secondNum = 0x2000000000000001L;
        this.thirdNum = 0x5000000000000001L;
        this.startSecondNum = this.secondNum;
        this.startThirdNum = this.thirdNum;
        this.numFirstCom = this.secondNum;
        this.numSecondCom = this.thirdNum;
    }

    Vect<BEGraphNode> constructBEGraph(ITool tool, OrderOfSolution os) {
        Vect<BEGraphNode> initNodes = new Vect<BEGraphNode>(1);
        int slen = os.getCheckState().length;
        int alen = os.getCheckAction().length;
        TLCState srcState = this.stateTrace.elementAt(0);
        long srcFP = srcState.fingerPrint();
        boolean[] checkStateRes = os.checkState(tool, srcState);
        boolean[] checkActionRes = os.checkAction(tool, srcState, srcState);
        if (!os.hasTableau()) {
            LongObjTable allNodes = new LongObjTable(127);
            BEGraphNode srcNode = new BEGraphNode(srcFP);
            srcNode.setCheckState(checkStateRes);
            srcNode.addTransition(srcNode, slen, alen, checkActionRes);
            allNodes.put(srcFP, srcNode);
            initNodes.addElement(srcNode);
            int i = 1;
            while (i < this.stateTrace.size()) {
                TLCState destState = this.stateTrace.elementAt(i);
                long destFP = destState.fingerPrint();
                BEGraphNode destNode = (BEGraphNode)allNodes.get(destFP);
                if (destNode == null) {
                    destNode = new BEGraphNode(destFP);
                    destNode.setCheckState(os.checkState(tool, srcState));
                    destNode.addTransition(destNode, slen, alen, os.checkAction(tool, destState, destState));
                    srcNode.addTransition(destNode, slen, alen, os.checkAction(tool, srcState, destState));
                    allNodes.put(destFP, destNode);
                } else if (!srcNode.transExists(destNode)) {
                    srcNode.addTransition(destNode, slen, alen, os.checkAction(tool, srcState, destState));
                }
                srcNode = destNode;
                srcState = destState;
                ++i;
            }
        } else {
            LongObjTable allNodes = new LongObjTable(255);
            Vect<BTGraphNode> srcNodes = new Vect<BTGraphNode>();
            int initCnt = os.getTableau().getInitCnt();
            int i = 0;
            while (i < initCnt) {
                TBGraphNode tnode = os.getTableau().getNode(i);
                if (tnode.isConsistent(srcState, this.myTool)) {
                    BTGraphNode destNode = new BTGraphNode(srcFP, tnode.getIndex());
                    destNode.setCheckState(checkStateRes);
                    initNodes.addElement(destNode);
                    srcNodes.addElement(destNode);
                    allNodes.put(FP64.Extend(srcFP, tnode.getIndex()), destNode);
                }
                ++i;
            }
            i = 0;
            while (i < srcNodes.size()) {
                BEGraphNode srcNode = (BEGraphNode)srcNodes.elementAt(i);
                TBGraphNode tnode = srcNode.getTNode(os.getTableau());
                int j = 0;
                while (j < tnode.nextSize()) {
                    TBGraphNode tnode1 = tnode.nextAt(j);
                    long destFP = FP64.Extend(srcFP, tnode1.getIndex());
                    BEGraphNode destNode = (BEGraphNode)allNodes.get(destFP);
                    if (destNode != null) {
                        srcNode.addTransition(destNode, slen, alen, checkActionRes);
                    }
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.stateTrace.size()) {
                BEGraphNode destNode;
                long destFP;
                TBGraphNode tnode1;
                int k;
                TBGraphNode tnode;
                BEGraphNode srcNode;
                Vect<BEGraphNode> destNodes = new Vect<BEGraphNode>();
                TLCState destState = this.stateTrace.elementAt(i);
                long destStateFP = destState.fingerPrint();
                checkStateRes = os.checkState(this.myTool, destState);
                checkActionRes = os.checkAction(tool, srcState, destState);
                int j = 0;
                while (j < srcNodes.size()) {
                    srcNode = (BEGraphNode)srcNodes.elementAt(j);
                    tnode = srcNode.getTNode(os.getTableau());
                    k = 0;
                    while (k < tnode.nextSize()) {
                        tnode1 = tnode.nextAt(k);
                        destFP = FP64.Extend(destStateFP, tnode1.getIndex());
                        destNode = (BEGraphNode)allNodes.get(destFP);
                        if (destNode == null) {
                            if (tnode1.isConsistent(destState, this.myTool)) {
                                destNode = new BTGraphNode(destStateFP, tnode1.getIndex());
                                destNode.setCheckState(checkStateRes);
                                srcNode.addTransition(destNode, slen, alen, checkActionRes);
                                destNodes.addElement(destNode);
                                allNodes.put(destFP, destNode);
                            }
                        } else if (!srcNode.transExists(destNode)) {
                            srcNode.addTransition(destNode, slen, alen, checkActionRes);
                        }
                        ++k;
                    }
                    ++j;
                }
                checkActionRes = os.checkAction(tool, destState, destState);
                j = 0;
                while (j < destNodes.size()) {
                    srcNode = (BEGraphNode)destNodes.elementAt(j);
                    tnode = srcNode.getTNode(os.getTableau());
                    k = 0;
                    while (k < tnode.nextSize()) {
                        tnode1 = tnode.nextAt(k);
                        destFP = FP64.Extend(destStateFP, tnode1.getIndex());
                        destNode = (BEGraphNode)allNodes.get(destFP);
                        if (destNode == null) {
                            if (tnode1.isConsistent(destState, this.myTool)) {
                                destNode = new BTGraphNode(destStateFP, tnode1.getIndex());
                                destNode.setCheckState(checkStateRes);
                                srcNode.addTransition(destNode, slen, alen, checkActionRes);
                                destNodes.addElement(destNode);
                                allNodes.put(destFP, destNode);
                            }
                        } else if (!srcNode.transExists(destNode)) {
                            srcNode.addTransition(destNode, slen, alen, checkActionRes);
                        }
                        ++k;
                    }
                    ++j;
                }
                srcNodes = destNodes;
                srcState = destState;
                ++i;
            }
        }
        return initNodes;
    }

    @Override
    public void addInitState(ITool tool, TLCState state, long stateFP) {
        int soln = 0;
        while (soln < this.solutions.length) {
            OrderOfSolution os = this.solutions[soln];
            BEGraph bgraph = this.bgraphs[soln];
            int slen = os.getCheckState().length;
            int alen = os.getCheckAction().length;
            boolean[] checkStateRes = os.checkState(tool, state);
            boolean[] checkActionRes = os.checkAction(tool, state, state);
            if (!os.hasTableau()) {
                BEGraphNode node = new BEGraphNode(stateFP);
                node.setCheckState(checkStateRes);
                bgraph.addInitNode(node);
                node.addTransition(node, slen, alen, checkActionRes);
                bgraph.allNodes.putBENode(node);
            } else {
                int initCnt = os.getTableau().getInitCnt();
                int i = 0;
                while (i < initCnt) {
                    TBGraphNode tnode = os.getTableau().getNode(i);
                    if (tnode.isConsistent(state, this.myTool)) {
                        BTGraphNode destNode = new BTGraphNode(stateFP, tnode.getIndex());
                        destNode.setCheckState(checkStateRes);
                        bgraph.addInitNode(destNode);
                        bgraph.allNodes.putBTNode(destNode);
                        this.addNodesForStut(state, stateFP, destNode, checkStateRes, checkActionRes, os, bgraph);
                    }
                    ++i;
                }
            }
            bgraph.allNodes.setDone(stateFP);
            ++soln;
        }
    }

    @Override
    public void addNextState(ITool tool, TLCState s0, long fp0, SetOfStates nextStates) throws IOException {
        int i = 0;
        while (i < nextStates.size()) {
            TLCState s2 = nextStates.next();
            long fp2 = s2.fingerPrint();
            this.addNextState(tool, s0, fp0, s2, fp2);
            ++i;
        }
        nextStates.resetNext();
    }

    public synchronized void addNextState(ITool tool, TLCState s1, long fp1, TLCState s2, long fp2) {
        int soln = 0;
        while (soln < this.solutions.length) {
            block13: {
                boolean[] checkActionRes;
                int alen;
                int slen;
                BEGraph bgraph;
                OrderOfSolution os;
                block11: {
                    BEGraphNode node2;
                    BEGraphNode node1;
                    block12: {
                        os = this.solutions[soln];
                        bgraph = this.bgraphs[soln];
                        slen = os.getCheckState().length;
                        alen = os.getCheckAction().length;
                        if (os.hasTableau()) break block11;
                        node1 = bgraph.allNodes.getBENode(fp1);
                        node2 = bgraph.allNodes.getBENode(fp2);
                        if (node2 != null) break block12;
                        node2 = new BEGraphNode(fp2);
                        node2.setCheckState(os.checkState(tool, s2));
                        node1.addTransition(node2, slen, alen, os.checkAction(tool, s1, s2));
                        node2.addTransition(node2, slen, alen, os.checkAction(tool, s2, s2));
                        bgraph.allNodes.putBENode(node2);
                        break block13;
                    }
                    if (node1.transExists(node2)) break block13;
                    checkActionRes = os.checkAction(tool, s1, s2);
                    node1.addTransition(node2, slen, alen, checkActionRes);
                    break block13;
                }
                BTGraphNode[] srcNodes = bgraph.allNodes.getBTNode(fp1);
                if (srcNodes != null) {
                    boolean[] checkStateRes = null;
                    checkActionRes = os.checkAction(tool, s1, s2);
                    boolean[] checkActionRes1 = null;
                    int i = 0;
                    while (i < srcNodes.length) {
                        BTGraphNode srcNode = srcNodes[i];
                        TBGraphNode tnode = os.getTableau().getNode(srcNode.getIndex());
                        int j = 0;
                        while (j < tnode.nextSize()) {
                            TBGraphNode tnode1 = tnode.nextAt(j);
                            BTGraphNode destNode = bgraph.allNodes.getBTNode(fp2, tnode1.getIndex());
                            if (destNode == null) {
                                if (tnode1.isConsistent(s2, this.myTool)) {
                                    destNode = new BTGraphNode(fp2, tnode1.getIndex());
                                    if (checkStateRes == null) {
                                        checkStateRes = os.checkState(tool, s2);
                                    }
                                    destNode.setCheckState(checkStateRes);
                                    srcNode.addTransition(destNode, slen, alen, checkActionRes);
                                    int idx = bgraph.allNodes.putBTNode(destNode);
                                    if (checkActionRes1 == null) {
                                        checkActionRes1 = os.checkAction(tool, s2, s2);
                                    }
                                    this.addNodesForStut(s2, fp2, destNode, checkStateRes, checkActionRes1, os, bgraph);
                                    if (bgraph.allNodes.isDone(idx)) {
                                        this.addNextState(tool, s2, fp2, destNode, os, bgraph);
                                    }
                                }
                            } else if (!srcNode.transExists(destNode)) {
                                srcNode.addTransition(destNode, slen, alen, checkActionRes);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            ++soln;
        }
    }

    private void addNodesForStut(TLCState state, long fp, BTGraphNode node, boolean[] checkState, boolean[] checkAction, OrderOfSolution os, BEGraph bgraph) {
        int slen = os.getCheckState().length;
        int alen = os.getCheckAction().length;
        TBGraphNode tnode = node.getTNode(os.getTableau());
        int i = 0;
        while (i < tnode.nextSize()) {
            TBGraphNode tnode1 = tnode.nextAt(i);
            BTGraphNode destNode = bgraph.allNodes.getBTNode(fp, tnode1.getIndex());
            if (destNode == null) {
                if (tnode1.isConsistent(state, this.myTool)) {
                    destNode = new BTGraphNode(fp, tnode1.getIndex());
                    destNode.setCheckState(checkState);
                    node.addTransition(destNode, slen, alen, checkAction);
                    bgraph.allNodes.putBTNode(destNode);
                    this.addNodesForStut(state, fp, destNode, checkState, checkAction, os, bgraph);
                }
            } else {
                node.addTransition(destNode, slen, alen, checkAction);
            }
            ++i;
        }
    }

    private void addNextState(ITool tool, TLCState s, long fp, BTGraphNode node, OrderOfSolution os, BEGraph bgraph) {
        TBGraphNode tnode = node.getTNode(os.getTableau());
        int slen = os.getCheckState().length;
        int alen = os.getCheckAction().length;
        boolean[] checkStateRes = null;
        boolean[] checkActionRes = null;
        int i = 0;
        while (i < this.actions.length) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.myTool.getNextStates(curAction, s);
            int j = 0;
            while (j < nextStates.size()) {
                TLCState s1 = nextStates.elementAt(j);
                long fp1 = s1.fingerPrint();
                boolean[] checkActionRes1 = null;
                int k = 0;
                while (k < tnode.nextSize()) {
                    TBGraphNode tnode1 = tnode.nextAt(k);
                    BTGraphNode destNode = bgraph.allNodes.getBTNode(fp1, tnode1.getIndex());
                    if (destNode == null) {
                        if (tnode1.isConsistent(s1, this.myTool)) {
                            destNode = new BTGraphNode(fp1, tnode1.getIndex());
                            if (checkStateRes == null) {
                                checkStateRes = os.checkState(tool, s1);
                            }
                            if (checkActionRes == null) {
                                checkActionRes = os.checkAction(tool, s, s1);
                            }
                            destNode.setCheckState(checkStateRes);
                            node.addTransition(destNode, slen, alen, checkActionRes);
                            if (checkActionRes1 == null) {
                                checkActionRes1 = os.checkAction(tool, s1, s1);
                            }
                            this.addNodesForStut(s1, fp1, destNode, checkStateRes, checkActionRes1, os, bgraph);
                            int idx = bgraph.allNodes.putBTNode(destNode);
                            if (bgraph.allNodes.isDone(idx)) {
                                this.addNextState(tool, s1, fp1, destNode, os, bgraph);
                            }
                        }
                    } else if (!node.transExists(destNode)) {
                        if (checkActionRes == null) {
                            checkActionRes = os.checkAction(tool, s, s1);
                        }
                        node.addTransition(destNode, slen, alen, checkActionRes);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public synchronized void setDone(long fp) {
        int soln = 0;
        while (soln < this.solutions.length) {
            this.bgraphs[soln].allNodes.setDone(fp);
            ++soln;
        }
    }

    @Override
    public boolean doLiveCheck() {
        return true;
    }

    @Override
    public synchronized int check(ITool tool, boolean forceCheck) {
        int slen = this.solutions.length;
        if (slen == 0) {
            return 0;
        }
        int soln = 0;
        while (soln < slen) {
            OrderOfSolution oos = this.solutions[soln];
            this.initSccParams(oos);
            BEGraph bgraph = this.bgraphs[soln];
            int numOfInits = bgraph.initSize();
            int i = 0;
            while (i < numOfInits) {
                this.initNode = bgraph.getInitNode(i);
                if (this.initNode.getNumber() == 0L) {
                    this.checkSccs(this.initNode);
                }
                ++i;
            }
            ++soln;
        }
        return 0;
    }

    @Override
    public synchronized void checkTrace(ITool tool, Supplier<StateVec> trace) {
        this.stateTrace = trace.get();
        int soln = 0;
        while (soln < this.solutions.length) {
            OrderOfSolution os = this.solutions[soln];
            Vect<BEGraphNode> initNodes = this.constructBEGraph(tool, os);
            this.initSccParams(os);
            int numOfInits = initNodes.size();
            int i = 0;
            while (i < numOfInits) {
                this.initNode = initNodes.elementAt(i);
                if (this.initNode.getNumber() == 0L) {
                    this.checkSccs(this.initNode);
                }
                ++i;
            }
            ++soln;
        }
    }

    /*
     * Unable to fully structure code
     */
    CounterExample printErrorTrace(BEGraphNode node) throws IOException {
        MP.printError(2116);
        MP.printError(2264);
        cycleStack = new MemObjectStack(this.metadir, "cyclestack");
        slen = this.currentOOS.getCheckState().length;
        alen = this.currentOOS.getCheckAction().length;
        lowNum = this.thirdNum - 1L;
        AEStateRes = new boolean[this.currentPEM.AEState.length];
        AEActionRes = new boolean[this.currentPEM.AEAction.length];
        promiseRes = new boolean[this.currentOOS.getPromises().length];
        cnt = AEStateRes.length + AEActionRes.length + promiseRes.length;
        curNode = node;
        block0: while (cnt > 0) {
            curNode.setNumber(this.thirdNum);
            cnt0 = cnt;
            while (true) {
                i = 0;
                while (i < this.currentPEM.AEState.length) {
                    idx = this.currentPEM.AEState[i];
                    if (!AEStateRes[i] && curNode.getCheckState(idx)) {
                        AEStateRes[i] = true;
                        --cnt;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.currentOOS.getPromises().length) {
                    promise = this.currentOOS.getPromises()[i];
                    par = curNode.getTNode(this.currentOOS.getTableau()).getPar();
                    if (!promiseRes[i] && par.isFulfilling(promise)) {
                        promiseRes[i] = true;
                        --cnt;
                    }
                    ++i;
                }
                if (cnt <= 0) continue block0;
                nextNode1 = null;
                nextNode2 = null;
                cnt1 = cnt;
                i = 0;
                while (i < curNode.nextSize()) {
                    node1 = curNode.nextAt(i);
                    num = node1.getNumber();
                    if (lowNum <= num && num <= this.thirdNum) {
                        nextNode1 = node1;
                        j = 0;
                        while (j < this.currentPEM.AEAction.length) {
                            idx = this.currentPEM.AEAction[j];
                            if (!AEActionRes[j] && curNode.getCheckAction(slen, alen, i, idx)) {
                                AEActionRes[j] = true;
                                --cnt;
                            }
                            ++j;
                        }
                    }
                    if (cnt < cnt1) {
                        cycleStack.push(curNode);
                        curNode = node1;
                        ++this.thirdNum;
                        continue block0;
                    }
                    if (lowNum <= num && num < this.thirdNum) {
                        nextNode2 = node1;
                    }
                    ++i;
                }
                if (cnt >= cnt0) ** GOTO lbl78
                cycleStack.push(curNode);
                curNode = nextNode1;
                ++this.thirdNum;
                continue block0;
lbl-1000:
                // 1 sources

                {
                    curNode = (BEGraphNode)cycleStack.pop();
                    i = 0;
                    while (i < curNode.nextSize()) {
                        node1 = curNode.nextAt(i);
                        num = node1.getNumber();
                        if (lowNum <= num && num < this.thirdNum) {
                            cycleStack.push(curNode);
                            nextNode2 = node1;
                            continue block6;
                        }
                        ++i;
                    }
lbl78:
                    // 3 sources

                    ** while (nextNode2 == null)
                }
lbl79:
                // 1 sources

                cycleStack.push(curNode);
                curNode = nextNode2;
                curNode.setNumber(this.thirdNum);
            }
        }
        curNode.setNumber(++this.thirdNum);
        block8: while (curNode != node) {
            found = false;
            i = 0;
            while (i < curNode.nextSize()) {
                nextNode = curNode.nextAt(i);
                num = nextNode.getNumber();
                if (lowNum <= num && num < this.thirdNum) {
                    cycleStack.push(curNode);
                    if (nextNode == node) break block8;
                    found = true;
                    curNode = nextNode;
                    curNode.setNumber(this.thirdNum);
                    break;
                }
                ++i;
            }
            if (found) continue;
            curNode = (BEGraphNode)cycleStack.pop();
        }
        if (cycleStack.size() == 0) {
            cycleStack.push(curNode);
        }
        r = this.stateTrace != null && this.stateTrace.isEmpty() == false ? new StateTraceResolver() : new Resolver();
        stateNum = 0;
        prefix = BEGraph.getPath(this.initNode, node);
        states = new TLCStateInfo[prefix.length];
        trace = new ArrayList<TLCStateInfo>(states.length);
        fp = prefix[0].stateFP;
        sinfo = r.getState(fp, stateNum);
        states[stateNum++] = sinfo;
        i = 1;
        while (i < states.length) {
            fp1 = prefix[i].stateFP;
            if (fp1 != fp) {
                sinfo = r.getState(fp1, sinfo.state, stateNum);
                states[stateNum++] = sinfo;
            }
            fp = fp1;
            ++i;
        }
        cycleState = null;
        i = 0;
        while (i < stateNum) {
            sinfo = this.myTool.getDebugger().evalAlias(states[i], cycleState);
            trace.add(sinfo);
            StatePrinter.printInvariantViolationStateTraceState(sinfo, cycleState, i + 1);
            cycleState = states[i].state;
            ++i;
        }
        lastState = cycleState;
        cyclePos = stateNum;
        fps = new long[cycleStack.size()];
        idx = fps.length;
        while (idx > 0) {
            fps[--idx] = ((BEGraphNode)cycleStack.pop()).stateFP;
        }
        sinfo = states[stateNum - 1];
        i = 1;
        while (i < fps.length) {
            if (fps[i] != fps[i - 1]) {
                sinfo = r.getState(fps[i], sinfo.state, stateNum++);
                sinfo = this.myTool.getDebugger().evalAlias(sinfo, lastState);
                trace.add(sinfo);
                StatePrinter.printInvariantViolationStateTraceState(sinfo, lastState, stateNum);
                lastState = sinfo.state;
            }
            ++i;
        }
        if (node.stateFP == lastState.fingerPrint()) {
            StatePrinter.printStutteringState(stateNum);
            return new CounterExample(trace, stateNum);
        }
        sinfo = r.getState(cycleState.fingerPrint(), sinfo, stateNum);
        if (!LiveCheck1.$assertionsDisabled && !cycleState.equals(sinfo.state)) {
            throw new AssertionError();
        }
        StatePrinter.printBackToState(sinfo, cyclePos);
        return new CounterExample(trace, sinfo.getAction(), cyclePos);
    }

    void checkSubcomponent(BEGraphNode node) {
        int slen = this.currentOOS.getCheckState().length;
        int alen = this.currentOOS.getCheckAction().length;
        boolean[] AEStateRes = new boolean[this.currentPEM.AEState.length];
        boolean[] AEActionRes = new boolean[this.currentPEM.AEAction.length];
        boolean[] promiseRes = new boolean[this.currentOOS.getPromises().length];
        MemObjectStack stack = new MemObjectStack(this.metadir, "subcomstack");
        node.incNumber();
        stack.push(node);
        while (stack.size() != 0) {
            BEGraphNode curNode = (BEGraphNode)stack.pop();
            int i = 0;
            while (i < this.currentPEM.AEState.length) {
                if (!AEStateRes[i]) {
                    int idx = this.currentPEM.AEState[i];
                    AEStateRes[i] = curNode.getCheckState(idx);
                }
                ++i;
            }
            int nsz = curNode.nextSize();
            int i2 = 0;
            while (i2 < nsz) {
                BEGraphNode node1 = curNode.nextAt(i2);
                long num = node1.getNumber();
                if (num >= this.thirdNum) {
                    int j = 0;
                    while (j < this.currentPEM.AEAction.length) {
                        if (!AEActionRes[j]) {
                            int idx = this.currentPEM.AEAction[j];
                            AEActionRes[j] = curNode.getCheckAction(slen, alen, i2, idx);
                        }
                        ++j;
                    }
                }
                if (num == this.thirdNum) {
                    node1.incNumber();
                    stack.push(node1);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.currentOOS.getPromises().length) {
                LNEven promise = this.currentOOS.getPromises()[i2];
                TBPar par = curNode.getTNode(this.currentOOS.getTableau()).getPar();
                if (par.isFulfilling(promise)) {
                    promiseRes[i2] = true;
                }
                ++i2;
            }
        }
        this.thirdNum += 2L;
        int i = 0;
        while (i < this.currentPEM.AEState.length) {
            if (!AEStateRes[i]) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.currentPEM.AEAction.length) {
            if (!AEActionRes[i]) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.currentOOS.getPromises().length) {
            if (!promiseRes[i]) {
                return;
            }
            ++i;
        }
        if (this.errorFound.compareAndSet(false, true)) {
            try {
                throw new LiveCounterExampleException(2116, "LiveCheck: Found error trace.", this.printErrorTrace(node));
            }
            catch (IOException e) {
                MP.printError(1000, "printing an error trace", (Throwable)e);
                throw new LiveException(2116, "LiveCheck: Found error trace.");
            }
        }
    }

    long checkSccs(BEGraphNode node) {
        long lowlink = this.firstNum++;
        node.setNumber(lowlink);
        this.comStack.push(node);
        int nsz = node.nextSize();
        int i = 0;
        while (i < nsz) {
            BEGraphNode destNode = node.nextAt(i);
            long destNum = destNode.getNumber();
            if (destNum == 0L) {
                destNum = this.checkSccs(destNode);
            }
            if (destNum < lowlink) {
                lowlink = destNum;
            }
            ++i;
        }
        if (lowlink == node.getNumber()) {
            this.checkComponent(node);
        }
        return lowlink;
    }

    void checkComponent(BEGraphNode node) {
        Vect<BEGraphNode> nodes = this.extractComponent(node);
        if (nodes != null) {
            PossibleErrorModel[] pems = this.currentOOS.getPems();
            int i = 0;
            while (i < pems.length) {
                this.currentPEM = pems[i];
                this.startSecondNum = this.secondNum;
                this.startThirdNum = this.thirdNum;
                int j = nodes.size() - 1;
                while (j >= 0) {
                    BEGraphNode node1 = nodes.elementAt(j);
                    if (node1.getNumber() < this.startThirdNum) {
                        this.checkSccs1(node1);
                    }
                    --j;
                }
                ++i;
            }
        }
    }

    Vect<BEGraphNode> extractComponent(BEGraphNode node) {
        BEGraphNode node1 = (BEGraphNode)this.comStack.pop();
        if (node == node1 && !node.transExists(node)) {
            node.setNumber(0x2000000000000000L);
            return null;
        }
        Vect<BEGraphNode> nodes = new Vect<BEGraphNode>();
        this.numFirstCom = this.secondNum++;
        this.numSecondCom = this.thirdNum;
        node1.setNumber(this.numFirstCom);
        nodes.addElement(node1);
        while (node != node1) {
            node1 = (BEGraphNode)this.comStack.pop();
            node1.setNumber(this.numFirstCom);
            nodes.addElement(node1);
        }
        return nodes;
    }

    long checkSccs1(BEGraphNode node) {
        long lowlink = this.secondNum++;
        node.setNumber(lowlink);
        this.comStack.push(node);
        int nsz = node.nextSize();
        int i = 0;
        while (i < nsz) {
            BEGraphNode destNode = node.nextAt(i);
            long destNum = destNode.getNumber();
            if (this.numFirstCom <= destNum && node.getCheckAction(this.currentOOS.getCheckState().length, this.currentOOS.getCheckAction().length, i, this.currentPEM.EAAction)) {
                if (destNum < this.startSecondNum || this.numSecondCom <= destNum && destNum < this.startThirdNum) {
                    destNum = this.checkSccs1(destNode);
                }
                if (destNum < lowlink) {
                    lowlink = destNum;
                }
            }
            ++i;
        }
        if (lowlink == node.getNumber() && this.extractComponent1(node)) {
            this.checkSubcomponent(node);
        }
        return lowlink;
    }

    boolean extractComponent1(BEGraphNode node) {
        BEGraphNode node1 = (BEGraphNode)this.comStack.pop();
        if (node == node1 && !this.canStutter(node)) {
            node.setNumber(this.thirdNum++);
            return false;
        }
        node1.setNumber(this.thirdNum);
        while (node != node1) {
            node1 = (BEGraphNode)this.comStack.pop();
            node1.setNumber(this.thirdNum);
        }
        return true;
    }

    boolean canStutter(BEGraphNode node) {
        int slen = this.currentOOS.getCheckState().length;
        int alen = this.currentOOS.getCheckAction().length;
        int i = 0;
        while (i < node.nextSize()) {
            BEGraphNode node1 = node.nextAt(i);
            if (node.equals(node1)) {
                long nodeNum = node.getNumber();
                return this.numFirstCom <= nodeNum && node.getCheckAction(slen, alen, i, this.currentPEM.EAAction);
            }
            ++i;
        }
        return false;
    }

    @Override
    public int finalCheck(ITool tool) throws Exception {
        return this.check(tool, true);
    }

    @Override
    public String getMetaDir() {
        return this.metadir;
    }

    public ITool getTool() {
        return this.myTool;
    }

    @Override
    public IBucketStatistics getOutDegreeStatistics() {
        return new DummyBucketStatistics();
    }

    @Override
    public ILiveChecker getChecker(int idx) {
        return null;
    }

    @Override
    public int getNumChecker() {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void beginChkpt() throws IOException {
    }

    @Override
    public void commitChkpt() throws IOException {
    }

    @Override
    public void recover() throws IOException {
    }

    @Override
    public void flushWritesToDiskFiles() {
    }

    @Override
    public IBucketStatistics calculateInDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        return new DummyBucketStatistics();
    }

    @Override
    public IBucketStatistics calculateOutDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        return new DummyBucketStatistics();
    }

    private class Resolver {
        private Resolver() {
        }

        public TLCStateInfo getState(long fp, int stateNum) {
            TLCStateInfo sinfo = LiveCheck1.this.myTool.getState(fp);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            return sinfo;
        }

        public TLCStateInfo getState(long fp, TLCState predecessor, int stateNum) {
            TLCStateInfo sinfo = LiveCheck1.this.myTool.getState(fp, predecessor);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            return sinfo;
        }

        public TLCStateInfo getState(long fp, TLCStateInfo predecessor, int stateNum) {
            TLCStateInfo sinfo = LiveCheck1.this.myTool.getState(fp, predecessor);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            return sinfo;
        }
    }

    private final class StateTraceResolver
    extends Resolver {
        private StateTraceResolver() {
        }

        @Override
        public TLCStateInfo getState(long fp, int stateNum) {
            TLCState s = LiveCheck1.this.stateTrace.elementAt(stateNum);
            assert (fp == s.fingerPrint());
            assert (stateNum + 1 == s.getLevel());
            return new TLCStateInfo(s);
        }

        @Override
        public TLCStateInfo getState(long fp, TLCState predecessor, int stateNum) {
            return this.getState(fp, stateNum);
        }

        @Override
        public TLCStateInfo getState(long fp, TLCStateInfo predecessor, int stateNum) {
            return this.getState(fp, stateNum);
        }
    }
}

