/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.Serializable;
import tlc2.util.BufferedRandomAccessFile;

public class BitVector
implements Serializable {
    private static final long serialVersionUID = 901734230891583097L;
    private long[] word;

    public BitVector() {
        this.word = null;
    }

    public BitVector(int initCapacity) {
        int len = initCapacity == 0 ? 0 : (initCapacity - 1) / 64 + 1;
        this.word = new long[len];
    }

    public BitVector(int initCapacity, boolean initValue) {
        int len = initCapacity == 0 ? 0 : (initCapacity - 1) / 64 + 1;
        this.word = new long[len];
        if (initValue) {
            this.set(0, len);
        }
    }

    public BitVector(BitVector bv) {
        int len = bv.word.length;
        this.word = new long[len];
        System.arraycopy(bv.word, 0, this.word, 0, len);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        BitVector other = (BitVector)o;
        int minLen = Math.min(this.word.length, other.word.length);
        int i = 0;
        while (i < minLen) {
            if (this.word[i] != other.word[i]) {
                return false;
            }
            ++i;
        }
        if (this.word.length != other.word.length) {
            int maxLen = Math.max(this.word.length, other.word.length);
            long[] tail = maxLen == this.word.length ? this.word : other.word;
            int i2 = minLen;
            while (i2 < maxLen) {
                if (tail[i2] != 0L) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    public int hashCode() {
        int res = 0;
        int i = 0;
        while (i < this.word.length) {
            long w = this.word[i];
            if (w != 0L) {
                res ^= (int)(w & 0xFFFFL);
                res ^= (int)(w >>> 32);
            }
            ++i;
        }
        return res;
    }

    public void clear() {
        int i = 0;
        while (i < this.word.length) {
            this.word[i] = 0L;
            ++i;
        }
    }

    public boolean get(int i) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            return false;
        }
        int bit = i % 64;
        return (this.word[wd] & 1L << bit) != 0L;
    }

    public void set(int i) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            this.grow(wd);
        }
        int bit = i % 64;
        int n = wd;
        this.word[n] = this.word[n] | 1L << bit;
    }

    public void set(int lo, int hi) {
        int lwd = lo / 64;
        int hwd = hi / 64;
        if (hwd >= this.word.length) {
            this.grow(hwd);
        }
        int lbit = lo % 64;
        int hbit = hi % 64;
        if (lwd < hwd) {
            int i = lwd + 1;
            while (i < hwd) {
                this.word[i] = -1L;
                ++i;
            }
            this.word[lwd] = -1L << lbit;
            this.word[hwd] = -1L >>> 63 - hbit;
        } else if (lo <= hi) {
            this.word[lwd] = -1L << lbit & -1L >>> 63 - hbit;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.word.length * 64);
        int i = this.word.length * 64;
        while (i >= 0) {
            if (this.get(i)) {
                buf.append("1");
            } else {
                buf.append("0");
            }
            --i;
        }
        buf.append("]");
        return buf.toString().replaceAll("^0*", "[");
    }

    public String toString(int start, int length) {
        return this.toString(start, length, '1', '0');
    }

    public String toString(int start, int length, char one, char zero) {
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            if (this.get(start + i)) {
                buf.append(one);
            } else {
                buf.append(zero);
            }
            ++i;
        }
        return "[" + buf.reverse().toString() + "]";
    }

    public int trueCnt() {
        int res = 0;
        int i = 0;
        while (i < this.word.length * 64) {
            int wd = i / 64;
            int bit = i % 64;
            if ((this.word[wd] & 1L << bit) != 0L) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    public void reset(int i) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            this.grow(wd);
        }
        int bit = i % 64;
        int n = wd;
        this.word[n] = this.word[n] & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void set(int i, boolean val) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            this.grow(wd);
        }
        int bit = i % 64;
        if (val) {
            int n = wd;
            this.word[n] = this.word[n] | 1L << bit;
        } else {
            int n = wd;
            this.word[n] = this.word[n] & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void write(BufferedRandomAccessFile raf) throws IOException {
        int len = this.word.length;
        raf.writeNat(len);
        int i = 0;
        while (i < len) {
            raf.writeLong(this.word[i]);
            ++i;
        }
    }

    public void read(BufferedRandomAccessFile raf) throws IOException {
        int len = raf.readNat();
        this.word = new long[len];
        int i = 0;
        while (i < len) {
            this.word[i] = raf.readLong();
            ++i;
        }
    }

    private void grow(int wd) {
        int newLen = Math.max(this.word.length, wd + 1);
        long[] tmp = new long[newLen];
        System.arraycopy(this.word, 0, tmp, 0, this.word.length);
        this.word = tmp;
    }

    public static class Iter {
        long[] word;
        int wd;
        int bit;
        long mask;

        public Iter() {
        }

        public Iter(BitVector bv) {
            this.init(bv);
        }

        public void init(BitVector bv) {
            this.word = bv.word;
            this.wd = 0;
            this.bit = 0;
            this.mask = 1L;
        }

        public int next() {
            while (this.wd < this.word.length) {
                long w = this.word[this.wd];
                while (this.bit < 64) {
                    if ((w & this.mask) != 0L) {
                        int res = this.wd * 64 + this.bit;
                        ++this.bit;
                        if (this.bit < 64) {
                            this.mask <<= 1;
                        } else {
                            ++this.wd;
                            this.bit = 0;
                            this.mask = 1L;
                        }
                        return res;
                    }
                    ++this.bit;
                    this.mask <<= 1;
                }
                this.bit = 0;
                this.mask = 1L;
                ++this.wd;
            }
            return -1;
        }
    }
}

