/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import tlc2.tool.TLCState;
import tlc2.tool.fp.MemFPSet;
import tlc2.util.FP64;
import tlc2.value.IValue;

public interface CountDistinct {
    public void add(IValue var1);

    public void add(TLCState var1);

    public void add(long var1);

    public long count();

    public static class HyperLogLog
    implements CountDistinct {
        protected final int m;
        protected final int b;
        protected final int[] M;

        public HyperLogLog(int b) {
            this.b = b;
            this.m = 1 << b;
            this.M = new int[this.m];
        }

        @Override
        public void add(IValue v) {
            this.add(v.fingerPrint(FP64.New()));
        }

        @Override
        public void add(TLCState s) {
            this.add(s.fingerPrint());
        }

        @Override
        public void add(long x) {
            int j = (int)(x >>> 64 - this.b);
            int w = Long.numberOfLeadingZeros(x << this.b | 1L << this.b - 1) + 1;
            this.M[j] = Math.max(this.M[j], w);
        }

        @Override
        public long count() {
            double alpha = this.getAlpha();
            double z = 0.0;
            int i = 0;
            while (i < this.m) {
                z += 1.0 / (double)(1 << this.M[i]);
                ++i;
            }
            double estimate = alpha * (double)this.m * (double)this.m / z;
            if (estimate <= 2.5 * (double)this.m) {
                int v = 0;
                int i2 = 0;
                while (i2 < this.m) {
                    if (this.M[i2] == 0) {
                        ++v;
                    }
                    ++i2;
                }
                if (v != 0) {
                    estimate = (double)this.m * Math.log((double)this.m / (double)v);
                }
            } else if (estimate > 0.03333333333333333 * Math.pow(2.0, 64.0)) {
                estimate = -Math.pow(2.0, 64.0) * Math.log(1.0 - estimate / Math.pow(2.0, 64.0));
            }
            return (int)estimate;
        }

        private double getAlpha() {
            switch (this.m) {
                case 16: {
                    return 0.673;
                }
                case 32: {
                    return 0.697;
                }
                case 64: {
                    return 0.709;
                }
            }
            return 0.7213 / (1.0 + 1.079 / (double)this.m);
        }
    }

    public static class Naive
    implements CountDistinct {
        private final MemFPSet fpSet = MemFPSet.NewMemFPSetUnchecked();

        @Override
        public void add(IValue v) {
            this.fpSet.put(v.fingerPrint(FP64.New()));
        }

        @Override
        public void add(TLCState s) {
            this.fpSet.put(s.fingerPrint());
        }

        @Override
        public void add(long hash) {
            this.fpSet.put(hash);
        }

        @Override
        public long count() {
            return this.fpSet.size();
        }
    }

    public static class Noop
    implements CountDistinct {
        @Override
        public void add(IValue v) {
        }

        @Override
        public void add(TLCState s) {
        }

        @Override
        public void add(long x) {
        }

        @Override
        public long count() {
            return -1L;
        }
    }

    public static class SyncedHyperLogLog
    extends HyperLogLog {
        public SyncedHyperLogLog(int b) {
            super(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long x) {
            int j = (int)(x >>> 64 - this.b);
            int w = Long.numberOfLeadingZeros(x << this.b | 1L << this.b - 1) + 1;
            SyncedHyperLogLog syncedHyperLogLog = this;
            synchronized (syncedHyperLogLog) {
                this.M[j] = Math.max(this.M[j], w);
            }
        }

        @Override
        public synchronized long count() {
            return super.count();
        }
    }
}

