/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcal.AST;
import pcal.IntPair;
import pcal.PCalTLAGenerator;
import pcal.ParseAlgorithm;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.PcalParams;
import pcal.PcalResourceFileReader;
import pcal.PcalTLAGen;
import pcal.TLAtoPCalMapping;
import pcal.ValidationCallBack;
import pcal.Validator;
import pcal.exception.FileToStringVectorException;
import pcal.exception.ParseAlgorithmException;
import pcal.exception.PcalResourceFileReaderException;
import pcal.exception.RemoveNameConflictsException;
import pcal.exception.StringVectorToFileException;
import pcal.exception.TLCTranslationException;
import pcal.exception.UnrecoverableException;
import util.ToolIO;

class trans {
    static final int STATUS_OK = 1;
    static final int STATUS_EXIT_WITHOUT_ERROR = 0;
    static final int STATUS_EXIT_WITH_ERRORS = -1;
    private static final String PCAL_TRANSLATION_COMMENT_LINE_PREFIX = "\\* BEGIN TRANSLATION";
    private static final String TLA_TRANSLATION_COMMENT_LINE_PREFIX = "\\* END TRANSLATION";
    private static final String LABEL_ROOT_REGEX = "[a-zA-Z][a-zA-Z0-9_]*";
    private static final Pattern LABEL_ROOT_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    trans() {
    }

    public static void main(String[] args) {
        trans.runMe(args);
    }

    public static int runMe(String[] args) {
        boolean writeCfg;
        boolean renameToOld;
        if (ToolIO.getMode() == 0) {
            PcalDebug.reportInfo("pcal.trans Version 1.12 of 01 July 2024");
        }
        PcalParams.resetParams();
        int status = trans.parseAndProcessArguments(args);
        if (status != 1) {
            return trans.exitWithStatus(status);
        }
        List<String> inputVec = null;
        try {
            inputVec = trans.fileToStringVector(PcalParams.TLAInputFile + ".tla");
        }
        catch (FileToStringVectorException e) {
            PcalDebug.reportError(e);
            return trans.exitWithStatus(-1);
        }
        List<String> outputVec = trans.performTranslation(inputVec);
        if (outputVec == null) {
            return trans.exitWithStatus(-1);
        }
        boolean bl = renameToOld = !PcalParams.NoOld;
        if (renameToOld) {
            try {
                File file = new File(PcalParams.TLAInputFile + ".old");
                if (file.exists()) {
                    file.delete();
                }
                file = new File(PcalParams.TLAInputFile + ".tla");
                file.renameTo(new File(PcalParams.TLAInputFile + ".old"));
            }
            catch (Exception e) {
                PcalDebug.reportError("Could not rename input file " + PcalParams.TLAInputFile + ".tla to " + PcalParams.TLAInputFile + ".old");
                return trans.exitWithStatus(-1);
            }
        }
        try {
            trans.WriteStringVectorToFile(outputVec, PcalParams.TLAInputFile + ".tla");
        }
        catch (StringVectorToFileException e) {
            PcalDebug.reportError(e);
            return trans.exitWithStatus(-1);
        }
        PcalDebug.reportInfo("New file " + PcalParams.TLAInputFile + ".tla written.");
        File cfgFile = new File(PcalParams.TLAInputFile + ".cfg");
        List<Object> cfg = null;
        boolean bl2 = writeCfg = !PcalParams.Nocfg;
        if (writeCfg && cfgFile.exists()) {
            if (cfgFile.canRead()) {
                try {
                    cfg = trans.fileToStringVector(PcalParams.TLAInputFile + ".cfg");
                }
                catch (FileToStringVectorException e) {
                    PcalDebug.reportError(e);
                    return trans.exitWithStatus(-1);
                }
            } else {
                writeCfg = false;
                PcalDebug.reportInfo("File " + PcalParams.TLAInputFile + ".cfg is read only, new version not written.");
            }
        } else {
            cfg = new ArrayList<String>();
            cfg.add(PcalParams.CfgFileDelimiter);
        }
        if (writeCfg) {
            int j = 0;
            boolean done = false;
            while (!done && cfg.size() > j) {
                if (((String)cfg.get(j)).indexOf(PcalParams.CfgFileDelimiter) == -1) {
                    ++j;
                    continue;
                }
                done = true;
            }
            if (done) {
                while (j > 0) {
                    cfg.remove(0);
                    --j;
                }
            } else {
                cfg.add(0, PcalParams.CfgFileDelimiter);
            }
            if (PcalParams.tlcTranslation() || ParseAlgorithm.hasDefaultInitialization) {
                cfg.add(0, "CONSTANT defaultInitValue = defaultInitValue");
            }
            if (PcalParams.CheckTermination) {
                cfg.add(0, "PROPERTY Termination");
            }
            boolean hasSpec = false;
            for (String string : cfg) {
                if (string.indexOf("SPECIFICATION") == -1 || string.indexOf("\\*") != -1 && string.indexOf("\\*") <= string.indexOf("SPECIFICATION")) continue;
                hasSpec = true;
                break;
            }
            if (hasSpec) {
                PcalDebug.reportInfo("File " + PcalParams.TLAInputFile + ".cfg already contains SPECIFICATION statement,\n   so new one not written.");
            } else {
                cfg.add(0, "SPECIFICATION Spec");
            }
            try {
                trans.WriteStringVectorToFile(cfg, PcalParams.TLAInputFile + ".cfg");
            }
            catch (StringVectorToFileException stringVectorToFileException) {
                PcalDebug.reportError(stringVectorToFileException);
                return trans.exitWithStatus(-1);
            }
            PcalDebug.reportInfo("New file " + PcalParams.TLAInputFile + ".cfg written.");
        }
        return trans.exitWithStatus(0);
    }

    public static List<String> performTranslation(List<String> specificationText) {
        return trans.performTranslation(specificationText, new ValidationCallBack.Noop());
    }

    public static List<String> performTranslation(List<String> specificationText, ValidationCallBack cb) {
        TLAtoPCalMapping mapping;
        PcalParams.tlaPcalMapping = mapping = new TLAtoPCalMapping();
        Vector<String> untabInputVec = trans.removeTabs(specificationText);
        IntPair searchLoc = new IntPair(0, 0);
        boolean notDone = true;
        while (notDone) {
            try {
                ParseAlgorithm.FindToken("PlusCal", untabInputVec, searchLoc, "");
                String line = ParseAlgorithm.GotoNextNonSpace(untabInputVec, searchLoc);
                String restOfLine = line.substring(searchLoc.two);
                if (!restOfLine.startsWith("options") || ParseAlgorithm.NextNonIdChar(restOfLine, 0) != 7) continue;
                PcalParams.optionsInFile = true;
                ParseAlgorithm.ProcessOptions(untabInputVec, searchLoc);
                notDone = false;
            }
            catch (ParseAlgorithmException e) {
                notDone = false;
            }
        }
        int translationLine = 0;
        int algLine = 0;
        int algCol = -1;
        ArrayList<String> output = new ArrayList<String>(specificationText);
        translationLine = trans.findTokenPair(untabInputVec, 0, "BEGIN", "TRANSLATION");
        int endTranslationLine = -1;
        if (translationLine != -1) {
            endTranslationLine = trans.findTokenPair(untabInputVec, translationLine + 1, "END", "TRANSLATION");
            if (endTranslationLine == -1) {
                PcalDebug.reportError("No line containing `END TRANSLATION");
                return null;
            }
            int etl = endTranslationLine - 1;
            while (translationLine < etl) {
                output.remove(etl);
                untabInputVec.remove(etl);
                --etl;
            }
        }
        boolean foundBegin = false;
        boolean foundFairBegin = false;
        while (algLine < untabInputVec.size() && !foundBegin) {
            String line = untabInputVec.elementAt(algLine);
            algCol = line.indexOf("--algorithm");
            if (algCol != -1) {
                algCol += "--algorithm".length();
                foundBegin = true;
                continue;
            }
            algCol = line.indexOf("--fair");
            if (algCol != -1) {
                algCol += "--fair".length();
                foundBegin = true;
                foundFairBegin = true;
                continue;
            }
            ++algLine;
        }
        if (!foundBegin) {
            PcalDebug.reportError("Beginning of algorithm string --algorithm not found.");
            return null;
        }
        mapping.algColumn = algCol;
        mapping.algLine = algLine;
        if (translationLine == -1) {
            int depth = 1;
            int ecLine = algLine;
            int ecCol = algCol;
            boolean notFound = true;
            while (notFound && ecLine < untabInputVec.size()) {
                char[] line = untabInputVec.elementAt(ecLine).toCharArray();
                while (notFound && ecCol < line.length - 1) {
                    char ch = line[ecCol];
                    char ch2 = line[ecCol + 1];
                    if (ch == '(' && ch2 == '*') {
                        ++depth;
                        ecCol += 2;
                        continue;
                    }
                    if (ch == '*' && ch2 == ')') {
                        ecCol += 2;
                        if (--depth != 0) continue;
                        notFound = false;
                        continue;
                    }
                    ++ecCol;
                }
                if (!notFound) continue;
                ++ecLine;
                ecCol = 0;
            }
            if (notFound) {
                PcalDebug.reportError("Algorithm not in properly terminated comment");
                return null;
            }
            String endStuff = untabInputVec.elementAt(ecLine).substring(ecCol).trim();
            if (!endStuff.equals("") && !endStuff.startsWith("\\*")) {
                PcalDebug.reportError("Text on same line following `*)' that ends the \n   comment containing the algorithm.");
                return null;
            }
            output.add(ecLine + 1, "\\* BEGIN TRANSLATION " + String.format("(chksum(pcal) = \"%s\" /\\ chksum(tla) = \"%s\")", "ffffffff", "ffffffff"));
            untabInputVec.insertElementAt(PCAL_TRANSLATION_COMMENT_LINE_PREFIX, ecLine + 1);
            output.add(ecLine + 2, "\\* END TRANSLATION ");
            untabInputVec.insertElementAt(TLA_TRANSLATION_COMMENT_LINE_PREFIX, ecLine + 2);
            translationLine = ecLine + 1;
        } else {
            Matcher m = Validator.CHECKSUM_PATTERN.matcher(output.get(translationLine));
            if (m.find() && m.group("tlachecksum") != null) {
                String checksumTLATranslation = Validator.checksum(new Vector<String>(specificationText.subList(translationLine + 1, endTranslationLine)));
                if (!m.group("tlachecksum").equals(checksumTLATranslation) && cb.shouldCancel()) {
                    return null;
                }
            }
        }
        mapping.tlaStartLine = translationLine + 1;
        try {
            ParseAlgorithm.uncomment(untabInputVec, algLine, algCol);
        }
        catch (ParseAlgorithmException e) {
            PcalDebug.reportError(e);
            return null;
        }
        PcalCharReader reader = new PcalCharReader(untabInputVec, algLine, algCol, output.size(), 0);
        AST ast = null;
        try {
            ast = ParseAlgorithm.getAlgorithm(reader, foundFairBegin);
        }
        catch (ParseAlgorithmException e) {
            PcalDebug.reportError(e);
            return null;
        }
        PcalDebug.reportInfo("Parsing completed.");
        if (PcalParams.WriteASTFlag) {
            trans.WriteAST(ast);
            return null;
        }
        PCalTLAGenerator pcalTLAGenerator = new PCalTLAGenerator(ast);
        try {
            pcalTLAGenerator.removeNameConflicts();
        }
        catch (RemoveNameConflictsException e1) {
            PcalDebug.reportError(e1);
            return null;
        }
        Vector<String> translation = null;
        if (PcalParams.tlcTranslation()) {
            try {
                translation = trans.TLCTranslate(ast);
            }
            catch (TLCTranslationException e) {
                PcalDebug.reportError(e);
                return null;
            }
        }
        try {
            translation = pcalTLAGenerator.translate();
        }
        catch (RemoveNameConflictsException e) {
            PcalDebug.reportError(e);
            return null;
        }
        Matcher m = Validator.CHECKSUM_PATTERN.matcher(output.get(mapping.tlaStartLine - 1));
        ValidationCallBack.Generate g = null;
        if (m.find()) {
            if (m.group("tlachecksum") != null) {
                output.set(mapping.tlaStartLine - 1, new StringBuilder(output.get(mapping.tlaStartLine - 1)).replace(m.start("tlachecksum"), m.end("tlachecksum"), Validator.checksum(translation)).toString());
            }
            if (m.group("pcalchecksum") != null) {
                output.set(mapping.tlaStartLine - 1, new StringBuilder(output.get(mapping.tlaStartLine - 1)).replace(m.start("pcalchecksum"), m.end("pcalchecksum"), Validator.checksum((String)(foundFairBegin ? "fair" : ast.toString()))).toString());
            }
        } else {
            g = cb.shouldGenerate();
            if (g != ValidationCallBack.Generate.NOT_NOW) {
                if (g == ValidationCallBack.Generate.DO_IT) {
                    output.set(mapping.tlaStartLine - 1, output.get(mapping.tlaStartLine - 1) + " " + String.format("(chksum(pcal) = \"%s\" /\\ chksum(tla) = \"%s\")", Validator.checksum((String)(foundFairBegin ? "fair" : ast.toString())), Validator.checksum(translation)));
                } else {
                    output.set(mapping.tlaStartLine - 1, output.get(mapping.tlaStartLine - 1) + " (chksum(pcal) \\in STRING /\\ chksum(tla) \\in STRING)");
                }
            }
        }
        int i = 0;
        while (i < translation.size()) {
            output.add(i + translationLine + 1, translation.elementAt(i));
            ++i;
        }
        PcalDebug.reportInfo("Translation completed.");
        return output;
    }

    private static int exitWithStatus(int status) {
        if (ToolIO.getMode() == 0) {
            System.exit(status);
        }
        return status;
    }

    private static boolean WriteAST(AST ast) {
        Vector<String> astFile = new Vector<String>();
        astFile.addElement("------ MODULE AST -------");
        astFile.addElement("EXTENDS TLC");
        astFile.addElement("fairness == \"" + PcalParams.FairnessOption + "\"");
        astFile.addElement(" ");
        astFile.addElement("ast == ");
        astFile.addElement(ast.toString());
        astFile.addElement("==========================");
        try {
            trans.WriteStringVectorToFile(astFile, "AST.tla");
        }
        catch (StringVectorToFileException e) {
            PcalDebug.reportError(e);
            return false;
        }
        PcalDebug.reportInfo("Wrote file AST.tla.");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static Vector<String> TLCTranslate(AST ast) throws TLCTranslationException {
        trans.WriteAST(ast);
        if (PcalParams.SpecOption || PcalParams.Spec2Option) {
            try {
                parseFile = PcalResourceFileReader.ResourceFileToStringVector(PcalParams.SpecFile + ".tla");
                trans.WriteStringVectorToFile(parseFile, PcalParams.SpecFile + ".tla");
                parseFile = PcalResourceFileReader.ResourceFileToStringVector(PcalParams.SpecFile + ".cfg");
                trans.WriteStringVectorToFile(parseFile, PcalParams.SpecFile + ".cfg");
                PcalDebug.reportInfo("Wrote files " + PcalParams.SpecFile + ".tla and " + PcalParams.SpecFile + ".cfg.");
            }
            catch (UnrecoverableException e) {
                throw new TLCTranslationException(e.getMessage());
            }
        }
        if (PcalParams.SpecOption || PcalParams.MyspecOption) {
            PcalDebug.reportInfo("Running TLC2.");
            javaInvocation = "java -Xss1m tlc2.TLC ";
        } else {
            PcalDebug.reportInfo("Running TLC2.");
            javaInvocation = "java -Xss1m tlc2.TLC ";
        }
        tlcOut = "      ";
        rt = Runtime.getRuntime();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(rt.exec(javaInvocation + PcalParams.SpecFile).getInputStream()));
            while (tlcOut.indexOf("<<") == -1) {
                tlcOut = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            throw new TLCTranslationException("Error reading output of TLC");
        }
        if (tlcOut.indexOf("@Error@") != -1) {
            throw new TLCTranslationException("TLC's translation of the parsed algorithm failed with\n  Error: " + tlcOut.substring(tlcOut.indexOf("@Error@") + 7, tlcOut.indexOf("@EndError@")));
        }
        tlcOut = tlcOut.substring(2, tlcOut.lastIndexOf(">>")) + "  ";
        PcalDebug.reportInfo("Read TLC output.");
        i = 0;
        transl = "";
        while (i < tlcOut.length()) {
            block18: {
                if (tlcOut.charAt(i) != '\"') break block18;
                if (tlcOut.charAt(++i) != '\\' || tlcOut.charAt(i + 1) != '\"') ** GOTO lbl62
                if (tlcOut.charAt(i + 2) != '\"') {
                    throw new TLCTranslationException("I'm confused");
                }
                i += 3;
                while (tlcOut.charAt(i) != '\"') {
                    ++i;
                }
                ++i;
                transl = (String)transl + "\"";
                while (tlcOut.charAt(i) != '\"') {
                    if (tlcOut.charAt(i) == '\\') {
                        transl = (String)transl + tlcOut.substring(i, i + 2);
                        i += 2;
                        continue;
                    }
                    transl = (String)transl + tlcOut.substring(i, i + 1);
                    ++i;
                }
                i += 8;
                transl = (String)transl + "\"";
                continue;
lbl-1000:
                // 1 sources

                {
                    if (tlcOut.charAt(i) == '\\' && tlcOut.charAt(i + 1) == '\\') {
                        ++i;
                    }
                    transl = (String)transl + tlcOut.substring(i, i + 1);
                    ++i;
lbl62:
                    // 2 sources

                    ** while (tlcOut.charAt((int)i) != '\"')
                }
lbl63:
                // 1 sources

                ++i;
                continue;
            }
            if (tlcOut.charAt(i) == ',') {
                ++i;
                continue;
            }
            if (tlcOut.charAt(i) != ' ') {
                throw new TLCTranslationException("Expected space but found `" + tlcOut.charAt(i) + "'");
            }
            transl = (String)transl + tlcOut.substring(i, i + 1);
            ++i;
        }
        transl = trans.WrapString((String)transl, 78);
        result = new Vector<String>();
        result.addElement((String)transl);
        return result;
    }

    private static void WriteStringVectorToFile(List<String> inputVec, String fileName) throws StringVectorToFileException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter fileW = Files.newBufferedWriter(Path.of(fileName, new String[0]), new OpenOption[0]);){
                for (String line : inputVec) {
                    fileW.write(line);
                    fileW.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new StringVectorToFileException("Could not write file " + fileName);
        }
    }

    private static List<String> fileToStringVector(String fileName) throws FileToStringVectorException {
        try {
            return Files.readAllLines(Path.of(fileName, new String[0]));
        }
        catch (NoSuchFileException e) {
            throw new FileToStringVectorException("Input file " + fileName + " not found");
        }
        catch (IOException e) {
            throw new FileToStringVectorException("Error reading file " + fileName + ".");
        }
    }

    /*
     * Unable to fully structure code
     */
    static int parseAndProcessArguments(String[] args) {
        inFile = PcalParams.optionsInFile;
        notInFile = inFile == false;
        firstFairness = inFile;
        explicitNof = false;
        nextArg = 0;
        maxArg = args.length - 1;
        if (maxArg < 0) {
            return trans.CommandLineError("No arguments specified");
        }
        if (!notInFile || args[maxArg].length() == 0 || args[maxArg].charAt(0) != '-') ** GOTO lbl145
        if (trans.OutputHelpMessage()) {
            return 0;
        }
        return -1;
lbl-1000:
        // 1 sources

        {
            option = args[nextArg];
            if (notInFile && option.equals("-help")) {
                if (trans.OutputHelpMessage()) {
                    return 0;
                }
                return -1;
            }
            if (notInFile && option.equals("-writeAST")) {
                PcalParams.WriteASTFlag = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
            } else if (option.equals("-spec") || inFile && option.equals("spec")) {
                PcalParams.SpecOption = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-spec' option");
                }
                PcalParams.SpecFile = args[nextArg];
            } else if (option.equals("-myspec") || inFile && option.equals("myspec")) {
                PcalParams.MyspecOption = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-myspec' option");
                }
                PcalParams.SpecFile = args[nextArg];
            } else if (notInFile && option.equals("-spec2")) {
                PcalParams.Spec2Option = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-spec' option");
                }
                PcalParams.SpecFile = args[nextArg];
            } else if (notInFile && option.equals("-myspec2")) {
                PcalParams.Myspec2Option = true;
                if (trans.CheckForConflictingSpecOptions()) {
                    return -1;
                }
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Specification name must follow `-myspec' option");
                }
                PcalParams.SpecFile = args[nextArg];
            } else if (notInFile && option.equals("-debug")) {
                PcalParams.Debug = true;
            } else if (notInFile && option.equals("-unixEOL")) {
                System.setProperty("line.separator", "\n");
            } else if (option.equals("-termination") || inFile && option.equals("termination")) {
                PcalParams.CheckTermination = true;
            } else if (option.equals("-noold")) {
                PcalParams.NoOld = true;
            } else if (option.equals("-nocfg")) {
                PcalParams.Nocfg = true;
            } else if (option.equals("-noDoneDisjunct") || inFile && option.equals("noDoneDisjunct")) {
                PcalParams.NoDoneDisjunct = true;
            } else if (option.equals("-wf") || inFile && option.equals("wf")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "wf";
            } else if (option.equals("-sf") || inFile && option.equals("sf")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "sf";
            } else if (option.equals("-wfNext") || inFile && option.equals("wfNext")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "wfNext";
            } else if (option.equals("-nof") || inFile && option.equals("nof")) {
                if (firstFairness) {
                    PcalParams.FairnessOption = "";
                    firstFairness = false;
                }
                if (!PcalParams.FairnessOption.equals("")) {
                    return trans.CommandLineError("Can only have one of -wf, -sf, -wfNext, and -nof options");
                }
                PcalParams.FairnessOption = "nof";
                explicitNof = true;
            } else if (option.equals("-label") || inFile && option.equals("label")) {
                PcalParams.LabelFlag = true;
            } else if (notInFile && option.equals("-reportLabels")) {
                PcalParams.ReportLabelsFlag = true;
                PcalParams.LabelFlag = true;
            } else if (option.equals("-labelRoot") || inFile && option.equals("labelRoot")) {
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Label root must follow `-labelRoot' option");
                }
                labelRootArg = args[nextArg];
                if (!trans.LABEL_ROOT_PATTERN.matcher(labelRootArg).matches()) {
                    return trans.CommandLineError("Label root must be a valid PlusCal identifier (must start with a letter and contain only letters, numbers, and underscores)");
                }
                PcalParams.LabelRoot = labelRootArg;
            } else if (option.equals("-version") || inFile && option.equals("version")) {
                if (++nextArg == maxArg) {
                    return trans.CommandLineError("Version number must follow `-version' option");
                }
                if (!PcalParams.ProcessVersion(args[nextArg])) {
                    return trans.CommandLineError("Bad version number");
                }
            } else if (option.equals("-lineWidth")) {
                ++nextArg;
                try {
                    if (nextArg == maxArg) {
                        throw new NumberFormatException();
                    }
                    a = Integer.parseInt(args[nextArg]);
                    if (a < 60) {
                        throw new NumberFormatException();
                    }
                    PcalTLAGen.wrapColumn = a;
                    PcalTLAGen.ssWrapColumn = a - 33;
                }
                catch (Exception e) {
                    return trans.CommandLineError("Integer value at least 60 must follow `-lineWidth' option");
                }
            } else {
                if (notInFile) {
                    return trans.CommandLineError("Unknown command-line option: " + option);
                }
                return trans.CommandLineError("Unknown or illegal option in options statement: " + option);
            }
            ++nextArg;
lbl145:
            // 2 sources

            ** while (nextArg < maxArg)
        }
lbl146:
        // 1 sources

        if (nextArg > maxArg) {
            return trans.CommandLineError("No input file specified");
        }
        if (PcalParams.FairnessOption.equals("-nof")) {
            PcalParams.FairnessOption = "";
        }
        if (PcalParams.CheckTermination && PcalParams.FairnessOption.equals("") && !explicitNof) {
            PcalParams.FairnessOption = "wf";
        }
        if (inFile) {
            return 1;
        }
        file = new File(args[maxArg]);
        hasExtension = false;
        if (file.getName().lastIndexOf(".") == -1) {
            PcalParams.TLAInputFile = file.getPath();
        } else if (file.getName().toLowerCase().endsWith(".tla")) {
            hasExtension = true;
        } else {
            return trans.CommandLineError("Input file has extension other than tla");
        }
        if (hasExtension) {
            PcalParams.TLAInputFile = file.getPath().substring(0, file.getPath().lastIndexOf("."));
        }
        return 1;
    }

    private static boolean OutputHelpMessage() {
        Vector<String> helpVec = null;
        try {
            helpVec = PcalResourceFileReader.ResourceFileToStringVector("help.txt");
        }
        catch (PcalResourceFileReaderException e) {
            PcalDebug.reportError(e);
            return false;
        }
        int i = 0;
        while (i < helpVec.size()) {
            ToolIO.out.println(helpVec.elementAt(i));
            ++i;
        }
        return true;
    }

    private static boolean CheckForConflictingSpecOptions() {
        if ((PcalParams.SpecOption ? 1 : 0) + (PcalParams.MyspecOption ? 1 : 0) + (PcalParams.Spec2Option ? 1 : 0) + (PcalParams.Myspec2Option ? 1 : 0) + (PcalParams.WriteASTFlag ? 1 : 0) > 1) {
            trans.CommandLineError("\nCan have at most one of the options -spec, -myspec, -spec2, -myspec2, writeAST");
            return true;
        }
        return false;
    }

    private static int CommandLineError(String msg) {
        PcalDebug.reportError("Command-line error: " + msg + ".");
        return -1;
    }

    static int findTokenPair(Vector<String> vec, int lineNum, String tok1, String tok2) {
        int i = lineNum;
        while (i < vec.size()) {
            String line = vec.elementAt(i);
            int col = line.indexOf(tok1);
            int nextcol = col + tok1.length();
            if (col != -1) {
                while (nextcol < line.length() && line.charAt(nextcol) == ' ') {
                    ++nextcol;
                }
                if (nextcol < line.length() && nextcol == line.indexOf(tok2)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static Vector<String> removeTabs(List<String> input) {
        Vector<String> newVec = new Vector<String>();
        for (String oldLine : input) {
            Object newLine = "";
            int next = 0;
            while (next < oldLine.length()) {
                if (oldLine.charAt(next) == '\t') {
                    int toAdd = 8 - ((String)newLine).length() % 8;
                    while (toAdd > 0) {
                        newLine = (String)newLine + " ";
                        --toAdd;
                    }
                } else {
                    newLine = (String)newLine + oldLine.substring(next, next + 1);
                }
                ++next;
            }
            newLine = (String)newLine + " ";
            newVec.add((String)newLine);
        }
        return newVec;
    }

    private static int NextSpace(String s, int cur) {
        int i = cur;
        boolean inString = false;
        while (i < s.length() && (s.charAt(i) != ' ' || inString)) {
            if (s.charAt(i) == '\"' && (i == 0 || s.charAt(i - 1) != '\\')) {
                inString = !inString;
            }
            ++i;
        }
        if (i == s.length()) {
            return i - 1;
        }
        return i;
    }

    private static String WrapString(String inString, int col) {
        int i = 0;
        int ccol = 1;
        StringBuffer sb = new StringBuffer();
        while (i < inString.length()) {
            if (inString.charAt(i) == ' ') {
                sb.append(' ');
                ++i;
                ++ccol;
                continue;
            }
            int j = trans.NextSpace(inString, i);
            if (ccol + (j - i + 1) > col) {
                sb.append('\n');
                ccol = 1;
            }
            while (i <= j) {
                sb.append(inString.charAt(i));
                ++i;
                ++ccol;
            }
        }
        return sb.toString();
    }
}

