/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;

class JunctionListContext {
    private final Deque<JunctionListInfo> stack = new ArrayDeque<JunctionListInfo>();

    private static boolean isJunctionListBulletToken(int kind) {
        return 129 == kind || 132 == kind;
    }

    private static JunctionListType asJunctionListType(int kind) throws IllegalArgumentException {
        switch (kind) {
            case 129: {
                return JunctionListType.CONJUNCTION;
            }
            case 132: {
                return JunctionListType.DISJUNCTION;
            }
        }
        throw new IllegalArgumentException(Integer.toString(kind));
    }

    public void startNewJunctionList(int column, int kind) throws IllegalArgumentException {
        this.stack.push(new JunctionListInfo(JunctionListContext.asJunctionListType(kind), column));
    }

    public void terminateCurrentJunctionList() throws NoSuchElementException {
        this.stack.pop();
    }

    public boolean isNewBullet(int column, int kind) {
        JunctionListInfo headOrNull = this.stack.peekFirst();
        return headOrNull != null && JunctionListContext.isJunctionListBulletToken(kind) && headOrNull.Column == column && headOrNull.Type == JunctionListContext.asJunctionListType(kind);
    }

    public boolean isAboveCurrent(int column) {
        JunctionListInfo headOrNull = this.stack.peekFirst();
        return headOrNull == null || headOrNull.Column < column;
    }

    private class JunctionListInfo {
        public final JunctionListType Type;
        public final int Column;

        public JunctionListInfo(JunctionListType type, int column) {
            this.Type = type;
            this.Column = column;
        }
    }

    private static enum JunctionListType {
        CONJUNCTION,
        DISJUNCTION;

    }
}

