/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class AssumeProveNode
extends LevelNode {
    protected LevelNode[] assumes = null;
    protected ExprNode prove = null;
    protected boolean[] inScopeOfDecl;
    protected boolean inProof = true;
    protected boolean suffices = false;
    protected boolean isBoxAssumeProve;
    private ThmOrAssumpDefNode goal = null;

    protected boolean isSuffices() {
        return this.suffices;
    }

    void setSuffices() {
        this.suffices = true;
    }

    public boolean getSuffices() {
        return this.suffices;
    }

    public boolean getIsBoxAssumeProve() {
        return this.isBoxAssumeProve;
    }

    protected void setIsBoxAssumeProve(boolean value) {
        this.isBoxAssumeProve = value;
    }

    public AssumeProveNode(TreeNode stn, ThmOrAssumpDefNode gl) {
        super(14, stn);
        this.goal = gl;
    }

    public final SemanticNode[] getAssumes() {
        return this.assumes;
    }

    public final ExprNode getProve() {
        return this.prove;
    }

    public ThmOrAssumpDefNode getGoal() {
        return this.goal;
    }

    @Override
    public boolean levelCheck(int iter, Errors errors) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        this.levelChecked = iter;
        this.levelCorrect = true;
        int i = 0;
        while (i < this.assumes.length) {
            if (this.assumes[i] != null && !this.assumes[i].levelCheck(iter, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        this.prove.levelCheck(iter, errors);
        this.level = this.prove.getLevel();
        i = 0;
        while (i < this.assumes.length) {
            this.assumes[i].levelCheck(iter, errors);
            if (this.assumes[i].getLevel() > this.level) {
                this.level = this.assumes[i].getLevel();
            }
            ++i;
        }
        this.levelParams.addAll(this.prove.getLevelParams());
        this.allParams.addAll(this.prove.getAllParams());
        i = 0;
        while (i < this.assumes.length) {
            this.levelParams.addAll(this.assumes[i].getLevelParams());
            this.allParams.addAll(this.assumes[i].getAllParams());
            ++i;
        }
        this.levelConstraints.putAll(this.prove.getLevelConstraints());
        i = 0;
        while (i < this.assumes.length) {
            this.levelConstraints.putAll(this.assumes[i].getLevelConstraints());
            ++i;
        }
        this.argLevelConstraints.putAll(this.prove.getArgLevelConstraints());
        i = 0;
        while (i < this.assumes.length) {
            this.argLevelConstraints.putAll(this.assumes[i].getArgLevelConstraints());
            ++i;
        }
        this.argLevelParams.addAll(this.prove.getArgLevelParams());
        i = 0;
        while (i < this.assumes.length) {
            this.argLevelParams.addAll(this.assumes[i].getArgLevelParams());
            ++i;
        }
        if (this.levelCorrect) {
            AssumeProveNode.addTemporalLevelConstraintToConstants(this.levelParams, this.levelConstraints);
        }
        return this.levelCorrect;
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.assumes.length + 1];
        res[this.assumes.length] = this.prove;
        int i = 0;
        while (i < this.assumes.length) {
            res[i] = this.assumes[i];
            ++i;
        }
        return res;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> h, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (h.get(uid) != null) {
            return;
        }
        h.put(uid, this);
        visitor.preVisit(this);
        int i = 0;
        while (i < this.assumes.length) {
            this.assumes[i].walkGraph(h, visitor);
            ++i;
        }
        this.prove.walkGraph(h, visitor);
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        Object assumeStr = "";
        int i = 0;
        while (i < this.assumes.length) {
            assumeStr = (String)assumeStr + Strings.indent(4, this.assumes[i].toString(depth - 1, errors));
            ++i;
        }
        String goalStr = "null";
        if (this.goal != null) {
            goalStr = Strings.indent(4, this.goal.toString(1, errors));
        }
        return "\n*AssumeProveNode: " + super.toString(depth, errors) + "\n  " + (this.isBoxAssumeProve ? "[]" : "") + "Assumes: " + (String)assumeStr + "\n  " + (this.isBoxAssumeProve ? "[]" : "") + "Prove: " + Strings.indent(4, this.prove.toString(depth - 1, errors)) + "\n  Goal: " + goalStr + (this.suffices ? "\n  SUFFICES" : "");
    }

    @Override
    public Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("AssumeProveNode");
        Element antecedent = doc.createElement("assumes");
        Element succedent = doc.createElement("prove");
        SemanticNode[] assumes = this.getAssumes();
        int i = 0;
        while (i < assumes.length) {
            antecedent.appendChild(assumes[i].export(doc, context, filter));
            ++i;
        }
        succedent.appendChild(this.getProve().export(doc, context, filter));
        e.appendChild(antecedent);
        e.appendChild(succedent);
        if (this.isSuffices()) {
            e.appendChild(doc.createElement("suffices"));
        }
        if (this.isBoxAssumeProve) {
            e.appendChild(doc.createElement("boxed"));
        }
        return e;
    }
}

