/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCDebugger;
import tlc2.tool.impl.Tool;
import util.ToolIO;

public class AttachingDebugger
extends TLCDebugger {
    private String buffer = "";
    private final int port;

    public AttachingDebugger(int port, IDebugTarget.Step s, boolean halt) throws IOException, InterruptedException, ExecutionException {
        super(s, halt);
        this.port = port;
        PipedInputStream pin = new PipedInputStream();
        System.setIn(pin);
        this.pipedOutputStream = new PipedOutputStream(pin);
        ToolIO.out = new PrintStream(ToolIO.out){

            @Override
            public void println(String str) {
                ((PrintStream)this.out).println(str);
                this.sendOutput(str + "\n");
            }

            @Override
            public void print(String str) {
                ((PrintStream)this.out).print(str);
                this.sendOutput(str);
            }

            private void sendOutput(String str) {
                if (AttachingDebugger.this.launcher != null) {
                    OutputEventArguments oea = new OutputEventArguments();
                    oea.setOutput(str);
                    ((IDebugProtocolClient)AttachingDebugger.this.launcher.getRemoteProxy()).output(oea);
                } else {
                    AttachingDebugger.this.buffer = String.valueOf(AttachingDebugger.this.buffer) + str;
                }
            }
        };
    }

    @Override
    public IDebugTarget setTool(Tool tool) {
        super.setTool(tool);
        Executors.newSingleThreadExecutor().submit(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ServerSocket serverSocket = new ServerSocket(this.port);
                try {
                    while (true) {
                        System.out.printf("Debugger is listening on %s\n", serverSocket.getLocalSocketAddress());
                        Socket socket = serverSocket.accept();
                        InputStream inputStream = socket.getInputStream();
                        OutputStream outputStream = socket.getOutputStream();
                        this.launcher = DSPLauncher.createServerLauncher(this, inputStream, outputStream);
                        this.launcher.startListening().get();
                    }
                }
                catch (Throwable throwable2) {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        });
        return this;
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, Object> args) {
        LOGGER.finer("launch");
        Executors.newSingleThreadExecutor().submit(() -> {
            ((IDebugProtocolClient)this.launcher.getRemoteProxy()).initialized();
            if (!"".equals(this.buffer)) {
                OutputEventArguments oea = new OutputEventArguments();
                oea.setOutput(this.buffer);
                ((IDebugProtocolClient)this.launcher.getRemoteProxy()).output(oea);
                this.buffer = "";
            }
            StoppedEventArguments eventArguments = new StoppedEventArguments();
            eventArguments.setThreadId(0);
            eventArguments.setReason("");
            ((IDebugProtocolClient)this.launcher.getRemoteProxy()).stopped(eventArguments);
        });
        return CompletableFuture.completedFuture(null);
    }
}

