/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Value;
import util.UniqueString;
import util.WrongInvocationException;

public final class TLCStateMutExt
extends TLCState
implements Serializable {
    private IValue[] values;
    private static ITool mytool = null;
    private static SemanticNode viewMap = null;
    private static IMVPerm[] perms = null;
    private Action action;
    private TLCState predecessor;
    private Callable<?> callable;
    private Map<Integer, Value> cache = new HashMap<Integer, Value>(0);

    private TLCStateMutExt(IValue[] vals) {
        this.values = vals;
    }

    public static void setVariables(OpDeclNode[] variables) {
        vars = variables;
        IValue[] vals = new IValue[vars.length];
        Empty = new TLCStateMutExt(vals);
    }

    public static void setTool(ITool tool) {
        mytool = tool;
        viewMap = tool.getViewSpec();
        perms = tool.getSymmetryPerms();
    }

    public static ITool resetTool(ITool tool) {
        ITool old = mytool;
        mytool = tool;
        return old;
    }

    @Override
    public final TLCState createEmpty() {
        IValue[] vals = new IValue[vars.length];
        return new TLCStateMutExt(vals);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TLCStateMutExt) {
            TLCStateMutExt state = (TLCStateMutExt)obj;
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] == null ? state.values[i] != null : state.values[i] == null || !this.values[i].equals(state.values[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public final TLCState bind(UniqueString name, IValue value) {
        int loc = name.getVarLoc();
        this.values[loc] = value;
        return this;
    }

    @Override
    public final TLCState bind(SymbolNode id, IValue value) {
        throw new WrongInvocationException("TLCStateMut.bind: This is a TLC bug.");
    }

    @Override
    public final TLCState unbind(UniqueString name) {
        int loc = name.getVarLoc();
        this.values[loc] = null;
        return this;
    }

    @Override
    public final IValue lookup(UniqueString var) {
        int loc = var.getVarLoc();
        if (loc < 0) {
            return null;
        }
        return this.values[loc];
    }

    @Override
    public final boolean containsKey(UniqueString var) {
        return this.lookup(var) != null;
    }

    @Override
    public final TLCState copy() {
        int len = this.values.length;
        IValue[] vals = new IValue[len];
        System.arraycopy(this.values, 0, vals, 0, len);
        return this.copyExt(new TLCStateMutExt(vals));
    }

    @Override
    public final TLCState deepCopy() {
        int len = this.values.length;
        IValue[] vals = new IValue[len];
        int i = 0;
        while (i < len) {
            IValue val = this.values[i];
            if (val != null) {
                vals[i] = val.deepCopy();
            }
            ++i;
        }
        return this.deepCopy(new TLCStateMutExt(vals));
    }

    @Override
    public final StateVec addToVec(StateVec states) {
        return states.addElement(this.copy());
    }

    @Override
    public final void deepNormalize() {
        int i = 0;
        while (i < this.values.length) {
            IValue val = this.values[i];
            if (val != null) {
                val.deepNormalize();
            }
            ++i;
        }
    }

    @Override
    public final long fingerPrint() {
        return this.fingerPrint(mytool);
    }

    @Override
    public final long fingerPrint(ITool tool) {
        int i;
        int sz = this.values.length;
        IValue[] minVals = this.values;
        if (perms != null) {
            IValue[] vals = new IValue[sz];
            int i2 = 0;
            while (i2 < perms.length) {
                block14: {
                    int cmp = 0;
                    int j = 0;
                    while (j < sz) {
                        vals[j] = this.values[j].permute(perms[i2]);
                        if (cmp != 0 || (cmp = vals[j].compareTo(minVals[j])) <= 0) {
                            ++j;
                            continue;
                        }
                        break block14;
                    }
                    if (cmp < 0) {
                        if (minVals == this.values) {
                            minVals = vals;
                            vals = new IValue[sz];
                        } else {
                            IValue[] temp = minVals;
                            minVals = vals;
                            vals = temp;
                        }
                    }
                }
                ++i2;
            }
        }
        long fp = FP64.New();
        if (viewMap == null) {
            i = 0;
            while (i < sz) {
                fp = minVals[i].fingerPrint(fp);
                ++i;
            }
            if (this.values != minVals) {
                i = 0;
                while (i < sz) {
                    this.values[i].deepNormalize();
                    ++i;
                }
            }
        } else {
            i = 0;
            while (i < sz) {
                this.values[i].deepNormalize();
                ++i;
            }
            TLCStateMutExt state = this;
            if (minVals != this.values) {
                state = new TLCStateMutExt(minVals);
            }
            IValue val = tool.eval(viewMap, Context.Empty, state);
            fp = val.fingerPrint(fp);
        }
        return fp;
    }

    @Override
    public final boolean allAssigned() {
        int len = this.values.length;
        int i = 0;
        while (i < len) {
            if (this.values[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean noneAssigned() {
        int len = this.values.length;
        int i = 0;
        while (i < len) {
            if (this.values[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final Set<OpDeclNode> getUnassigned() {
        TreeSet<OpDeclNode> unassignedVars = new TreeSet<OpDeclNode>(new Comparator<OpDeclNode>(){

            @Override
            public int compare(OpDeclNode o1, OpDeclNode o2) {
                return o1.getName().toString().compareTo(o2.getName().toString());
            }
        });
        int len = this.values.length;
        int i = 0;
        while (i < len) {
            if (this.values[i] == null) {
                unassignedVars.add(vars[i]);
            }
            ++i;
        }
        return unassignedVars;
    }

    @Override
    public final void read(IValueInputStream vis) throws IOException {
        super.read(vis);
        int len = this.values.length;
        int i = 0;
        while (i < len) {
            this.values[i] = vis.read();
            ++i;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        super.write(vos);
        int len = this.values.length;
        int i = 0;
        while (i < len) {
            this.values[i].write(vos);
            ++i;
        }
    }

    @Override
    public final String toString() {
        if (TLCGlobals.useView && viewMap != null) {
            IValue val = mytool.eval(viewMap, Context.Empty, this);
            return viewMap.toString(val);
        }
        StringBuffer result = new StringBuffer();
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            IValue val = this.lookup(key);
            result.append(key.toString());
            result.append(" = ");
            result.append(Values.ppr(val));
            result.append("\n");
        } else {
            int i = 0;
            while (i < vlen) {
                UniqueString key = vars[i].getName();
                IValue val = this.lookup(key);
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = ");
                result.append(Values.ppr(val));
                result.append("\n");
                ++i;
            }
        }
        return result.toString();
    }

    @Override
    public final String toString(TLCState lastState) {
        return this.toString((UniqueString[])Arrays.stream(vars).map(o -> o.getName()).collect(Collectors.toList()).toArray(UniqueString[]::new), lastState);
    }

    @Override
    public final String toString(UniqueString[] vars, TLCState lastState) {
        StringBuffer result = new StringBuffer();
        TLCStateMutExt lstate = (TLCStateMutExt)lastState;
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0];
            IValue val = this.lookup(key);
            IValue lstateVal = lstate.lookup(key);
            if (!lstateVal.equals(val)) {
                result.append(key.toString());
                result.append(" = " + Values.ppr(val) + "\n");
            }
        } else {
            int i = 0;
            while (i < vlen) {
                UniqueString key = vars[i];
                IValue val = this.lookup(key);
                IValue lstateVal = lstate.lookup(key);
                if (!lstateVal.equals(val)) {
                    result.append("/\\ ");
                    result.append(key.toString());
                    result.append(" = " + Values.ppr(val) + "\n");
                }
                ++i;
            }
        }
        return result.toString();
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public TLCState setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public TLCState setPredecessor(TLCState predecessor) {
        this.predecessor = predecessor;
        return super.setPredecessor(predecessor);
    }

    @Override
    public TLCState getPredecessor() {
        return this.predecessor;
    }

    @Override
    public TLCState unsetPredecessor() {
        this.predecessor = null;
        return this;
    }

    @Override
    protected TLCState deepCopy(TLCState copy) {
        super.deepCopy(copy);
        return this.copyExt(copy);
    }

    private TLCState copyExt(TLCState copy) {
        if (this.predecessor != null) {
            copy.setPredecessor(this.predecessor);
        }
        return copy.setAction(this.getAction());
    }

    @Override
    public Object execCallable() throws Exception {
        if (this.callable != null) {
            return this.callable.call();
        }
        return null;
    }

    @Override
    public void setCallable(Callable<?> f) {
        this.callable = f;
    }

    @Override
    public Value getCached(int key) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(key);
    }

    @Override
    public Value setCached(int key, Value value) {
        if (this.cache == null) {
            this.cache = new HashMap<Integer, Value>(0);
        }
        this.cache.put(key, value);
        return value;
    }

    @Override
    public TLCState evalStateLevelAlias() {
        return mytool.evalAlias(this, TLCState.Empty);
    }
}

