/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class SetOfLong {
    private int count;
    private int length;
    private int thresh;
    private long[] table;
    private boolean hasZero;

    public SetOfLong(int size) {
        this.table = new long[size];
        this.count = 0;
        this.length = size;
        this.thresh = this.length / 2;
        this.hasZero = false;
    }

    public SetOfLong(int size, float ignore) {
        this(size);
    }

    private final void grow() {
        long[] old = this.table;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.table = new long[this.length];
        int i = 0;
        while (i < old.length) {
            long k = old[i];
            if (k != 0L) {
                this.put(k);
            }
            ++i;
        }
    }

    public final boolean put(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        if (k == 0L) {
            if (this.hasZero) {
                return true;
            }
            this.hasZero = true;
            ++this.count;
            return false;
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        long ent;
        while ((ent = this.table[loc]) != k) {
            if (ent == 0L) {
                this.table[loc] = k;
                ++this.count;
                return false;
            }
            loc = (loc + 1) % this.length;
        }
        return true;
    }

    public final boolean contains(long k) {
        if (k == 0L) {
            return this.hasZero;
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        long ent;
        while ((ent = this.table[loc]) != k) {
            if (ent == 0L) {
                return false;
            }
            loc = (loc + 1) % this.length;
        }
        return true;
    }

    public final int size() {
        return this.count;
    }

    public final long sizeof() {
        return 20 + 8 * this.length;
    }

    public final long checkFPs() {
        int cnt = 0;
        int i = 0;
        while (i < this.length) {
            long x = this.table[i];
            if (x != 0L) {
                this.table[cnt++] = this.table[i];
            }
            ++i;
        }
        Arrays.sort(this.table, 0, cnt);
        long dis = Long.MAX_VALUE;
        long x = 0L;
        int i2 = 0;
        if (!this.hasZero && cnt > 0) {
            x = this.table[0];
            i2 = 1;
        }
        while (i2 < cnt) {
            dis = Math.min(dis, this.table[i2] - x);
            x = this.table[i2];
            ++i2;
        }
        return dis;
    }

    public final void beginChkpt(DataOutputStream dos) throws IOException {
        dos.writeInt(this.count);
        dos.writeInt(this.length);
        dos.writeInt(this.thresh);
        dos.writeBoolean(this.hasZero);
        int i = 0;
        while (i < this.length) {
            long k = this.table[i];
            if (k != 0L) {
                dos.writeLong(k);
            }
            ++i;
        }
    }

    public final void recover(DataInputStream dis) throws IOException {
        this.count = dis.readInt();
        this.length = dis.readInt();
        this.thresh = dis.readInt();
        this.hasZero = dis.readBoolean();
        this.table = new long[this.length];
        int num = this.hasZero ? this.count - 1 : this.count;
        int i = 0;
        while (i < num) {
            this.put(dis.readLong());
            ++i;
        }
    }
}

