/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IFcnRcdValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueInputStream;
import tlc2.value.Values;
import tlc2.value.impl.FunctionValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.ToolIO;
import util.UniqueString;

public class FcnRcdValue
extends Value
implements FunctionValue,
IFcnRcdValue {
    private static final int LINEAR_SEARCH_THRESHOLD = Integer.getInteger(FcnRcdValue.class.getName() + ".threshold", 32);
    public final Value[] domain;
    public final IntervalValue intv;
    public final Value[] values;
    private boolean isNorm;
    public static final Value EmptyFcn;

    static {
        if (LINEAR_SEARCH_THRESHOLD != 32) {
            ToolIO.out.println("FcnRcdValue#threshold is: " + LINEAR_SEARCH_THRESHOLD);
        }
        EmptyFcn = new FcnRcdValue(new Value[0], new Value[0], true);
    }

    public FcnRcdValue(Value[] domain, Value[] values, boolean isNorm) {
        this.domain = domain;
        this.values = values;
        this.intv = null;
        this.isNorm = isNorm;
    }

    public FcnRcdValue(IntervalValue intv, Value[] values) {
        this.intv = intv;
        this.values = values;
        this.domain = null;
        this.isNorm = true;
    }

    public FcnRcdValue(IntervalValue intv, Value[] values, CostModel cm) {
        this(intv, values);
        this.cm = cm;
    }

    private FcnRcdValue(FcnRcdValue fcn, Value[] values) {
        this.domain = fcn.domain;
        this.intv = fcn.intv;
        this.values = values;
        this.isNorm = fcn.isNorm;
    }

    public FcnRcdValue(ValueVec elems, Value[] values, boolean isNorm) {
        this(elems.toArray(), values, isNorm);
    }

    public FcnRcdValue(ValueVec elems, Value[] values, boolean isNorm, CostModel cm) {
        this(elems, values, isNorm);
        this.cm = cm;
    }

    public FcnRcdValue(Value[] domain, Value[] values, boolean isNorm, CostModel cm) {
        this(domain, values, isNorm);
        this.cm = cm;
    }

    public FcnRcdValue(List<Value> vals) {
        this(new IntervalValue(1, vals.size()), (Value[])vals.toArray(Value[]::new));
    }

    public FcnRcdValue(Map<Value, Value> pairs) {
        this(pairs, false);
    }

    public FcnRcdValue(Map<Value, Value> pairs, boolean isNorm) {
        this((Value[])pairs.keySet().toArray(Value[]::new), (Value[])pairs.values().toArray(Value[]::new), isNorm);
    }

    @Override
    public final byte getKind() {
        return 9;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            FcnRcdValue fcn;
            FcnRcdValue fcnRcdValue = fcn = obj instanceof Value ? (FcnRcdValue)((Value)obj).toFcnRcd() : null;
            if (fcn == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueCompareTo(this);
                }
                Assert.fail("Attempted to compare the function " + Values.ppr(this.toString()) + " with the value:\n" + Values.ppr(obj.toString()), this.getSource());
            }
            this.normalize();
            fcn.normalize();
            int result = this.values.length - fcn.values.length;
            if (result != 0) {
                return result;
            }
            if (this.intv != null) {
                return this.compareToInterval(fcn);
            }
            return this.compareOtherInterval(fcn);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final int compareOtherInterval(FcnRcdValue fcn) {
        if (fcn.intv != null) {
            int result;
            int i = 0;
            while (i < this.domain.length) {
                Value dElem = this.domain[i];
                if (!(dElem instanceof IntValue)) {
                    Assert.fail("Attempted to compare integer with non-integer\n" + Values.ppr(dElem.toString()) + ".", this.getSource());
                }
                if ((result = ((IntValue)dElem).val - (fcn.intv.low + i)) != 0) {
                    return result;
                }
                ++i;
            }
            i = 0;
            while (i < this.domain.length) {
                result = this.values[i].compareTo(fcn.values[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        } else {
            int result;
            int i = 0;
            while (i < this.domain.length) {
                result = this.domain[i].compareTo(fcn.domain[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            i = 0;
            while (i < this.domain.length) {
                result = this.values[i].compareTo(fcn.values[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        }
        return 0;
    }

    private final int compareToInterval(FcnRcdValue fcn) {
        if (fcn.intv != null) {
            int result = this.intv.low - fcn.intv.low;
            if (result != 0) {
                return result;
            }
            int i = 0;
            while (i < this.values.length) {
                result = this.values[i].compareTo(fcn.values[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        } else {
            int result;
            int i = 0;
            while (i < fcn.domain.length) {
                Value dElem = fcn.domain[i];
                if (!(dElem instanceof IntValue)) {
                    Assert.fail("Attempted to compare integer with non-integer:\n" + Values.ppr(dElem.toString()) + ".", this.getSource());
                }
                if ((result = this.intv.low + i - ((IntValue)dElem).val) != 0) {
                    return result;
                }
                ++i;
            }
            i = 0;
            while (i < fcn.domain.length) {
                result = this.values[i].compareTo(fcn.values[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final boolean equals(Object obj) {
        try {
            FcnRcdValue fcn;
            FcnRcdValue fcnRcdValue = fcn = obj instanceof Value ? (FcnRcdValue)((Value)obj).toFcnRcd() : null;
            if (fcn == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueEquals(this);
                }
                Assert.fail("Attempted to check equality of the function " + Values.ppr(this.toString()) + " with the value:\n" + Values.ppr(obj.toString()), this.getSource());
            }
            this.normalize();
            fcn.normalize();
            if (this.intv != null) {
                if (fcn.intv != null) {
                    if (!this.intv.equals(fcn.intv)) {
                        return false;
                    }
                    int i = 0;
                    while (i < this.values.length) {
                        if (!this.values[i].equals(fcn.values[i])) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    if (fcn.domain.length != this.intv.size()) {
                        return false;
                    }
                    int i = 0;
                    while (i < fcn.domain.length) {
                        Value dElem = fcn.domain[i];
                        if (!(dElem instanceof IntValue)) {
                            Assert.fail("Attempted to compare an integer with non-integer:\n" + Values.ppr(dElem.toString()) + ".", this.getSource());
                        }
                        if (((IntValue)dElem).val != this.intv.low + i) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < fcn.values.length) {
                        if (!this.values[i].equals(fcn.values[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
            } else {
                if (this.values.length != fcn.values.length) {
                    return false;
                }
                if (fcn.intv != null) {
                    int i = 0;
                    while (i < this.domain.length) {
                        Value dElem = this.domain[i];
                        if (!(dElem instanceof IntValue)) {
                            Assert.fail("Attempted to compare an integer with non-integer:\n" + Values.ppr(dElem.toString()) + ".", this.getSource());
                        }
                        if (((IntValue)dElem).val != fcn.intv.low + i) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.values.length) {
                        if (!this.values[i].equals(fcn.values[i])) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.domain.length) {
                        if (!this.domain[i].equals(fcn.domain[i])) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.values.length) {
                        if (!this.values[i].equals(fcn.values[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the function " + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            Value result = this.select(arg);
            if (result == null) {
                Assert.fail("Attempted to apply function:\n" + Values.ppr(this.toString()) + "\nto argument " + Values.ppr(arg.toString()) + ", which is not in the domain of the function.", this.getSource());
            }
            return result;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        block6: {
            int idx;
            if (this.intv == null) break block6;
            if (!(arg instanceof IntValue)) {
                Assert.fail("Attempted to apply function with integer domain to the non-integer argument " + Values.ppr(arg.toString()), this.getSource());
            }
            if ((idx = ((IntValue)arg).val) >= this.intv.low && idx <= this.intv.high) {
                return this.values[idx - this.intv.low];
            }
            return null;
        }
        try {
            return this.selectBinarySearch(arg);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final Value selectLinearSearch(Value arg) {
        int len = this.domain.length;
        int i = 0;
        while (i < len) {
            if (this.domain[i].equals(arg)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    final Value selectBinarySearch(Value arg) {
        if (this.isNorm && this.domain.length >= LINEAR_SEARCH_THRESHOLD) {
            int idx = Arrays.binarySearch(this.domain, arg, IValue::compareTo);
            if (idx >= 0 && this.domain[idx].equals(arg)) {
                return this.values[idx];
            }
            return null;
        }
        return this.selectLinearSearch(arg);
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx >= ex.path.length) {
                return ex.value;
            }
            int flen = this.values.length;
            Value[] newValues = new Value[flen];
            int i = 0;
            while (i < flen) {
                newValues[i] = this.values[i];
                ++i;
            }
            Value arg = ex.path[ex.idx];
            if (this.intv != null) {
                if (arg instanceof IntValue) {
                    int idx = ((IntValue)arg).val;
                    if (idx >= this.intv.low && idx <= this.intv.high) {
                        int vidx = idx - this.intv.low;
                        ++ex.idx;
                        newValues[vidx] = this.values[vidx].takeExcept(ex);
                    }
                    return new FcnRcdValue(this.intv, newValues);
                }
            } else {
                int i2 = 0;
                while (i2 < flen) {
                    if (arg.equals(this.domain[i2])) {
                        ++ex.idx;
                        newValues[i2] = newValues[i2].takeExcept(ex);
                        Value[] newDomain = this.domain;
                        if (!this.isNorm) {
                            newDomain = new Value[flen];
                            int j = 0;
                            while (j < flen) {
                                newDomain[j] = this.domain[j];
                                ++j;
                            }
                        }
                        return new FcnRcdValue(newDomain, newValues, this.isNorm);
                    }
                    ++i2;
                }
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Value res = this;
            int i = 0;
            while (i < exs.length) {
                res = ((Value)res).takeExcept(exs[i]);
                ++i;
            }
            return res;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            if (this.intv != null) {
                return this.intv;
            }
            this.normalize();
            return new SetEnumValue(this.domain, true);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final Value[] getDomainAsValues() {
        if (this.intv != null) {
            return this.intv.asValues();
        }
        return this.domain;
    }

    @Override
    public final int size() {
        try {
            this.normalize();
            return this.values.length;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public int nonNormalizedSize() {
        return this.values.length;
    }

    @Override
    public final Value toTuple() {
        if (this.intv != null) {
            if (this.intv.low != 1) {
                return null;
            }
            return new TupleValue(this.values);
        }
        int len = this.values.length;
        Value[] elems = new Value[len];
        int i = 0;
        while (i < len) {
            if (!(this.domain[i] instanceof IntValue)) {
                return null;
            }
            int idx = ((IntValue)this.domain[i]).val;
            if (idx > 0 && idx <= len) {
                if (elems[idx - 1] != null) {
                    return null;
                }
            } else {
                return null;
            }
            elems[idx - 1] = this.values[i];
            ++i;
        }
        if (coverage) {
            this.cm.incSecondary(elems.length);
        }
        return new TupleValue(elems, this.cm);
    }

    @Override
    public final Value toRcd() {
        if (this.domain == null) {
            return null;
        }
        this.normalize();
        UniqueString[] vars = new UniqueString[this.domain.length];
        int i = 0;
        while (i < this.domain.length) {
            if (!(this.domain[i] instanceof StringValue)) {
                return null;
            }
            vars[i] = ((StringValue)this.domain[i]).getVal();
            ++i;
        }
        if (coverage) {
            this.cm.incSecondary(this.values.length);
        }
        return new RecordValue(vars, this.values, this.isNormalized(), this.cm);
    }

    @Override
    public TLCState toState() {
        Value rcd = this.toRcd();
        if (rcd != null) {
            return rcd.toState();
        }
        return super.toState();
    }

    @Override
    public final Value toFcnRcd() {
        return this;
    }

    @Override
    public final boolean isNormalized() {
        return this.isNorm;
    }

    @Override
    public final Value normalize() {
        try {
            if (!this.isNorm) {
                int dlen = this.domain.length;
                int i = 1;
                while (i < dlen) {
                    int cmp = this.domain[0].compareTo(this.domain[i]);
                    if (cmp == 0) {
                        Assert.fail("The value\n" + String.valueOf(this.domain[i]) + "\noccurs multiple times in the function domain.", this.getSource());
                    } else if (cmp > 0) {
                        Value tv = this.domain[0];
                        this.domain[0] = this.domain[i];
                        this.domain[i] = tv;
                        tv = this.values[0];
                        this.values[0] = this.values[i];
                        this.values[i] = tv;
                    }
                    ++i;
                }
                i = 2;
                while (i < dlen) {
                    int cmp;
                    Value d = this.domain[i];
                    Value v = this.values[i];
                    int j = i;
                    while ((cmp = d.compareTo(this.domain[j - 1])) < 0) {
                        this.domain[j] = this.domain[j - 1];
                        this.values[j] = this.values[j - 1];
                        --j;
                    }
                    if (cmp == 0) {
                        Assert.fail("The value\n" + String.valueOf(this.domain[i]) + "\noccurs multiple times in the function domain.", this.getSource());
                    }
                    this.domain[j] = d;
                    this.values[j] = v;
                    ++i;
                }
                this.isNorm = true;
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            int i = 0;
            while (i < this.values.length) {
                this.values[i].deepNormalize();
                ++i;
            }
            this.normalize();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            int i;
            boolean defined = true;
            if (this.intv == null) {
                i = 0;
                while (i < this.values.length) {
                    defined = defined && this.domain[i].isDefined();
                    ++i;
                }
            }
            i = 0;
            while (i < this.values.length) {
                defined = defined && this.values[i].isDefined();
                ++i;
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        try {
            Value[] vals = new Value[this.values.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = (Value)this.values[i].deepCopy();
                ++i;
            }
            if (this.intv == null) {
                return new FcnRcdValue(Arrays.copyOf(this.domain, this.domain.length), vals, false);
            }
            return new FcnRcdValue(this, vals);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        int index = vos.put(this);
        if (index == -1) {
            vos.writeByte((byte)9);
            int len = this.values.length;
            vos.writeNat(len);
            if (this.intv != null) {
                vos.writeByte((byte)0);
                vos.writeInt(this.intv.low);
                vos.writeInt(this.intv.high);
                int i = 0;
                while (i < len) {
                    this.values[i].write(vos);
                    ++i;
                }
            } else {
                vos.writeByte(this.isNormalized() ? (byte)1 : 2);
                int i = 0;
                while (i < len) {
                    this.domain[i].write(vos);
                    this.values[i].write(vos);
                    ++i;
                }
            }
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.normalize();
            int flen = this.values.length;
            fp = FP64.Extend(fp, (byte)9);
            fp = FP64.Extend(fp, flen);
            if (this.intv == null) {
                int i = 0;
                while (i < flen) {
                    fp = this.domain[i].fingerPrint(fp);
                    fp = this.values[i].fingerPrint(fp);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < flen) {
                    fp = FP64.Extend(fp, (byte)1);
                    fp = FP64.Extend(fp, i + this.intv.low);
                    fp = this.values[i].fingerPrint(fp);
                    ++i;
                }
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.normalize();
            int flen = this.size();
            Value[] vals = new Value[flen];
            boolean vchanged = false;
            int i = 0;
            while (i < flen) {
                vals[i] = (Value)this.values[i].permute(perm);
                vchanged = vchanged || vals[i] != this.values[i];
                ++i;
            }
            if (this.intv == null) {
                Value[] dom = new Value[flen];
                boolean dchanged = false;
                int i2 = 0;
                while (i2 < flen) {
                    dom[i2] = (Value)this.domain[i2].permute(perm);
                    dchanged = dchanged || dom[i2] != this.domain[i2];
                    ++i2;
                }
                if (dchanged) {
                    return new FcnRcdValue(dom, vals, false);
                }
                if (vchanged) {
                    return new FcnRcdValue(this.domain, vals, true);
                }
            } else if (vchanged) {
                return new FcnRcdValue(this.intv, vals);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private static final boolean isName(String name) {
        int len = name.length();
        boolean hasLetter = false;
        int idx = 0;
        while (idx < len) {
            char ch = name.charAt(idx);
            if (ch != '_') {
                if (!Character.isLetterOrDigit(ch)) {
                    return false;
                }
                hasLetter = hasLetter || Character.isLetter(ch);
            }
            ++idx;
        }
        return hasLetter && (len < 4 || !name.startsWith("WF_") && !name.startsWith("SF_"));
    }

    private final boolean isRcd() {
        if (this.intv != null) {
            return false;
        }
        int i = 0;
        while (i < this.domain.length) {
            boolean isName;
            Value dval = this.domain[i];
            boolean bl = isName = dval instanceof StringValue && FcnRcdValue.isName(((StringValue)dval).val.toString());
            if (!isName) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final boolean isTuple() {
        if (this.intv != null) {
            return this.intv.low == 1;
        }
        int i = 0;
        while (i < this.domain.length) {
            if (!(this.domain[i] instanceof IntValue)) {
                return false;
            }
            ++i;
        }
        this.normalize();
        i = 0;
        while (i < this.domain.length) {
            if (((IntValue)this.domain[i]).val != i + 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            int len = this.values.length;
            if (len == 0) {
                sb.append("<<>>");
            } else if (this.isRcd()) {
                sb.append("[");
                sb.append(String.valueOf(((StringValue)this.domain[0]).val) + " |-> ");
                sb = this.values[0].toString(sb, offset, swallow);
                int i = 1;
                while (i < len) {
                    sb.append(", ");
                    sb.append(String.valueOf(((StringValue)this.domain[i]).val) + " |-> ");
                    sb = this.values[i].toString(sb, offset, swallow);
                    ++i;
                }
                sb.append("]");
            } else if (this.isTuple()) {
                sb = sb.append("<<");
                sb = this.values[0].toString(sb, offset, swallow);
                int i = 1;
                while (i < len) {
                    sb.append(", ");
                    sb = this.values[i].toString(sb, offset, swallow);
                    ++i;
                }
                sb.append(">>");
            } else {
                Value[] domainAsValues = this.getDomainAsValues();
                sb = sb.append("(");
                sb = domainAsValues[0].toString(sb, offset, swallow);
                sb.append(" :> ");
                sb = this.values[0].toString(sb, offset, swallow);
                int i = 1;
                while (i < len) {
                    sb.append(" @@ ");
                    sb = domainAsValues[i].toString(sb, offset, swallow);
                    sb.append(" :> ");
                    sb = this.values[i].toString(sb, offset, swallow);
                    ++i;
                }
                sb.append(")");
            }
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static IValue createFrom(IValueInputStream vos) throws IOException {
        FcnRcdValue res;
        int index = vos.getIndex();
        int len = vos.readNat();
        byte info = vos.readByte();
        Value[] rvals = new Value[len];
        if (info == 0) {
            int low = vos.readInt();
            int high = vos.readInt();
            int i = 0;
            while (i < len) {
                rvals[i] = (Value)vos.read();
                ++i;
            }
            IntervalValue intv = new IntervalValue(low, high);
            res = new FcnRcdValue(intv, rvals);
        } else {
            Value[] dvals = new Value[len];
            int i = 0;
            while (i < len) {
                dvals[i] = (Value)vos.read();
                rvals[i] = (Value)vos.read();
                ++i;
            }
            res = new FcnRcdValue(dvals, rvals, info == 1);
        }
        vos.assign(res, index);
        return res;
    }

    public static IValue createFromExternal(ValueInputStream vos) throws IOException {
        FcnRcdValue res;
        int index = vos.getIndex();
        int len = vos.readNat();
        byte info = vos.readByte();
        Value[] rvals = new Value[len];
        if (info == 0) {
            int low = vos.readInt();
            int high = vos.readInt();
            int i = 0;
            while (i < len) {
                rvals[i] = (Value)vos.readExternal();
                ++i;
            }
            IntervalValue intv = new IntervalValue(low, high);
            res = new FcnRcdValue(intv, rvals);
        } else {
            Value[] dvals = new Value[len];
            int i = 0;
            while (i < len) {
                dvals[i] = (Value)vos.readExternal();
                rvals[i] = (Value)vos.readExternal();
                ++i;
            }
            res = new FcnRcdValue(dvals, rvals, info == 1);
        }
        vos.assign(res, index);
        return res;
    }

    @Override
    public List<TLCVariable> getTLCVariables(TLCVariable prototype, Random rnd) {
        ArrayList<TLCVariable> nestedVars = new ArrayList<TLCVariable>(this.values.length);
        Value[] domains = this.getDomainAsValues();
        int i = 0;
        while (i < domains.length) {
            Value dom = domains[i];
            Value value = this.values[i];
            TLCVariable nested = prototype.newInstance(dom.toString(), value, rnd);
            nested.setValue(value.toString());
            nested.setType(value.getTypeString());
            nestedVars.add(nested);
            ++i;
        }
        return nestedVars;
    }
}

