/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.tla;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import util.UniqueString;

public class TokenSpec {
    public String token;
    public int leftPos;
    public int rightPos;
    public SymbolNode resolvedSymbol = null;
    private static final char PaddingChar = '\u0000';
    private static final String Padding = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final String[] Operators = new String[]{"-+->", "<=>", "...", "::=", "(+)", "(-)", "(.)", "(/)", "(\\X)", "--", "**", "++", "<:", "<=", "<", ">=", "..", "||", "[]", "<>", "/\\", "\\/", "//", "/", "/=", "~>", "=>", "=<", "=|", "^^", "##", "|-", "|=", "&&", "$$", "??", "%%", "@@", "!!", ":>", ":=", "~", "=", "#", "^", "-", "*", ">", "<", "+", "|", "&", "$", "%", "\\"};
    private static final String[] XOperators = new String[]{"(\\X)"};
    private static final String[] TeXSymbols = new String[]{"\\neg", "\\lnot", "\\approx", "\\asymp", "\\bigcirc", "\\bullet", "\\cap", "\\cdot", "\\circ", "\\cong", "\\cup", "\\div", "\\doteq", "\\equiv", "\\geq", "\\gg", "\\in", "\\intersect", "\\union", "\\land", "\\leq", "\\ll", "\\lor", "\\mod", "\\o", "\\odot", "\\ominus", "\\oplus", "\\oslash", "\\otimes", "\\prec", "\\preceq", "\\propto", "\\sim", "\\simeq", "\\sqcap", "\\sqcup", "\\sqsubset", "\\sqsupset", "\\sqsubseteq", "\\sqsupseteq", "\\star", "\\subset", "\\subseteq", "\\succ", "\\succeq", "\\supset", "\\supseteq", "\\uplus", "\\wr", "\\notin", "\\times", "\\X"};
    private static final String[] NonOperators = new String[]{"==", "---", "->", "<-", "***", "<<", ">>"};
    private static String[] RightDelimiters = new String[]{")", "]", "}", ">>"};
    private static String[] LeftDelimiters = new String[]{"(", "[", "{", "<<"};

    public TokenSpec(String tok, int left, int right) {
        this.token = tok;
        this.leftPos = left;
        this.rightPos = right;
    }

    public static TokenSpec findCurrentTokenSpec() {
        return TokenSpec.findCurrentTokenSpec(null);
    }

    public static TokenSpec findCurrentTokenSpec(IRegion regionInput) {
        int currentPos;
        String currentLine;
        int offsetOfLine;
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null) {
            return null;
        }
        String moduleName = editor.getModuleName();
        if (moduleName == null) {
            return null;
        }
        ModuleNode moduleNode = ResourceHelper.getModuleNode((String)moduleName);
        if (moduleNode == null) {
            return null;
        }
        ISourceViewer internalSourceViewer = editor.publicGetSourceViewer();
        IDocument document = internalSourceViewer.getDocument();
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IRegion region = regionInput;
        if (regionInput == null) {
            region = new Region(selection.getOffset(), selection.getLength());
        }
        try {
            int lineNumber = document.getLineOfOffset(region.getOffset());
            int lineDelimLength = 0;
            String delim = document.getLineDelimiter(lineNumber);
            if (delim != null) {
                lineDelimLength = delim.length();
            }
            offsetOfLine = document.getLineOffset(lineNumber);
            currentLine = document.get(offsetOfLine, document.getLineLength(lineNumber) - lineDelimLength);
            currentPos = region.getOffset() - offsetOfLine;
        }
        catch (BadLocationException e) {
            TLAEditorActivator.getDefault().logDebug("Exception thrown", e);
            return null;
        }
        TokenSpec[] tokenSpecs = TokenSpec.findTokenSpecs(currentLine, currentPos);
        int goodIndex = -1;
        SymbolNode symbol = null;
        int i = 0;
        while (i < tokenSpecs.length) {
            int leftPos = tokenSpecs[i].leftPos;
            int rightPos = tokenSpecs[i].rightPos;
            tokenSpecs[i].leftPos = leftPos + offsetOfLine;
            tokenSpecs[i].rightPos = rightPos + offsetOfLine;
            String indiceAdjustedToken = tokenSpecs[i].token;
            Location location = EditorUtil.getLocationAt(document, tokenSpecs[i].leftPos, rightPos - leftPos);
            if (indiceAdjustedToken != null && indiceAdjustedToken.length() > 1 && indiceAdjustedToken.charAt(0) == '_') {
                indiceAdjustedToken = indiceAdjustedToken.substring(1);
            }
            if ((symbol = EditorUtil.lookupOriginalSymbol(UniqueString.uniqueStringOf((String)indiceAdjustedToken), (SemanticNode)moduleNode, location, null)) != null) {
                goodIndex = i;
                break;
            }
            ++i;
        }
        if (goodIndex == -1) {
            if (tokenSpecs.length == 0) {
                return null;
            }
            goodIndex = 0;
        }
        TokenSpec result = new TokenSpec(tokenSpecs[goodIndex].token, tokenSpecs[goodIndex].leftPos, tokenSpecs[goodIndex].rightPos);
        result.resolvedSymbol = symbol;
        return result;
    }

    public static TokenSpec[] findTokenSpecs(String inputLine, int inputPosition) {
        TokenSpec currentToken;
        String line = Padding + inputLine + Padding;
        int curPos = inputPosition + Padding.length();
        TokenSpec[] foundTokenSpecs = new TokenSpec[]{};
        boolean lastToken = false;
        boolean notLastToken = false;
        if (line.charAt(curPos) == ' ') {
            if (line.charAt((curPos = TokenSpec.skipLeftOverSpaces(line, curPos)) - 1) == '!' && line.charAt(curPos - 2) != '!') {
                notLastToken = true;
                --curPos;
                curPos = TokenSpec.skipLeftOverSpaces(line, curPos);
            }
        } else if (line.charAt(curPos) == '!' && line.charAt(curPos - 1) != '!' && line.charAt(curPos + 1) != '!') {
            notLastToken = true;
            curPos = TokenSpec.skipLeftOverSpaces(line, curPos);
        }
        if ((notLastToken || line.charAt(curPos) == ' ') && line.charAt(curPos - 1) == ')') {
            notLastToken = true;
            int returnVal = TokenSpec.findMatchingLeftParen(line, curPos);
            if (returnVal < 0) {
                return new TokenSpec[0];
            }
            curPos = returnVal;
            curPos = TokenSpec.skipLeftOverSpaces(line, curPos);
        }
        if (notLastToken) {
            --curPos;
        } else if (!Character.isLetterOrDigit(line.charAt(curPos)) && line.charAt(curPos) != '_' && TokenSpec.findTokenIn(line, curPos, Operators) == null) {
            --curPos;
        }
        if (Character.isLetterOrDigit(line.charAt(curPos)) || line.charAt(curPos) == '_') {
            if (line.charAt(curPos) == 'X' && TokenSpec.findTokenIn(line, curPos, XOperators) != null) {
                TokenSpec returnVal = TokenSpec.findTokenIn(line, curPos, XOperators);
                foundTokenSpecs = new TokenSpec[]{returnVal};
                curPos = returnVal.leftPos;
                lastToken = true;
            } else {
                currentToken = TokenSpec.findMaximalIdCharSeq(line, curPos);
                if (currentToken == null) {
                    TLAEditorActivator.getDefault().getLog().log((IStatus)new Status(2, "org.lamport.tla.toolbox.editor.basic", "Hyperlinking failed for " + inputLine));
                    return new TokenSpec[0];
                }
                if (line.charAt(currentToken.leftPos - 1) == '>') {
                    TokenSpec returnVal = TokenSpec.findMaximalIdCharSeq(line, currentToken.leftPos - 1);
                    if ((returnVal = TokenSpec.checkIfStepName(line, returnVal, currentToken)) != null) {
                        return TokenSpec.FixOrigin(new TokenSpec[]{returnVal});
                    }
                }
                if (line.charAt(currentToken.rightPos) == '>') {
                    TokenSpec returnVal = TokenSpec.findMaximalIdCharSeq(line, currentToken.rightPos + 1);
                    if ((returnVal = TokenSpec.checkIfStepName(line, currentToken, returnVal)) != null) {
                        return TokenSpec.FixOrigin(new TokenSpec[]{returnVal});
                    }
                }
                if (TokenSpec.IsNumber(currentToken.token)) {
                    return new TokenSpec[0];
                }
                int left = currentToken.leftPos;
                int rt = currentToken.rightPos;
                if (line.charAt(left - 1) == '\\' && line.charAt(left - 2) != '\\' && TokenSpec.IsTeXSymbol(line.substring(left - 1, rt))) {
                    lastToken = true;
                    currentToken.leftPos = left - 1;
                    currentToken.token = line.substring(left - 1, rt);
                }
                foundTokenSpecs = new TokenSpec[]{currentToken};
                curPos = left;
            }
        } else {
            TokenSpec temp2;
            TokenSpec temp1;
            currentToken = TokenSpec.findTokenIn(line, curPos, Operators);
            if (currentToken == null) {
                return new TokenSpec[0];
            }
            TokenSpec returnVal = TokenSpec.findTokenIn(line, curPos, NonOperators);
            if (returnVal != null) {
                return new TokenSpec[0];
            }
            if (currentToken.token.equals("<") ? (temp1 = TokenSpec.findMaximalIdCharSeq(line, currentToken.rightPos)) != null && line.charAt(temp1.rightPos) == '>' && (returnVal = TokenSpec.checkIfStepName(line, temp1, temp2 = TokenSpec.findMaximalIdCharSeq(line, temp1.rightPos + 1))) != null : currentToken.token.equals(">") && (returnVal = TokenSpec.checkIfStepName(line, temp1 = TokenSpec.findMaximalIdCharSeq(line, currentToken.leftPos), temp2 = TokenSpec.findMaximalIdCharSeq(line, currentToken.rightPos))) != null) {
                return TokenSpec.FixOrigin(new TokenSpec[]{returnVal});
            }
            if (currentToken.token.equals("\\") && (returnVal = TokenSpec.findMaximalIdCharSeq(line, currentToken.rightPos)) != null && TokenSpec.IsTeXSymbol(line.substring(currentToken.leftPos, returnVal.rightPos))) {
                currentToken.rightPos = returnVal.rightPos;
                currentToken.token = line.substring(currentToken.leftPos, returnVal.rightPos);
            }
            foundTokenSpecs = new TokenSpec[]{currentToken};
            curPos = currentToken.leftPos;
            lastToken = true;
        }
        curPos = foundTokenSpecs[0].leftPos;
        boolean notDone = true;
        while (notDone) {
            if ((curPos = TokenSpec.skipLeftOverSpaces(line, curPos)) < 0 || line.charAt(curPos - 1) == '\u0000') {
                notDone = false;
                continue;
            }
            if (line.charAt(curPos - 1) == '!' && line.charAt(curPos - 2) != '!') {
                --curPos;
                curPos = TokenSpec.skipLeftOverSpaces(line, curPos);
                if ((curPos = TokenSpec.findMatchingLeftParen(line, curPos)) < 0) {
                    notDone = false;
                    continue;
                }
                currentToken = TokenSpec.findMaximalIdCharSeq(line, curPos = TokenSpec.skipLeftOverSpaces(line, curPos));
                if (currentToken == null || TokenSpec.IsNumber(currentToken.token)) {
                    notDone = false;
                    continue;
                }
                curPos = currentToken.leftPos;
                foundTokenSpecs[0] = new TokenSpec(currentToken.token + "!" + foundTokenSpecs[0].token, curPos, foundTokenSpecs[0].rightPos);
                continue;
            }
            notDone = false;
        }
        if (lastToken) {
            return TokenSpec.FixOrigin(foundTokenSpecs);
        }
        curPos = foundTokenSpecs[0].rightPos;
        boolean foundBangToken = false;
        notDone = true;
        while (notDone) {
            curPos = TokenSpec.skipRightOverSpaces(line, curPos);
            if ((curPos = TokenSpec.findMatchingRightParen(line, curPos)) < 0) {
                notDone = false;
                continue;
            }
            if (line.charAt(curPos = TokenSpec.skipRightOverSpaces(line, curPos)) != '!' || line.charAt(curPos + 1) == '!') {
                notDone = false;
                continue;
            }
            ++curPos;
            currentToken = TokenSpec.findMaximalIdCharSeq(line, curPos = TokenSpec.skipRightOverSpaces(line, curPos));
            if (currentToken == null || TokenSpec.IsNumber(currentToken.token)) {
                notDone = false;
                continue;
            }
            foundBangToken = true;
            TokenSpec[] temp = new TokenSpec[1 + foundTokenSpecs.length];
            temp[0] = new TokenSpec(foundTokenSpecs[0].token + "!" + currentToken.token, foundTokenSpecs[0].leftPos, currentToken.rightPos);
            int i = 0;
            while (i < foundTokenSpecs.length) {
                temp[i + 1] = foundTokenSpecs[i];
                ++i;
            }
            foundTokenSpecs = temp;
            curPos = currentToken.rightPos;
        }
        if (notLastToken && !foundBangToken) {
            return new TokenSpec[0];
        }
        return TokenSpec.FixOrigin(foundTokenSpecs);
    }

    private static TokenSpec findTokenIn(String line, int pos, String[] tokArray) {
        int i = 0;
        while (i < tokArray.length) {
            int tokIdx = tokArray[i].indexOf(line.charAt(pos), 0);
            while (tokIdx != -1) {
                int ftlft = pos - tokIdx;
                int ftrt = pos - tokIdx + tokArray[i].length();
                if (tokArray[i].equals(line.substring(ftlft, ftrt))) {
                    return new TokenSpec(tokArray[i], ftlft, ftrt);
                }
                tokIdx = tokArray[i].indexOf(line.charAt(pos), tokIdx + 1);
            }
            ++i;
        }
        return null;
    }

    private static TokenSpec findMaximalIdCharSeq(String line, int pos) {
        int left = pos;
        int rt = pos;
        left = pos;
        while (Character.isLetterOrDigit(line.charAt(left - 1)) || line.charAt(left - 1) == '_') {
            --left;
        }
        while (Character.isLetterOrDigit(line.charAt(rt)) || line.charAt(rt) == '_') {
            ++rt;
        }
        if (left == rt) {
            return null;
        }
        return new TokenSpec(line.substring(left, rt), left, rt);
    }

    private static TokenSpec checkIfStepName(String line, TokenSpec leftTok, TokenSpec rightTok) {
        if (leftTok == null || rightTok == null) {
            return null;
        }
        if (TokenSpec.IsNumber(leftTok.token) && line.charAt(leftTok.leftPos - 1) == '<' && line.charAt(leftTok.leftPos - 2) != '<') {
            return new TokenSpec(line.substring(leftTok.leftPos - 1, rightTok.rightPos), leftTok.leftPos - 1, rightTok.rightPos);
        }
        return null;
    }

    private static int findMatchingLeftParen(String line, int pos) {
        if (line.charAt(pos - 1) != ')') {
            return pos;
        }
        return TokenSpec.findMatchingLeftInner(line, pos, 0);
    }

    private static int findMatchingLeftInner(String line, int pos, int delim) {
        int ipos = pos;
        int delimLen = LeftDelimiters[delim].length();
        ipos = pos - delimLen;
        while (!line.substring(ipos - delimLen, ipos).equals(LeftDelimiters[delim])) {
            if (line.charAt(ipos - 1) == '\u0000') {
                return -1;
            }
            --ipos;
            int jdelim = 0;
            while (jdelim < LeftDelimiters.length) {
                if (line.substring(ipos - delimLen, ipos).equals(RightDelimiters[jdelim])) {
                    if ((ipos = TokenSpec.findMatchingLeftInner(line, ipos, jdelim)) < 0) {
                        return -1;
                    }
                    jdelim = 99999;
                }
                ++jdelim;
            }
        }
        return ipos - delimLen;
    }

    private static int findMatchingRightParen(String line, int pos) {
        if (line.charAt(pos) != '(') {
            return pos;
        }
        return TokenSpec.findMatchingRightInner(line, pos, 0);
    }

    private static int findMatchingRightInner(String line, int pos, int delim) {
        int ipos = pos;
        int delimLen = RightDelimiters[delim].length();
        ipos = pos + delimLen;
        while (!line.substring(ipos, ipos + delimLen).equals(RightDelimiters[delim])) {
            if (line.charAt(ipos) == '\u0000') {
                return -1;
            }
            ++ipos;
            int jdelim = 0;
            while (jdelim < RightDelimiters.length) {
                if (line.substring(ipos, ipos + delimLen).equals(LeftDelimiters[jdelim])) {
                    if ((ipos = TokenSpec.findMatchingRightInner(line, ipos, jdelim)) < 0) {
                        return -1;
                    }
                    jdelim = 99999;
                }
                ++jdelim;
            }
        }
        return ipos + delimLen;
    }

    private static int skipLeftOverSpaces(String line, int curPos) {
        int index = curPos;
        while (line.charAt(index - 1) == ' ') {
            --index;
        }
        return index;
    }

    private static int skipRightOverSpaces(String line, int curPos) {
        int index = curPos;
        while (line.charAt(index) == ' ') {
            ++index;
        }
        return index;
    }

    private static boolean IsNumber(String str) {
        if (str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static TokenSpec[] FixOrigin(TokenSpec[] tspec) {
        TokenSpec[] result = new TokenSpec[tspec.length];
        int i = 0;
        while (i < tspec.length) {
            result[i] = new TokenSpec(tspec[i].token, tspec[i].leftPos - Padding.length(), tspec[i].rightPos - Padding.length());
            ++i;
        }
        return result;
    }

    private static final boolean IsTeXSymbol(String str) {
        int i = 0;
        while (i < TeXSymbols.length) {
            if (str.equals(TeXSymbols[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String str = "[token |-> " + this.token + ", leftPos |-> " + this.leftPos + ", rightPos |-> " + this.rightPos + ", resolvedSymbol |-> ";
        if (this.resolvedSymbol == null) {
            return str + "null]";
        }
        return str + String.valueOf(this.resolvedSymbol.getName()) + "]";
    }
}

