/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.imageviewer;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public interface IGraphicalContentProvider
extends IContentProvider {
    public Image getImage();

    public void setSuggestedSize(Point var1);

    public Image loadImage(Display var1, Point var2, Object var3) throws CoreException;

    public void saveImage(Display var1, Point var2, Object var3, IPath var4, GraphicFileFormat var5) throws CoreException;

    default public Set<GraphicFileFormat> getSupportedFormats() {
        return EnumSet.of(GraphicFileFormat.BITMAP, GraphicFileFormat.GIF, GraphicFileFormat.TIFF, GraphicFileFormat.JPEG, GraphicFileFormat.PNG);
    }

    public static enum GraphicFileFormat {
        JPEG("jpg"),
        PNG("png"),
        GIF("gif"),
        TIFF("tif"),
        BITMAP("bmp"),
        SVG("svg"),
        DOT("dot");

        String extension;

        private GraphicFileFormat(String extension) {
            this.extension = extension;
        }

        public static GraphicFileFormat byExtension(String toMatch) {
            return Arrays.stream(GraphicFileFormat.values()).filter(it -> it.extension.equals(toMatch)).findAny().orElse(null);
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

