/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Container;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerUtil;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.InsertionOrderSplayTree;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Segment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SyntheticLV;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.VirtualEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AccumulatorTreeUtil;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Comparators;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.util.InsertionSortCounter;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiglspergerSteps<V, E> {
    private static final Logger log = LoggerFactory.getLogger(EiglspergerSteps.class);
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected NeighborCache<LV<V>, LE<V, E>> neighborCache;
    protected LV<V>[][] layersArray;
    protected Predicate<LV<V>> joinVertexPredicate;
    protected Predicate<LV<V>> splitVertexPredicate;
    protected Function<List<LE<V, E>>, List<LE<V, E>>> edgeEndpointSwapOrNot;
    protected Function<LV<V>, Set<LV<V>>> neighborFunction;
    protected Function<LE<V, E>, LV<V>> edgeSourceFunction;
    protected Function<LE<V, E>, LV<V>> edgeTargetFunction;
    protected boolean transpose;
    protected Graph<LV<V>, Integer> compactionGraph;
    protected Set<LE<V, E>> typeOneConflicts = new HashSet<LE<V, E>>();

    protected EiglspergerSteps(Graph<LV<V>, LE<V, E>> svGraph, LV<V>[][] layersArray, Predicate<LV<V>> joinVertexPredicate, Predicate<LV<V>> splitVertexPredicate, Function<LE<V, E>, LV<V>> edgeSourceFunction, Function<LE<V, E>, LV<V>> edgeTargetFunction, Function<LV<V>, Set<LV<V>>> neighborFunction, Function<List<LE<V, E>>, List<LE<V, E>>> edgeEndpointSwapOrNot, boolean transpose) {
        this.svGraph = svGraph;
        this.neighborCache = new NeighborCache<LV<LV<V>>, LE<LV<V>, LE<V, E>>>(svGraph);
        this.layersArray = layersArray;
        this.joinVertexPredicate = joinVertexPredicate;
        this.splitVertexPredicate = splitVertexPredicate;
        this.edgeSourceFunction = edgeSourceFunction;
        this.edgeTargetFunction = edgeTargetFunction;
        this.neighborFunction = neighborFunction;
        this.edgeEndpointSwapOrNot = edgeEndpointSwapOrNot;
        this.transpose = transpose;
    }

    private void log(String label, List<LV<V>> list) {
        log.info(label);
        list.forEach(v -> log.info(" - {}", (Object)v.toString()));
    }

    protected static <V, E> void clearGraph(Graph<V, E> graph) {
        HashSet<E> edges = new HashSet<E>(graph.edgeSet());
        HashSet<V> vertices = new HashSet<V>(graph.vertexSet());
        graph.removeAllEdges(edges);
        graph.removeAllVertices(vertices);
    }

    public Set<LE<V, E>> getTypeOneConflicts() {
        return this.typeOneConflicts;
    }

    private void log(String label, LV<V>[] array) {
        log.info(label);
        Arrays.stream(array).forEach(v -> log.info(" - {}", (Object)v.toString()));
    }

    public void stepOne(List<LV<V>> currentLayer) {
        if (log.isTraceEnabled()) {
            this.log("stepOne currentLayer in", currentLayer);
        }
        ArrayList outList = new ArrayList();
        for (LV<V> v : currentLayer) {
            if (this.joinVertexPredicate.test(v)) {
                if (outList.isEmpty()) {
                    outList.add(Container.createSubContainer());
                }
                Container lastContainer = (Container)outList.get(outList.size() - 1);
                SegmentVertex segmentVertex = (SegmentVertex)v;
                Segment segment = segmentVertex.getSegment();
                lastContainer.append(segment);
                continue;
            }
            outList.add(v);
        }
        List scannedList = EiglspergerUtil.scan(outList);
        currentLayer.clear();
        currentLayer.addAll(scannedList);
        IntStream.range(0, currentLayer.size()).forEach(i -> ((LV)currentLayer.get(i)).setIndex(i));
        if (log.isTraceEnabled()) {
            this.log("stepOne currentLayer out (merged pvertices into containers)", currentLayer);
        }
    }

    private static <V> void updateIndices(List<LV<V>> layer) {
        IntStream.range(0, layer.size()).forEach(i -> ((LV)layer.get(i)).setIndex(i));
    }

    public void stepTwo(List<LV<V>> currentLayer, List<LV<V>> downstreamLayer) {
        if (log.isTraceEnabled()) {
            this.log("stepTwo currentLayer in", currentLayer);
        }
        if (log.isTraceEnabled()) {
            this.log("stepTwo downstreamLayer in", downstreamLayer);
        }
        this.assignPositions(currentLayer);
        if (EiglspergerSteps.updatePositions(currentLayer)) {
            log.error("positions were off for {}", (Object)currentLayer);
        }
        List containersFromCurrentLayer = currentLayer.stream().filter(v -> v instanceof Container).map(v -> (Container)v).filter(c -> c.size() > 0).collect(Collectors.toList());
        containersFromCurrentLayer.stream().filter(c -> !downstreamLayer.contains(c)).forEach(downstreamLayer::add);
        this.assignMeasures(downstreamLayer);
        if (log.isTraceEnabled()) {
            this.log("stepTwo currentLayer out (computed pos for currentLayer)", currentLayer);
        }
        if (log.isTraceEnabled()) {
            this.log("stepTwo downstreamLayer out (computed measures for downstreamLayer)", downstreamLayer);
        }
    }

    public void stepThree(List<LV<V>> downstreamLayer) {
        if (log.isTraceEnabled()) {
            this.log("stepThree downstreamLayer in", downstreamLayer);
        }
        LinkedList<LV> listV = new LinkedList<LV>();
        LinkedList<Container> listS = new LinkedList<Container>();
        ArrayList<SegmentVertex> segmentVertexList = new ArrayList<SegmentVertex>();
        for (LV<V> lV : downstreamLayer) {
            if (this.splitVertexPredicate.test(lV)) {
                segmentVertexList.add((SegmentVertex)lV);
                continue;
            }
            if (lV instanceof Container) {
                Container container = (Container)lV;
                if (container.size() <= 0) continue;
                listS.add(container);
                continue;
            }
            listV.add(lV);
        }
        if (log.isTraceEnabled()) {
            log.trace("listS measures: {}", (Object)listS);
        }
        if (log.isTraceEnabled()) {
            log.trace("listV measures: {}", (Object)listV);
        }
        try {
            listS.sort(Comparator.comparingDouble(Container::getMeasure));
            listV.sort(Comparator.comparingDouble(LV::getMeasure));
            if (log.isTraceEnabled()) {
                StringBuilder sbuilder = new StringBuilder("S3 listS:\n");
                listS.forEach(s -> sbuilder.append(s.toString()).append("\n"));
                log.trace(sbuilder.toString());
                StringBuilder stringBuilder = new StringBuilder("S3 listV:\n");
                listV.forEach(v -> vbuilder.append(v.toString()).append("\n"));
                log.trace(stringBuilder.toString());
            }
        }
        catch (Exception ex) {
            log.error("listS: {}, listV: {} exception: {}", listS, listV, ex);
        }
        ArrayList<LV> mergedList = new ArrayList<LV>();
        if (listS.isEmpty() || listV.isEmpty()) {
            mergedList.addAll(listS);
            mergedList.addAll(listV);
            mergedList.sort(Comparator.comparingDouble(LV::getMeasure));
        } else {
            while (!listV.isEmpty() && !listS.isEmpty()) {
                if (((LV)listV.get(0)).getMeasure() <= (double)((Container)listS.get(0)).getPos()) {
                    LV lV = (LV)listV.remove(0);
                    mergedList.add(lV);
                    continue;
                }
                if (((LV)listV.get(0)).getMeasure() >= (double)(((Container)listS.get(0)).getPos() + ((Container)listS.get(0)).size() - 1)) {
                    Container container = (Container)listS.remove(0);
                    mergedList.add(container);
                    continue;
                }
                Container container = (Container)listS.remove(0);
                LV v3 = (LV)listV.remove(0);
                int k = (int)Math.ceil(v3.getMeasure() - (double)container.getPos());
                if (log.isTraceEnabled()) {
                    log.trace("will split {} at {}", (Object)container, (Object)k);
                }
                Pair containerPair = Container.split(container, k);
                if (log.isTraceEnabled()) {
                    log.trace("got {} and {}", containerPair.first, containerPair.second);
                }
                mergedList.add((LV)containerPair.first);
                mergedList.add(v3);
                int pos = container.getPos() + k;
                ((Container)containerPair.second).setPos(pos);
                listS.add(0, (Container)containerPair.second);
            }
            mergedList.addAll(listV);
            mergedList.addAll(listS);
        }
        mergedList.addAll(segmentVertexList);
        if (log.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("S3 mergedList:\n");
            mergedList.forEach(v -> builder.append(v.toString()).append("\n"));
            log.trace(stringBuilder.toString());
        }
        downstreamLayer.clear();
        downstreamLayer.addAll(mergedList);
        EiglspergerSteps.updateIndices(downstreamLayer);
        if (EiglspergerSteps.updatePositions(downstreamLayer)) {
            log.trace("positions were updated for {}", (Object)downstreamLayer);
        }
        if (log.isTraceEnabled()) {
            this.log("stepThree downstreamLayer out (initial ordering for downstreamLayer)", downstreamLayer);
        }
    }

    public void stepFour(List<LV<V>> downstreamLayer, int downstreamRank) {
        if (log.isTraceEnabled()) {
            this.log("stepFour downstreamLayer in", downstreamLayer);
        }
        List qVertices = downstreamLayer.stream().filter(v -> this.splitVertexPredicate.test((LV<V>)v)).map(v -> (SegmentVertex)v).collect(Collectors.toList());
        for (SegmentVertex q : qVertices) {
            List containerList = downstreamLayer.stream().filter(v -> v instanceof Container).map(v -> (Container)v).collect(Collectors.toList());
            Segment segment = q.getSegment();
            Optional<Container> containerOpt = containerList.stream().filter(c -> c.contains(segment)).findFirst();
            if (containerOpt.isPresent()) {
                Container container = containerOpt.get();
                int loserIdx = downstreamLayer.indexOf(container);
                if (log.isTraceEnabled()) {
                    log.trace("found container {} at index {} with list index {} for qVertex {} with index {} and list index {}", container, container.getIndex(), loserIdx, q, q.getIndex(), downstreamLayer.indexOf(q));
                    log.trace("splitting on {} because of {}", (Object)segment, (Object)q);
                }
                Pair containerPair = Container.split(container, segment);
                if (log.isTraceEnabled()) {
                    log.trace("splitFound container into {} and {}", containerPair.first, containerPair.second);
                    log.trace("container pair is now {} and {}", (Object)((Container)containerPair.first).printTree("\n"), (Object)((Container)containerPair.second).printTree("\n"));
                }
                downstreamLayer.remove(q);
                if (log.isTraceEnabled()) {
                    log.trace("removed container {}", (Object)container.printTree("\n"));
                    log.trace("adding container {}", (Object)((Container)containerPair.first).printTree("\n"));
                    log.trace("adding container {}", (Object)((Container)containerPair.second).printTree("\n"));
                }
                downstreamLayer.remove(container);
                downstreamLayer.add(loserIdx, (LV)containerPair.first);
                downstreamLayer.add(loserIdx + 1, q);
                downstreamLayer.add(loserIdx + 2, (LV)containerPair.second);
                continue;
            }
            log.error("container opt was empty for segment {}", (Object)segment);
        }
        EiglspergerSteps.updateIndices(downstreamLayer);
        EiglspergerSteps.updatePositions(downstreamLayer);
        Arrays.sort(this.layersArray[downstreamRank], Comparator.comparingInt(LV::getIndex));
        if (log.isTraceEnabled()) {
            this.log("stepFour downstreamLayer out (split containers for Q/PVertices)", downstreamLayer);
        }
        if (log.isTraceEnabled()) {
            this.log("layersArray[" + downstreamRank + "] out", this.layersArray[downstreamRank]);
        }
    }

    public int stepFive(List<LV<V>> currentLayer, List<LV<V>> downstreamLayer, int currentRank, int downstreamRank) {
        return this.transpose(currentLayer, downstreamLayer, currentRank, downstreamRank);
    }

    private int transpose(List<LV<V>> currentLayer, List<LV<V>> downstreamLayer, int currentRank, int downstreamRank) {
        List<LE<V, LE<V, E>>> biLayerEdges = this.svGraph.edgeSet().stream().filter(e -> this.edgeSourceFunction.apply((LE<V, E>)e).getRank() == currentRank && this.edgeTargetFunction.apply((LE<V, E>)e).getRank() == downstreamRank).collect(Collectors.toList());
        HashSet virtualEdges = new HashSet();
        for (LV<V> v : downstreamLayer) {
            if (v instanceof Container) {
                Container container = (Container)v;
                if (container.size() <= 0) continue;
                virtualEdges.add(VirtualEdge.of(container, container));
                continue;
            }
            if (!this.splitVertexPredicate.test(v)) continue;
            SegmentVertex qv = (SegmentVertex)v;
            SyntheticLV qvSource = SyntheticLV.of();
            qvSource.setIndex(qv.getIndex());
            qvSource.setPos(qv.getPos());
            virtualEdges.add(VirtualEdge.of(qvSource, qv));
        }
        Iterator<LV<V>> iterator = currentLayer.iterator();
        while (iterator.hasNext()) {
            if (!this.isEmptyContainer(iterator.next())) continue;
            iterator.remove();
        }
        EiglspergerSteps.updateIndices(currentLayer);
        EiglspergerSteps.updatePositions(currentLayer);
        iterator = downstreamLayer.iterator();
        while (iterator.hasNext()) {
            if (!this.isEmptyContainer(iterator.next())) continue;
            iterator.remove();
        }
        EiglspergerSteps.updateIndices(downstreamLayer);
        EiglspergerSteps.updatePositions(downstreamLayer);
        this.typeOneConflicts.addAll(this.getEdgesThatCrossVirtualEdge(virtualEdges, biLayerEdges));
        biLayerEdges.addAll(virtualEdges);
        if (log.isTraceEnabled()) {
            log.trace("for ranks {} and {} ....", (Object)currentRank, (Object)downstreamRank);
        }
        return this.processRanks(downstreamLayer, this.edgeEndpointSwapOrNot.apply(biLayerEdges));
    }

    private int processRanks(List<LV<V>> downstreamLayer, List<LE<V, E>> biLayerEdges) {
        int crossCount = Integer.MAX_VALUE;
        Function<Integer, Integer> f = i -> {
            LE edge = (LE)biLayerEdges.get((int)i);
            LV target = edge.getTarget();
            if (target instanceof Container) {
                return ((Container)target).size();
            }
            return 1;
        };
        if (downstreamLayer.size() < 2) {
            crossCount = 0;
        }
        for (int j = 0; j < downstreamLayer.size() - 1; ++j) {
            if (log.isTraceEnabled()) {
                int vw2 = this.crossingCount(biLayerEdges);
                int vw3 = AccumulatorTreeUtil.crossingCount(biLayerEdges);
                if (log.isTraceEnabled()) {
                    log.trace("IS count:{}, AC count:{}", (Object)vw2, (Object)vw3);
                }
            }
            int vw = AccumulatorTreeUtil.crossingWeight(biLayerEdges, f);
            crossCount = Math.min(vw, crossCount);
            if (log.isTraceEnabled()) {
                log.trace("crossingWeight:{}", (Object)vw);
            }
            if (vw == 0) break;
            if (downstreamLayer.get(j).getMeasure() != downstreamLayer.get(j + 1).getMeasure()) continue;
            EiglspergerSteps.swap(downstreamLayer, j, j + 1);
            if (log.isTraceEnabled()) {
                int wv2 = this.crossingCount(biLayerEdges);
                int wv3 = AccumulatorTreeUtil.crossingCount(biLayerEdges);
                log.trace("IS count:{}, AC count:{}", (Object)wv2, (Object)wv3);
            }
            int wv = AccumulatorTreeUtil.crossingWeight(biLayerEdges, f);
            crossCount = Math.min(wv, crossCount);
            if (log.isTraceEnabled()) {
                log.trace("swapped crossingWeight:{}", (Object)wv);
            }
            EiglspergerSteps.swap(downstreamLayer, j, j + 1);
            if (vw <= wv) continue;
            EiglspergerSteps.swap(downstreamLayer, j, j + 1);
            if (wv == 0) break;
        }
        log.trace("crossCount  {}", (Object)crossCount);
        EiglspergerSteps.updatePositions(downstreamLayer);
        return crossCount;
    }

    Set<LE<V, E>> getEdgesThatCrossVirtualEdge(Set<LE<V, E>> virtualEdges, List<LE<V, E>> biLayerEdges) {
        HashSet<Integer> virtualEdgeIndices = new HashSet<Integer>();
        for (LE<V, E> edge : virtualEdges) {
            virtualEdgeIndices.add(edge.getSource().getIndex());
            virtualEdgeIndices.add(edge.getTarget().getIndex());
        }
        HashSet<LE<V, LE<V, E>>> typeOneConflictEdges = new HashSet<LE<V, LE<V, E>>>();
        for (LE<V, E> edge : biLayerEdges) {
            if (edge instanceof VirtualEdge) continue;
            ArrayList<Integer> sortedIndices = new ArrayList<Integer>();
            sortedIndices.add(edge.getSource().getIndex());
            sortedIndices.add(edge.getTarget().getIndex());
            Collections.sort(sortedIndices);
            Iterator iterator = virtualEdgeIndices.iterator();
            while (iterator.hasNext()) {
                int virtualIndex = (Integer)iterator.next();
                int idxZero = (Integer)sortedIndices.get(0);
                int idxOne = (Integer)sortedIndices.get(1);
                if (idxZero > virtualIndex || virtualIndex >= idxOne) continue;
                typeOneConflictEdges.add(edge);
            }
        }
        return typeOneConflictEdges;
    }

    private boolean isEmptyContainer(LV<V> v) {
        return v instanceof Container && ((Container)v).size() == 0;
    }

    protected static <V, E> List<LE<V, E>> swapEdgeEndpoints(List<LE<V, E>> list) {
        return list.stream().map(e -> LE.of(e.getEdge(), e.getTarget(), e.getSource())).collect(Collectors.toList());
    }

    private int crossingCount(List<LE<V, E>> edges) {
        edges.sort(Comparators.biLevelEdgeComparator());
        ArrayList<Integer> targetIndices = new ArrayList<Integer>();
        for (LE lE : edges) {
            targetIndices.add(lE.getTarget().getIndex());
        }
        return InsertionSortCounter.insertionSortCounter(targetIndices);
    }

    private static <V> void swap(LV<V>[] array, int i, int j) {
        LV<V> temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        array[i].setIndex(i);
        array[j].setIndex(j);
    }

    private static <V> void swap(List<LV<V>> array, int i, int j) {
        Collections.swap(array, i, j);
        array.get(i).setIndex(i);
        array.get(j).setIndex(j);
        EiglspergerSteps.updatePositions(array);
    }

    public void stepSix(List<LV<V>> downstreamLayer) {
        if (log.isTraceEnabled()) {
            this.log("stepSix downstreamLayer in", downstreamLayer);
        }
        List<LV<V>> scanned = EiglspergerUtil.scan(downstreamLayer);
        downstreamLayer.clear();
        downstreamLayer.addAll(scanned);
        if (log.isTraceEnabled()) {
            this.log("stepSix downstreamLayer out (padded with and compressed containers)", downstreamLayer);
        }
    }

    static <V> LV<V> s(LV<V> v) {
        if (v instanceof SegmentVertex) {
            SegmentVertex pVertex = (SegmentVertex)v;
            return pVertex.getSegment();
        }
        return v;
    }

    static <V> boolean updatePositions(List<LV<V>> layer) {
        boolean changed = false;
        int currentPos = 0;
        for (LV<V> v : layer) {
            if (v instanceof Container && ((Container)v).size() == 0) continue;
            if (v.getPos() != currentPos) {
                changed = true;
            }
            v.setPos(currentPos);
            if (v instanceof Container) {
                currentPos += ((Container)v).size();
                continue;
            }
            ++currentPos;
        }
        return changed;
    }

    void assignPositions(List<LV<V>> currentLayer) {
        LV<V> previousVertex = null;
        InsertionOrderSplayTree previousContainer = null;
        for (int i = 0; i < currentLayer.size(); ++i) {
            int pos;
            LV<V> v = currentLayer.get(i);
            if (i % 2 == 0) {
                Container container = (Container)v;
                if (container.size() > 0) {
                    if (previousContainer == null) {
                        container.setPos(0);
                    } else {
                        int pos2 = previousVertex.getPos() + 1;
                        container.setPos(pos2);
                    }
                }
                previousContainer = container;
                continue;
            }
            if (previousVertex == null) {
                pos = previousContainer.size();
                v.setPos(pos);
            } else {
                pos = previousVertex.getPos() + previousContainer.size() + 1;
                v.setPos(pos);
            }
            previousVertex = v;
        }
    }

    void assignMeasures(List<LV<V>> downstreamLayer) {
        downstreamLayer.stream().filter(v -> v instanceof Container).map(v -> (Container)v).filter(c -> c.size() > 0).forEach(c -> {
            double measure = c.getPos();
            c.setMeasure(measure);
        });
        for (LV<V> v2 : downstreamLayer) {
            if (this.splitVertexPredicate.test(v2)) continue;
            if (v2 instanceof Container) {
                Container container = (Container)v2;
                double measure = container.getPos();
                container.setMeasure(measure);
                continue;
            }
            Set<LV<V>> neighbors = this.neighborFunction.apply(v2);
            int[] poses = new int[neighbors.size()];
            int i = 0;
            for (LV<V> neighbor : neighbors) {
                poses[i++] = neighbor.getPos();
            }
            if (poses.length > 0) {
                int measure = EiglspergerSteps.medianValue(poses);
                v2.setMeasure(measure);
                continue;
            }
            if (v2.getPos() < 0) {
                log.debug("no pos for {}", (Object)v2);
            }
            double measure = v2.getPos();
            v2.setMeasure(measure);
        }
    }

    static int medianValue(int[] P) {
        if (P.length == 0) {
            return -1;
        }
        if (P.length == 1) {
            return P[0];
        }
        Arrays.sort(P);
        int m = P.length / 2;
        if (P.length % 2 == 1) {
            return P[m];
        }
        if (P.length == 2) {
            return (P[0] + P[1]) / 2;
        }
        int left = P[m - 1] - P[0];
        int right = P[P.length - 1] - P[m];
        if (left + right == 0) {
            return 0;
        }
        return (P[m - 1] * right + P[m] * left) / (left + right);
    }
}

