/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentVertex;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VerticalAlignment<V, E>
extends org.jungrapht.visualization.layout.algorithms.sugiyama.VerticalAlignment<V, E> {
    private static final Logger log = LoggerFactory.getLogger(VerticalAlignment.class);
    protected Graph<LV<V>, Integer> compactionGraph;
    protected final HDirection hDirection;
    protected final VDirection vDirection;

    protected VerticalAlignment(HDirection hDirection, VDirection vDirection, LV<V>[][] layers, Graph<LV<V>, Integer> compactionGraph, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
        super(layers, svGraph, markedSegments);
        this.hDirection = hDirection;
        this.vDirection = vDirection;
        this.compactionGraph = compactionGraph;
        compactionGraph.vertexSet().forEach(v -> {
            this.rootMap.put(v, v);
            this.alignMap.put(v, v);
        });
    }

    @Override
    protected int alignMoveCursor(LV<V> neighbor, LV<V> vertex) {
        this.align(neighbor, vertex);
        this.root(vertex, this.root(neighbor));
        this.align(vertex, this.root(vertex));
        return this.pos(neighbor);
    }

    protected int alignSegmentVertexMoveCursor(SegmentVertex<V> segmentVertex) {
        SegmentVertex neighborSegmentVertex = segmentVertex instanceof PVertex ? segmentVertex.segment.qVertex : segmentVertex.segment.pVertex;
        this.root(segmentVertex, this.root(neighborSegmentVertex));
        this.align(segmentVertex, this.root(segmentVertex));
        return this.pos(neighborSegmentVertex);
    }

    @Override
    protected int pos(LV<V> v) {
        return v.getPos();
    }

    protected int idx(LV<V> v) {
        return v.getIndex();
    }

    public static enum HDirection {
        LtoR,
        RtoL;

    }

    public static enum VDirection {
        TtoB,
        BtoT;

    }

    public static class RightmostLower<V, E>
    extends VerticalAlignment<V, E> {
        public RightmostLower(HDirection hDirection, VDirection vDirection, LV<V>[][] layers, Graph<LV<V>, Integer> compactionGraph, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(hDirection, vDirection, layers, compactionGraph, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = this.layers.length - 2; i >= 0; --i) {
                LV[] currentLayer = this.layers[i];
                LV[] previousLayerInSweep = this.layers[i + 1];
                int r = this.pos(previousLayerInSweep[previousLayerInSweep.length - 1]) + 1;
                for (int k = currentLayer.length - 1; k >= 0; --k) {
                    int[] measures;
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.successorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    if (d % 2 == 0) {
                        int floor = (int)Math.floor((double)(d - 1) / 2.0);
                        int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                        measures = new int[]{ceil, floor};
                    } else {
                        measures = new int[]{(d - 1) / 2};
                    }
                    for (int m : measures) {
                        if (this.align(vkofi) != vkofi) continue;
                        LV um = (LV)neighbors.get(m);
                        LE edge = (LE)this.svGraph.getEdge(vkofi, um);
                        if (vkofi instanceof PVertex) {
                            r = this.alignSegmentVertexMoveCursor((SegmentVertex)vkofi);
                            continue;
                        }
                        if (!this.notMarked(edge) || r <= this.pos(um)) continue;
                        r = this.alignMoveCursor(um, vkofi);
                    }
                }
            }
        }
    }

    public static class LeftmostLower<V, E>
    extends VerticalAlignment<V, E> {
        public LeftmostLower(HDirection hDirection, VDirection vDirection, LV<V>[][] layers, Graph<LV<V>, Integer> compactionGraph, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(hDirection, vDirection, layers, compactionGraph, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = this.layers.length - 2; i >= 0; --i) {
                int r = -1;
                LV[] currentLayer = this.layers[i];
                for (int k = 0; k < currentLayer.length; ++k) {
                    int[] measures;
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.successorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    if (d % 2 == 0) {
                        int floor = (int)Math.floor((double)(d - 1) / 2.0);
                        int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                        measures = new int[]{floor, ceil};
                    } else {
                        measures = new int[]{(d - 1) / 2};
                    }
                    for (int m : measures) {
                        if (this.align(vkofi) != vkofi) continue;
                        LV um = (LV)neighbors.get(m);
                        LE edge = (LE)this.svGraph.getEdge(vkofi, um);
                        if (vkofi instanceof PVertex) {
                            r = this.alignSegmentVertexMoveCursor((SegmentVertex)vkofi);
                            continue;
                        }
                        if (!this.notMarked(edge) || r >= this.pos(um)) continue;
                        r = this.alignMoveCursor(um, vkofi);
                    }
                }
            }
        }
    }

    public static class RightmostUpper<V, E>
    extends VerticalAlignment<V, E> {
        public RightmostUpper(HDirection hDirection, VDirection vDirection, LV<V>[][] layers, Graph<LV<V>, Integer> compactionGraph, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(hDirection, vDirection, layers, compactionGraph, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = 1; i < this.layers.length; ++i) {
                LV[] currentLayer = this.layers[i];
                LV[] previousLayerInSweep = this.layers[i - 1];
                int r = this.pos(previousLayerInSweep[previousLayerInSweep.length - 1]) + 1;
                for (int k = currentLayer.length - 1; k >= 0; --k) {
                    int[] measures;
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.predecessorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    if (d % 2 == 0) {
                        int floor = (int)Math.floor((double)(d - 1) / 2.0);
                        int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                        measures = new int[]{ceil, floor};
                    } else {
                        measures = new int[]{(d - 1) / 2};
                    }
                    for (int m : measures) {
                        if (this.align(vkofi) != vkofi) continue;
                        LV um = (LV)neighbors.get(m);
                        LE edge = (LE)this.svGraph.getEdge(um, vkofi);
                        if (vkofi instanceof QVertex) {
                            r = this.alignSegmentVertexMoveCursor((SegmentVertex)vkofi);
                            continue;
                        }
                        if (!this.notMarked(edge) || r <= this.pos(um)) continue;
                        r = this.alignMoveCursor(um, vkofi);
                    }
                }
            }
        }
    }

    public static class LeftmostUpper<V, E>
    extends VerticalAlignment<V, E> {
        public LeftmostUpper(HDirection hDirection, VDirection vDirection, LV<V>[][] layers, Graph<LV<V>, Integer> compactionGraph, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(hDirection, vDirection, layers, compactionGraph, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = 0; i < this.layers.length; ++i) {
                int r = -1;
                LV[] currentLayer = this.layers[i];
                for (int k = 0; k <= currentLayer.length - 1; ++k) {
                    int[] measures;
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.predecessorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    if (d % 2 == 0) {
                        int floor = (int)Math.floor((double)(d - 1) / 2.0);
                        int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                        measures = new int[]{floor, ceil};
                    } else {
                        measures = new int[]{(d - 1) / 2};
                    }
                    for (int m : measures) {
                        if (this.align(vkofi) != vkofi) continue;
                        LV um = (LV)neighbors.get(m);
                        LE edge = (LE)this.svGraph.getEdge(um, vkofi);
                        if (vkofi instanceof QVertex) {
                            r = this.alignSegmentVertexMoveCursor((SegmentVertex)vkofi);
                            continue;
                        }
                        if (!this.notMarked(edge) || r >= this.pos(um)) continue;
                        r = this.alignMoveCursor(um, vkofi);
                    }
                }
            }
        }
    }
}

