/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.sugiyama.ArticulatedEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.SyntheticLE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.SyntheticLV;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Synthetics<V, E> {
    private static final Logger log = LoggerFactory.getLogger(Synthetics.class);
    protected final Graph<LV<V>, LE<V, E>> dag;

    public Synthetics(Graph<LV<V>, LE<V, E>> dag) {
        this.dag = dag;
    }

    public LV<V>[][] createVirtualVerticesAndEdges(List<LE<V, E>> edges, List<List<LV<V>>> layers) {
        for (int i = 0; i < layers.size() - 1; ++i) {
            List<LV<V>> currentLayer = layers.get(i);
            for (LV<V> v : currentLayer) {
                int newVertexRank;
                SyntheticLV virtualVertex;
                ArrayList<LE<V, LE>> outgoingMulti = new ArrayList<LE<V, LE>>();
                for (LE<V, LE> lE : edges) {
                    if (!lE.getSource().equals(v) || Math.abs(lE.getTarget().getRank() - v.getRank()) <= 1) continue;
                    outgoingMulti.add(lE);
                }
                ArrayList<LE<V, LE>> incomingMulti = new ArrayList<LE<V, LE>>();
                for (LE<V, LE> lE : edges) {
                    if (!lE.getTarget().equals(v) || Math.abs(lE.getSource().getRank() - v.getRank()) <= 1) continue;
                    incomingMulti.add(lE);
                }
                for (LE lE : outgoingMulti) {
                    virtualVertex = SyntheticLV.of();
                    newVertexRank = lE.getSource().getRank() + 1;
                    virtualVertex.setRank(newVertexRank);
                    virtualVertex.setIndex(layers.get(newVertexRank).size());
                    this.replaceEdgeWithTwo(edges, lE, virtualVertex);
                    layers.get(newVertexRank).add(virtualVertex);
                    this.updateIndices(layers.get(newVertexRank));
                    edges.removeIf(lE::equals);
                }
                for (LE lE : incomingMulti) {
                    virtualVertex = SyntheticLV.of();
                    newVertexRank = lE.getTarget().getRank() - 1;
                    virtualVertex.setRank(newVertexRank);
                    virtualVertex.setIndex(layers.get(newVertexRank).size());
                    this.replaceEdgeWithTwo(edges, lE, virtualVertex);
                    layers.get(newVertexRank).add(virtualVertex);
                    this.updateIndices(layers.get(newVertexRank));
                    edges.removeIf(lE::equals);
                }
            }
        }
        return this.convertToArrays(layers);
    }

    private LV<V>[][] convertToArrays(List<List<LV<V>>> layers) {
        LV[][] ranks = new LV[layers.size()][];
        for (int i = 0; i < layers.size(); ++i) {
            List<LV<V>> list = layers.get(i);
            ranks[i] = new LV[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                ranks[i][j] = list.get(j);
            }
        }
        return ranks;
    }

    private void updateIndices(List<LV<V>> layer) {
        for (int i = 0; i < layer.size(); ++i) {
            LV<V> LV2 = layer.get(i);
            LV2.setIndex(i);
        }
    }

    private void replaceEdgeWithTwo(List<LE<V, E>> edges, LE<V, E> loser, LV<V> virtualVertex) {
        LV<V> from = loser.getSource();
        LV<V> to = loser.getTarget();
        SyntheticLE virtualEdgeOne = SyntheticLE.of(loser, from, virtualVertex);
        SyntheticLE virtualEdgeTwo = SyntheticLE.of(loser, virtualVertex, to);
        edges.add(virtualEdgeOne);
        edges.add(virtualEdgeTwo);
        this.dag.addVertex(virtualVertex);
        this.dag.addEdge(from, virtualVertex, virtualEdgeOne);
        this.dag.addEdge(virtualVertex, to, virtualEdgeTwo);
        this.dag.removeEdge(loser);
        edges.remove(loser);
    }

    public List<ArticulatedEdge<V, E>> makeArticulatedEdges() {
        ArrayList<ArticulatedEdge<V, ArticulatedEdge>> articulatedEdges = new ArrayList<ArticulatedEdge<V, ArticulatedEdge>>();
        ArrayList<SyntheticLV> syntheticVerticesToRemove = new ArrayList<SyntheticLV>();
        ArrayList<SyntheticLE> syntheticEdgesToRemove = new ArrayList<SyntheticLE>();
        for (LE<V, E> edge : this.dag.edgeSet()) {
            if (!(edge instanceof SyntheticLE)) continue;
            SyntheticLE syntheticEdge = (SyntheticLE)edge;
            ArrayList<SyntheticLV> syntheticVertices = new ArrayList<SyntheticLV>();
            LV<V> source = this.dag.getEdgeSource(edge);
            if (source instanceof SyntheticLV) continue;
            syntheticEdgesToRemove.add(syntheticEdge);
            LV<V> target = this.dag.getEdgeTarget(syntheticEdge);
            while (target instanceof SyntheticLV) {
                SyntheticLV syntheticTarget = (SyntheticLV)target;
                syntheticVerticesToRemove.add(syntheticTarget);
                syntheticVertices.add(syntheticTarget);
                LE outgoingEdge = (LE)this.dag.outgoingEdgesOf(target).stream().findFirst().get();
                syntheticEdgesToRemove.add((SyntheticLE)outgoingEdge);
                target = this.dag.getEdgeTarget(outgoingEdge);
            }
            ArticulatedEdge articulatedEdge = ArticulatedEdge.of(edge, source, target);
            syntheticVertices.forEach(articulatedEdge::addIntermediateVertex);
            syntheticVertices.forEach(v -> articulatedEdge.addIntermediatePoint(v.getPoint()));
            articulatedEdges.add(articulatedEdge);
        }
        syntheticEdgesToRemove.forEach(this.dag::removeEdge);
        syntheticVerticesToRemove.forEach(this.dag::removeVertex);
        articulatedEdges.forEach(e -> this.dag.addEdge(e.source, e.target, (LE<LV, ArticulatedEdge>)e));
        return articulatedEdges;
    }

    public void alignArticulatedEdges() {
        HashSet<Point> allInnerPoints = new HashSet<Point>();
        for (LE<V, E> edge : this.dag.edgeSet()) {
            if (!(edge instanceof SyntheticLE)) continue;
            SyntheticLE syntheticEdge = (SyntheticLE)edge;
            LV<V> source = this.dag.getEdgeSource(edge);
            if (source instanceof SyntheticLV) continue;
            LV<V> target = this.dag.getEdgeTarget(syntheticEdge);
            LinkedHashMap<SyntheticLV, Point> innerPoints = new LinkedHashMap<SyntheticLV, Point>();
            while (target instanceof SyntheticLV) {
                SyntheticLV syntheticTarget = (SyntheticLV)target;
                innerPoints.put(syntheticTarget, syntheticTarget.getPoint());
                LE outgoingEdge = (LE)this.dag.outgoingEdgesOf(target).stream().findFirst().get();
                target = this.dag.getEdgeTarget(outgoingEdge);
            }
            double avgx = innerPoints.values().stream().mapToDouble(p -> p.x).average().getAsDouble();
            log.trace("points: {}, avgx: {}", (Object)innerPoints.values(), (Object)avgx);
            boolean overlap = false;
            for (SyntheticLV v2 : innerPoints.keySet()) {
                Point newPoint = Point.of(avgx, v2.p.y);
                overlap |= allInnerPoints.contains(newPoint);
                allInnerPoints.add(newPoint);
                v2.setPoint(newPoint);
            }
            if (!overlap) continue;
            if (log.isTraceEnabled()) {
                log.trace("overlap at {}", (Object)innerPoints.keySet());
            }
            innerPoints.keySet().forEach(v -> v.setPoint(Point.of(v.p.x + 20.0, v.p.y)));
        }
    }
}

