/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jgrapht.util.SupplierUtil;
import org.jungrapht.visualization.layout.algorithms.EiglspergerLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import tlc2.overrides.TLAPlusOperator;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueVec;
import util.UniqueString;

public final class SVG {
    private SVG() {
    }

    @TLAPlusOperator(identifier="SVGElemToString", module="SVG", warn=false)
    public static Value SVGElemToString(Value value) throws Exception {
        StringValue stringValue;
        Object object;
        StringValue stringValue22;
        if (!(value instanceof RecordValue) || value.toRcd() == null) {
            throw new Exception("An SVG element must be a record. Value given is of type: " + value.getClass().getName());
        }
        RecordValue recordValue = (RecordValue)value.toRcd();
        StringValue stringValue3 = (StringValue)recordValue.apply((Value)new StringValue("name"), 0);
        String string = stringValue3.getVal().toString();
        Value value2 = recordValue.apply((Value)new StringValue("attrs"), 0);
        RecordValue recordValue2 = (RecordValue)value2.toRcd();
        if (recordValue2 == null) {
            throw new Exception("Was unable to convert element to a record: " + value2.toString());
        }
        String string2 = "";
        for (StringValue stringValue22 : recordValue2.names) {
            string2 = string2 + " ";
            string2 = string2 + stringValue22.toString().replaceAll("_", "-");
            string2 = string2 + "=";
            String string3 = ((StringValue)recordValue2.apply((Value)new StringValue((UniqueString)stringValue22), 0)).getVal().toString();
            string2 = string2 + "'" + string3 + "'";
        }
        Value value3 = recordValue.apply((Value)new StringValue("children"), 0);
        if (value3 instanceof TupleValue) {
            object = (TupleValue)value3.toTuple();
            stringValue = object.elems;
        } else if (value3 instanceof RecordValue) {
            object = (RecordValue)value3.toRcd();
            stringValue = object.values;
        } else if (value3 instanceof FcnRcdValue) {
            object = (FcnRcdValue)value3.toFcnRcd();
            stringValue = object.values;
        } else if (value3 instanceof FcnLambdaValue) {
            object = (FcnRcdValue)value3.toFcnRcd();
            stringValue = object.values;
        } else {
            throw new Exception("Was unable to convert element to a tuple or (function) record: " + value3.toString());
        }
        object = "";
        for (Value value4 : stringValue) {
            StringValue stringValue4 = (StringValue)SVG.SVGElemToString(value4);
            object = (String)object + stringValue4.getVal().toString();
        }
        stringValue22 = (StringValue)recordValue.apply((Value)new StringValue("innerText"), 0);
        String string4 = stringValue22.getVal().toString();
        string4 = string4.replaceAll("<<", "&lt;&lt;").replaceAll(">>", "&gt;&gt;");
        String string5 = String.format("<%s%s>", string, string2);
        string5 = string5 + string4;
        string5 = string5 + (String)object;
        string5 = string5 + String.format("</%s>", string);
        return new StringValue(string5);
    }

    @TLAPlusOperator(identifier="NodeOfRingNetwork", module="SVG", warn=false)
    public static Value ringNetwork(IntValue intValue, IntValue intValue2, IntValue intValue3, IntValue intValue4, IntValue intValue5) throws Exception {
        double d = Math.PI * 2 / (double)intValue5.val * (double)intValue4.val;
        int n = (int)((double)intValue.val + (double)intValue3.val * Math.cos(d));
        int n2 = (int)((double)intValue2.val + (double)intValue3.val * Math.sin(d));
        return new RecordValue(new UniqueString[]{UniqueString.of((String)"x"), UniqueString.of((String)"y")}, new Value[]{IntValue.gen((int)n), IntValue.gen((int)n2)}, false);
    }

    @TLAPlusOperator(identifier="NodesOfDirectedMultiGraph", module="SVG", warn=false)
    public static Value directedMultiGraph(Value value, Value value2, Value value3) throws Exception {
        if (!(value instanceof SetEnumValue) && value.toSetEnum() == null) {
            throw new Exception("Nodes must be a set. Value given is of type: " + value.getClass().getName());
        }
        if (!(value2 instanceof SetEnumValue) && value2.toSetEnum() == null) {
            throw new Exception("Edges must be a set. Value given is of type: " + value2.getClass().getName());
        }
        if (!(value3 instanceof RecordValue) && value3.toRcd() == null) {
            throw new Exception("Opts must be a record. Value given is of type: " + value3.getClass().getName());
        }
        SetEnumValue setEnumValue = (SetEnumValue)value.toSetEnum();
        SetEnumValue setEnumValue2 = (SetEnumValue)value2.toSetEnum();
        RecordValue recordValue = (RecordValue)value3.toRcd();
        return JUngraph.toGraph(setEnumValue, setEnumValue2, recordValue);
    }

    @TLAPlusOperator(identifier="PointOnLine", module="SVG", warn=false)
    public static Value pointOnLine(RecordValue recordValue, RecordValue recordValue2, IntValue intValue) throws Exception {
        int n = ((IntValue)recordValue.select((Value)new StringValue((String)"x"))).val;
        int n2 = ((IntValue)recordValue.select((Value)new StringValue((String)"y"))).val;
        int n3 = ((IntValue)recordValue2.select((Value)new StringValue((String)"x"))).val;
        int n4 = ((IntValue)recordValue2.select((Value)new StringValue((String)"y"))).val;
        int n5 = (int)((double)n + (double)(n3 - n) / ((double)intValue.val * 1.0));
        int n6 = (int)((double)n2 + (double)(n4 - n2) / ((double)intValue.val * 1.0));
        return new RecordValue(new UniqueString[]{UniqueString.of((String)"x"), UniqueString.of((String)"y")}, new Value[]{IntValue.gen((int)n5), IntValue.gen((int)n6)}, false);
    }

    private static class JUngraph {
        private JUngraph() {
        }

        private static Value toGraph(SetEnumValue setEnumValue, SetEnumValue setEnumValue2, RecordValue recordValue) {
            TupleValue tupleValue;
            int n;
            Graph<Value, Integer> graph = GraphTypeBuilder.forGraphType(DefaultGraphType.directedMultigraph()).edgeSupplier(SupplierUtil.createIntegerSupplier()).allowingSelfLoops(false).buildGraph();
            ValueVec valueVec = setEnumValue.elems;
            for (n = 0; n < valueVec.size(); ++n) {
                graph.addVertex(valueVec.elementAt(n));
            }
            valueVec = setEnumValue2.elems;
            for (n = 0; n < valueVec.size(); ++n) {
                tupleValue = (TupleValue)valueVec.elementAt(n);
                graph.addEdge(tupleValue.elems[0], tupleValue.elems[1]);
            }
            IntValue intValue = (IntValue)recordValue.apply((Value)new StringValue("view_width"), 0);
            tupleValue = (IntValue)recordValue.apply((Value)new StringValue("view_height"), 0);
            Object t = ((LayoutModel.Builder)((LayoutModel.Builder)LayoutModel.builder().size(tupleValue.val, intValue.val)).graph(graph)).build();
            StringValue stringValue = (StringValue)recordValue.apply((Value)new StringValue("algo"), 0);
            JUngraph.getAlgo(stringValue.val.toString(), recordValue).visit((LayoutModel<Value>)t);
            Map map = t.getLocations();
            return new FcnRcdValue(map.entrySet().stream().collect(Collectors.toMap(entry -> (Value)entry.getKey(), entry -> JUngraph.point2Value((Point)entry.getValue()))));
        }

        private static Value point2Value(Point point) {
            int n = Double.valueOf(point.x).intValue();
            int n2 = Double.valueOf(point.y).intValue();
            return new RecordValue(new UniqueString[]{UniqueString.of((String)"x"), UniqueString.of((String)"y")}, new Value[]{IntValue.gen((int)n), IntValue.gen((int)n2)}, false);
        }

        private static LayoutAlgorithm<Value> getAlgo(String string, RecordValue recordValue) {
            IntValue intValue = (IntValue)recordValue.apply((Value)new StringValue("node_width"), 0);
            IntValue intValue2 = (IntValue)recordValue.apply((Value)new StringValue("node_height"), 0);
            switch (string) {
                case "Sugiyama": {
                    String string2 = ((StringValue)recordValue.apply((Value)new StringValue((String)"layering"), (int)0)).val.toString();
                    return ((SugiyamaLayoutAlgorithm.Builder)((SugiyamaLayoutAlgorithm.Builder)((SugiyamaLayoutAlgorithm.Builder)SugiyamaLayoutAlgorithm.edgeAwareBuilder().layering(Layering.valueOf(string2))).vertexBoundsFunction(value -> Rectangle.of(-5, -5, intValue.val, intValue2.val))).threaded(false)).build();
                }
                case "Eiglsperger": {
                    String string3 = ((StringValue)recordValue.apply((Value)new StringValue((String)"layering"), (int)0)).val.toString();
                    return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().layering(Layering.valueOf(string3))).vertexBoundsFunction(value -> Rectangle.of(-5, -5, intValue.val, intValue2.val))).threaded(false)).build();
                }
            }
            return ((TreeLayoutAlgorithm.Builder)TreeLayoutAlgorithm.builder().vertexBoundsFunction(value -> Rectangle.of(-5, -5, intValue.val, intValue2.val))).build();
        }
    }
}

