/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.xml;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.LogLevel;
import tla2sany.output.SimpleSanyOutput;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportingException;
import util.FileUtil;
import util.SimpleFilenameToStream;
import util.ToolIO;
import util.UsageGenerator;

public class XMLExporter {
    static final void printUsage(PrintStream out) {
        ArrayList<List<UsageGenerator.Argument>> variants = new ArrayList<List<UsageGenerator.Argument>>();
        ArrayList<UsageGenerator.Argument> args = new ArrayList<UsageGenerator.Argument>();
        args.add(new UsageGenerator.Argument("-o", "Offline mode; skip XML schema validation step.", true));
        args.add(new UsageGenerator.Argument("-t", "Terse; format XML output without tabs or newlines.", true));
        args.add(new UsageGenerator.Argument("-r", "Restrict mode; include only declarations and definitions of the specified module, excluding extended or instantiated modules.", true));
        args.add(new UsageGenerator.Argument("-u", "Uncomment; process boxed comments and single-line comments (\\*) in pre-comments to extract their content.", true));
        args.add(new UsageGenerator.Argument("-I", "Include; use given directory path to resolve module dependencies.", true));
        args.add(new UsageGenerator.Argument("-help", "Print this usage information.", true));
        args.add(new UsageGenerator.Argument("FILE", "The TLA+ module to parse.", false));
        variants.add(args);
        ArrayList<String> tips = new ArrayList<String>();
        tips.add("Only one root TLA+ file can be parsed per run.");
        tips.add("Multiple directory search paths can be given by providing multiple -I arguments.");
        tips.add("XML schema validation does not require network access.");
        UsageGenerator.displayUsage(out, XMLExporter.class.getCanonicalName(), SANY.version, "Emit SANY's parse tree as XML", "Given a TLA+ file, parse that file with SANY then translate the module's semantic parse tree to XML, including all the modules depended on. The XML is printed to stdout and its output format is given by an XML Schema file (.xsd) found at https://proofs.tlapl.us/doc/web/sany.xsd.", variants, tips, ' ');
    }

    public static void main(String ... args) throws XMLExportingException {
        System.exit(XMLExporter.run(args));
    }

    static int run(String ... args) throws XMLExportingException {
        try {
            XMLExporter.moduleToXML(args);
            return 0;
        }
        catch (IllegalArgumentException e) {
            ToolIO.err.println("ERROR: " + e.getMessage());
            XMLExporter.printUsage(ToolIO.err);
            return 1;
        }
    }

    static void moduleToXML(String ... args) throws XMLExportingException {
        SpecObj spec;
        boolean uncomment;
        boolean restricted;
        boolean pretty_print;
        boolean offline_mode;
        block30: {
            String tla_name;
            if (args.length < 1) {
                throw new IllegalArgumentException("at least one .tla file must be given");
            }
            LinkedList<String> pathsLs = new LinkedList<String>();
            offline_mode = false;
            pretty_print = true;
            restricted = false;
            uncomment = false;
            int lastarg = -1;
            for (int i = 0; i < args.length - 1; ++i) {
                if ("-o".equals(args[i])) {
                    offline_mode = true;
                    lastarg = i;
                    continue;
                }
                if ("-t".equals(args[i])) {
                    pretty_print = false;
                    lastarg = i;
                    continue;
                }
                if ("-r".equals(args[i])) {
                    restricted = true;
                    lastarg = i;
                    continue;
                }
                if ("-u".equals(args[i])) {
                    uncomment = true;
                    lastarg = i;
                    continue;
                }
                if (!"-I".equals(args[i])) continue;
                if (++i > args.length - 2) {
                    throw new IllegalArgumentException("the -I flag must be followed by a directory and at least one .tla file");
                }
                pathsLs.addLast(args[i]);
                lastarg = i;
            }
            ++lastarg;
            String[] paths = new String[pathsLs.size()];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = (String)pathsLs.get(i);
            }
            if (args.length - lastarg != 1) {
                throw new IllegalArgumentException("Only one TLA file to check allowed!");
            }
            if (args[args.length - 1].equals("-help")) {
                XMLExporter.printUsage(ToolIO.out);
                return;
            }
            SimpleFilenameToStream fts = new SimpleFilenameToStream(paths);
            spec = new SpecObj(tla_name, fts);
            if (FileUtil.createNamedInputStream(tla_name = args[lastarg++], spec.getResolver()) != null) {
                try {
                    SimpleSanyOutput out = new SimpleSanyOutput(ToolIO.err, LogLevel.ERROR);
                    SANY.frontEndMain(spec, tla_name, out);
                    if (spec.getExternalModuleTable() == null) {
                        throw new XMLExportingException("spec " + spec.getName() + " is malformed - does not have an external module table", null);
                    }
                    if (spec.getExternalModuleTable().getRootModule() == null) {
                        throw new XMLExportingException("spec " + spec.getName() + " is malformed - does not have a root module", null);
                    }
                    break block30;
                }
                catch (FrontEndException fe) {
                    fe.printStackTrace();
                    ToolIO.err.println(fe);
                    return;
                }
            }
            throw new IllegalArgumentException("Cannot find the specified file " + tla_name + ".");
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("modules");
            doc.appendChild(rootElement);
            SymbolContext context = new SymbolContext();
            ExternalModuleTable table = spec.getExternalModuleTable();
            if (restricted) {
                BiPredicate<SemanticNode, SemanticNode> filter = (s1, s2) -> {
                    if (s1 instanceof OpDefOrDeclNode && s2 instanceof ModuleNode) {
                        OpDefOrDeclNode oddn = (OpDefOrDeclNode)s1;
                        return s2.equals(oddn.getOriginallyDefinedInModuleNode());
                    }
                    return true;
                };
                Element ext_e = spec.getRootModule().export(doc, context, filter);
                rootElement.appendChild(ext_e);
            } else {
                ModuleNode[] externalModules = table.getModuleNodes();
                for (int j = 0; j < externalModules.length; ++j) {
                    Element ext_e = externalModules[j].export(doc, context);
                    rootElement.appendChild(ext_e);
                }
            }
            rootElement.insertBefore(context.getContextElement(doc), rootElement.getFirstChild());
            XMLExporter.insertRootName(doc, rootElement, spec);
            if (uncomment) {
                NodeList nodes = doc.getElementsByTagName("pre-comments");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    NodeList children = ((Element)nodes.item(i)).getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node child = children.item(j);
                        if (child.getNodeType() != 4) continue;
                        ((CDATASection)child).setData(SyntaxTreeNode.unboxBackslashStarComment(SyntaxTreeNode.unboxComment(((CDATASection)child).getData())));
                    }
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (pretty_print) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            DOMSource source = new DOMSource(doc);
            if (!offline_mode) {
                try {
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    URL schemaFile = XMLExporter.class.getResource("sany.xsd");
                    if (null == schemaFile) {
                        ToolIO.err.println("ERROR: Unable to find sany.xsd schema file that is expected to be embedded in the jar.");
                        System.exit(1);
                    }
                    Schema schema = factory.newSchema(schemaFile);
                    Validator validator = schema.newValidator();
                    validator.validate(source);
                }
                catch (IOException factory) {
                    // empty catch block
                }
            }
            StreamResult result = new StreamResult(ToolIO.out);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLExportingException("failed to write XML", pce);
        }
        catch (TransformerException tfe) {
            throw new XMLExportingException("failed to write XML", tfe);
        }
        catch (SAXException se) {
            throw new XMLExportingException("failed to validate XML", se);
        }
    }

    static void insertRootName(Document doc, Element rootElement, SpecObj spec) {
        Element el = doc.createElement("RootModule");
        el.appendChild(doc.createTextNode(spec.getName()));
        rootElement.insertBefore(el, rootElement.getFirstChild());
    }
}

