/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.ModelChecker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.DebugTableauDiskGraph;
import tlc2.tool.liveness.DiskGraph;
import tlc2.tool.liveness.DotLivenessStateWriter;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.ILivenessStateWriter;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.LiveWorker;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.NoopLivenessStateWriter;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TableauDiskGraph;
import tlc2.util.BitVector;
import tlc2.util.IStateWriter;
import tlc2.util.LongVec;
import tlc2.util.NoopStateWriter;
import tlc2.util.SetOfStates;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.value.impl.CounterExample;
import util.Assert;

public class LiveCheck
implements ILiveCheck {
    private final String metadir;
    private final IBucketStatistics outDegreeGraphStats;
    private final ILiveChecker[] checker;

    public LiveCheck(ITool tool, String mdir, IBucketStatistics bucketStatistics) throws IOException {
        this(tool, Liveness.processLiveness(tool), mdir, bucketStatistics, new NoopStateWriter());
    }

    public LiveCheck(ITool tool, String mdir, IBucketStatistics bucketStatistics, IStateWriter stateWriter) throws IOException {
        this(tool, Liveness.processLiveness(tool), mdir, bucketStatistics, stateWriter);
    }

    public LiveCheck(ITool tool, OrderOfSolution[] solutions, String mdir, IBucketStatistics bucketStatistics) throws IOException {
        this(tool, solutions, mdir, bucketStatistics, new NoopLivenessStateWriter());
    }

    public LiveCheck(ITool tool, OrderOfSolution[] solutions, String mdir, IBucketStatistics bucketStatistics, IStateWriter stateWriter) throws IOException {
        this.metadir = mdir;
        this.outDegreeGraphStats = bucketStatistics;
        this.checker = new ILiveChecker[solutions.length];
        for (int soln = 0; soln < solutions.length; ++soln) {
            ILivenessStateWriter writer = stateWriter.isNoop() || !stateWriter.isDot() ? new NoopLivenessStateWriter() : new DotLivenessStateWriter(stateWriter);
            this.checker[soln] = !solutions[soln].hasTableau() ? new LiveChecker(solutions[soln], soln, bucketStatistics, writer) : new TableauLiveChecker(solutions[soln], soln, bucketStatistics, writer);
        }
    }

    @Override
    public void addInitState(ITool tool, TLCState state, long stateFP) {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].addInitState(tool, state, stateFP);
        }
    }

    @Override
    public void addNextState(ITool tool, TLCState s0, long fp0, SetOfStates nextStates) throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            ILiveChecker check = this.checker[i];
            OrderOfSolution oos = check.getSolution();
            int alen = oos.getCheckAction().length;
            BitVector checkActionResults = new BitVector(alen * nextStates.size());
            for (int sidx = 0; sidx < nextStates.size(); ++sidx) {
                TLCState s1 = nextStates.next();
                oos.checkAction(tool, s0, s1, checkActionResults, alen * sidx);
            }
            nextStates.resetNext();
            check.addNextState(tool, s0, fp0, nextStates, checkActionResults, oos.checkState(tool, s0));
        }
    }

    @Override
    public boolean doLiveCheck() {
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            long sizeAtLastCheck = diskGraph.getSizeAtLastCheck();
            long sizeCurrently = diskGraph.size();
            double delta = (double)(sizeCurrently - sizeAtLastCheck) / ((double)sizeAtLastCheck * 1.0);
            if (!(delta > TLCGlobals.livenessThreshold)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int check(ITool tool, boolean forceCheck) throws Exception {
        if (forceCheck) {
            return this.check0(tool, false);
        }
        if (!TLCGlobals.doLiveness()) {
            return 0;
        }
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            long sizeAtLastCheck = diskGraph.getSizeAtLastCheck();
            long sizeCurrently = diskGraph.size();
            double delta = (double)(sizeCurrently - sizeAtLastCheck) / ((double)sizeAtLastCheck * 1.0);
            if (!(delta > TLCGlobals.livenessThreshold)) continue;
            return this.check0(tool, false);
        }
        return 0;
    }

    @Override
    public int finalCheck(ITool tool) throws InterruptedException, IOException {
        if ("off".equals(TLCGlobals.lnCheck)) {
            return 0;
        }
        return this.check0(tool, true);
    }

    protected int check0(ITool tool, boolean finalCheck) throws InterruptedException, IOException {
        int i;
        long startTime = System.currentTimeMillis();
        long sum = 0L;
        for (int i2 = 0; i2 < this.checker.length; ++i2) {
            sum += this.checker[i2].getDiskGraph().size();
        }
        MP.printMessage(2192, new String[]{finalCheck ? "complete" : "current", Long.toString(sum), this.checker.length == 1 ? "" : this.checker.length + " branches of "});
        ArrayBlockingQueue<ILiveChecker> queue = new ArrayBlockingQueue<ILiveChecker>(this.checker.length);
        queue.addAll(Arrays.asList(this.checker));
        int wNum = TLCGlobals.doSequentialLiveness() ? 1 : Math.min(this.checker.length, TLCGlobals.getNumWorkers());
        ExecutorService pool = Executors.newFixedThreadPool(wNum);
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(pool);
        for (int i3 = 0; i3 < wNum; ++i3) {
            completionService.submit(new LiveWorker(tool, i3, wNum, this, queue, finalCheck));
        }
        pool.shutdown();
        pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        Throwable ee = null;
        for (i = 0; i < wNum; ++i) {
            try {
                Future future = completionService.take();
                if (!((Boolean)future.get()).booleanValue()) continue;
                MP.printMessage(2267, TLC.convertRuntimeToHumanReadable(System.currentTimeMillis() - startTime));
                return 2116;
            }
            catch (ExecutionException e) {
                ee = e;
            }
        }
        if (ee != null) {
            Throwable cause = ee.getCause();
            if (cause instanceof OutOfMemoryError) {
                MP.printError(1003, cause);
            } else if (cause instanceof StackOverflowError) {
                MP.printError(1005, cause);
            } else if (cause != null) {
                MP.printError(1000, cause);
            } else {
                MP.printError(1000, ee);
            }
            System.exit(1);
        }
        if (!finalCheck) {
            for (i = 0; i < this.checker.length; ++i) {
                this.checker[i].getDiskGraph().makeNodePtrTbl();
            }
        }
        MP.printMessage(2267, TLC.convertRuntimeToHumanReadable(System.currentTimeMillis() - startTime));
        return 0;
    }

    @Override
    public void checkTrace(ITool tool, Supplier<StateVec> traceSupplier) throws InterruptedException, IOException {
        StateVec stateTrace = traceSupplier.get();
        this.addInitState(tool, stateTrace.elementAt(0), stateTrace.elementAt(0).fingerPrint());
        SetOfStates successors = new SetOfStates(stateTrace.size() * 2);
        for (int i = 0; i < stateTrace.size() - 1; ++i) {
            successors.clear();
            TLCState tlcState = stateTrace.elementAt(i);
            long fingerPrint = tlcState.fingerPrint();
            successors.put(tlcState);
            TLCState successor = stateTrace.elementAt(i + 1);
            successors.put(successor);
            this.addNextState(tool, tlcState, fingerPrint, successors);
        }
        TLCState lastState = stateTrace.elementAt(stateTrace.size() - 1);
        this.addNextState(tool, lastState, lastState.fingerPrint(), new SetOfStates(0));
        int result = this.check0(tool, true);
        if (result != 0) {
            throw new LiveException(result);
        }
        this.reset();
    }

    @Override
    public String getMetaDir() {
        return this.metadir;
    }

    @Override
    public IBucketStatistics getOutDegreeStatistics() {
        return this.outDegreeGraphStats;
    }

    @Override
    public ILiveChecker getChecker(int idx) {
        return this.checker[idx];
    }

    @Override
    public int getNumChecker() {
        return this.checker.length;
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].close();
        }
    }

    @Override
    public synchronized void beginChkpt() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().beginChkpt();
        }
    }

    @Override
    public void commitChkpt() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().commitChkpt();
        }
    }

    @Override
    public void recover() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            MP.printMessage(2130);
            this.checker[i].getDiskGraph().recover();
        }
    }

    @Override
    public void flushWritesToDiskFiles() throws IOException {
        for (ILiveChecker c : this.checker) {
            c.getDiskGraph().flushWritesToDiskFiles();
        }
    }

    @Override
    public void reset() throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            this.checker[i].getDiskGraph().reset();
        }
    }

    @Override
    public IBucketStatistics calculateInDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            diskGraph.calculateInDegreeDiskGraph(aGraphStats);
        }
        return aGraphStats;
    }

    @Override
    public IBucketStatistics calculateOutDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        for (int i = 0; i < this.checker.length; ++i) {
            AbstractDiskGraph diskGraph = this.checker[i].getDiskGraph();
            diskGraph.calculateOutDegreeDiskGraph(aGraphStats);
        }
        return aGraphStats;
    }

    private class LiveChecker
    extends AbstractLiveChecker {
        private final DiskGraph dgraph;

        public LiveChecker(OrderOfSolution oos, int soln, IBucketStatistics bucketStatistics, ILivenessStateWriter writer) throws IOException {
            super(oos, writer);
            this.dgraph = new DiskGraph(LiveCheck.this.metadir, soln, bucketStatistics);
        }

        @Override
        public void addInitState(ITool tool, TLCState state, long stateFP) {
            this.dgraph.addInitNode(stateFP, -1);
            this.writer.writeState(state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNextState(ITool tool, TLCState s0, long fp0, SetOfStates nextStates, BitVector checkActionResults, boolean[] checkStateResults) throws IOException {
            int cnt = 0;
            int succCnt = nextStates.size();
            int alen = this.oos.getCheckAction().length;
            OrderOfSolution orderOfSolution = this.oos;
            synchronized (orderOfSolution) {
                GraphNode node0 = this.dgraph.getNode(fp0);
                int s = node0.succSize();
                node0.setCheckState(checkStateResults);
                for (int sidx = 0; sidx < succCnt; ++sidx) {
                    TLCState successorState = nextStates.next();
                    long successor = successorState.fingerPrint();
                    long ptr1 = this.dgraph.getPtr(successor);
                    if (ptr1 == -1L || !node0.transExists(successor, -1)) {
                        node0.addTransition(successor, -1, checkStateResults.length, alen, checkActionResults, sidx * alen, succCnt - cnt++);
                    } else {
                        ++cnt;
                    }
                    this.writer.writeState(s0, successorState, checkActionResults, sidx * alen, alen, ptr1 == -1L ? (short)0 : 1);
                }
                nextStates.resetNext();
                if (s == 0 && s == node0.succSize() || s < node0.succSize()) {
                    node0.realign();
                    this.dgraph.addNode(node0);
                } else {
                    Assert.check(TLCGlobals.mainChecker == null, 1000);
                }
            }
        }

        @Override
        public DiskGraph getDiskGraph() {
            return this.dgraph;
        }
    }

    private class TableauLiveChecker
    extends AbstractLiveChecker {
        private final TableauDiskGraph dgraph;
        private GraphNode errorGraphNode;

        public TableauLiveChecker(OrderOfSolution oos, int soln, IBucketStatistics statistics, ILivenessStateWriter writer) throws IOException {
            super(oos, writer);
            this.errorGraphNode = null;
            this.dgraph = Boolean.getBoolean(LiveCheck.class.getName() + ".debug") ? new DebugTableauDiskGraph(LiveCheck.this.metadir, soln, statistics, oos) : new TableauDiskGraph(LiveCheck.this.metadir, soln, statistics);
        }

        @Override
        public void addInitState(ITool tool, TLCState state, long stateFP) {
            int initCnt = this.oos.getTableau().getInitCnt();
            for (int i = 0; i < initCnt; ++i) {
                TBGraphNode tnode = this.oos.getTableau().getNode(i);
                if (!tnode.isConsistent(state, tool)) continue;
                this.dgraph.addInitNode(stateFP, tnode.getIndex());
                this.dgraph.recordNode(stateFP, tnode.getIndex());
                this.writer.writeState(state, tnode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNextState(ITool tool, TLCState s0, long fp0, SetOfStates nextStates, BitVector checkActionResults, boolean[] checkStateResults) throws IOException {
            int cnt = 0;
            int succCnt = nextStates.size();
            TBGraph tableau = this.oos.getTableau();
            BitVector consistency = new BitVector(tableau.size() * succCnt);
            Enumeration elements = tableau.elements();
            while (elements.hasMoreElements()) {
                TBGraphNode tableauNode = (TBGraphNode)elements.nextElement();
                for (int sidx = 0; sidx < succCnt; ++sidx) {
                    TLCState s1 = nextStates.next();
                    if (!tableauNode.isConsistent(s1, tool)) continue;
                    consistency.set(tableauNode.getIndex() * succCnt + sidx);
                }
                nextStates.resetNext();
            }
            LongVec prefix = null;
            OrderOfSolution orderOfSolution = this.oos;
            synchronized (orderOfSolution) {
                int loc0 = this.dgraph.setDone(fp0);
                int[] nodes = this.dgraph.getNodesByLoc(loc0);
                if (nodes == null) {
                    return;
                }
                int alen = this.oos.getCheckAction().length;
                int allocationHint = nodes.length / this.dgraph.getElemLength() * succCnt;
                for (int nidx = 2; nidx < nodes.length; nidx += this.dgraph.getElemLength()) {
                    int tidx0 = nodes[nidx];
                    TBGraphNode tnode0 = this.oos.getTableau().getNode(tidx0);
                    GraphNode node0 = this.dgraph.getNode(fp0, tidx0);
                    int s = node0.succSize();
                    node0.setCheckState(checkStateResults);
                    for (int sidx = 0; sidx < succCnt; ++sidx) {
                        TLCState s1 = nextStates.next();
                        long successor = s1.fingerPrint();
                        boolean isDone = this.dgraph.isDone(successor);
                        for (int k = 0; k < tnode0.nextSize(); ++k) {
                            TBGraphNode tnode1 = tnode0.nextAt(k);
                            long ptr1 = this.dgraph.getPtr(successor, tnode1.getIndex());
                            if (consistency.get(tnode1.getIndex() * succCnt + sidx) && (ptr1 == -1L || !node0.transExists(successor, tnode1.getIndex()))) {
                                node0.addTransition(successor, tnode1.getIndex(), checkStateResults.length, alen, checkActionResults, sidx * alen, allocationHint - cnt);
                                this.writer.writeState(s0, tnode0, s1, tnode1, checkActionResults, sidx * alen, alen, (short)0);
                                if (ptr1 == -1L) {
                                    this.dgraph.recordNode(successor, tnode1.getIndex());
                                    if (isDone) {
                                        this.addNextState(tool, s1, successor, tnode1, this.oos, this.dgraph);
                                    }
                                }
                            }
                            ++cnt;
                        }
                    }
                    nextStates.resetNext();
                    if (s == 0 && s == node0.succSize() || s < node0.succSize()) {
                        node0.realign();
                        this.dgraph.addNode(node0);
                        continue;
                    }
                    Assert.check(TLCGlobals.mainChecker == null, 1000);
                }
                if (this.errorGraphNode != null) {
                    this.dgraph.createCache();
                    prefix = this.dgraph.getPath(this.errorGraphNode.stateFP, this.errorGraphNode.tindex);
                    this.dgraph.destroyCache();
                }
            }
            if (prefix != null) {
                this.printErrorTrace(tool, prefix);
            }
        }

        private void printErrorTrace(ITool tool, LongVec prefix) {
            AbstractChecker abstractChecker = TLCGlobals.mainChecker;
            synchronized (abstractChecker) {
                if (TLCGlobals.mainChecker.printedLivenessErrorStack) {
                    return;
                }
                TLCGlobals.mainChecker.printedLivenessErrorStack = true;
                MP.printError(2116);
                MP.printError(2264);
                int plen = prefix.size();
                ArrayList<TLCStateInfo> states = new ArrayList<TLCStateInfo>(plen);
                long fp = prefix.elementAt(plen - 1);
                TLCStateInfo sinfo = tool.getState(fp);
                if (sinfo == null) {
                    throw new EvalException(2123);
                }
                states.add(sinfo);
                for (int i = plen - 2; i >= 0; --i) {
                    long curFP = prefix.elementAt(i);
                    if (curFP == fp) continue;
                    sinfo = tool.getState(curFP, sinfo);
                    states.set(states.size() - 1, tool.evalAlias((TLCStateInfo)states.get(states.size() - 1), sinfo.state));
                    states.add(sinfo);
                    fp = curFP;
                }
                TLCStateInfo last = (TLCStateInfo)states.get(states.size() - 1);
                states.set(states.size() - 1, tool.evalAlias(last, last.state));
                for (int i = 0; i < states.size(); ++i) {
                    StatePrinter.printInvariantViolationStateTraceState((TLCStateInfo)states.get(i));
                }
                TLCGlobals.mainChecker.stop();
                if (states.size() == 1) {
                    TLCGlobals.mainChecker.setErrState(last.state, null, false, 2110);
                } else {
                    TLCGlobals.mainChecker.setErrState(((TLCStateInfo)states.get((int)(states.size() - 2))).state, last.state, false, 2110);
                }
                tool.checkPostConditionWithCounterExample(new CounterExample(states));
                this.errorGraphNode = null;
                throw new INextStateFunctor.InvariantViolatedException();
            }
        }

        private void addNextState(ITool tool, TLCState s, long fp, TBGraphNode tnode, OrderOfSolution oos, TableauDiskGraph dgraph) throws IOException {
            boolean[] checkStateRes = oos.checkState(tool, s);
            int slen = checkStateRes.length;
            int alen = oos.getCheckAction().length;
            GraphNode node = dgraph.getNode(fp, tnode.getIndex());
            int numSucc = node.succSize();
            node.setCheckState(checkStateRes);
            int cnt = 0;
            int nextSize = tnode.nextSize();
            BitVector checkActionResults = nextSize > 0 ? oos.checkAction(tool, s, s, new BitVector(alen), 0) : null;
            for (int i = 0; i < nextSize; ++i) {
                TBGraphNode tnode1 = tnode.nextAt(i);
                int tidx1 = tnode1.getIndex();
                long ptr1 = dgraph.getPtr(fp, tidx1);
                if (tnode1.isConsistent(s, tool)) {
                    if (tnode1.isAccepting() && this.errorGraphNode == null) {
                        this.errorGraphNode = node;
                        return;
                    }
                    if (ptr1 == -1L || !node.transExists(fp, tidx1)) {
                        node.addTransition(fp, tidx1, slen, alen, checkActionResults, 0, nextSize - cnt);
                        if (ptr1 == -1L) {
                            dgraph.recordNode(fp, tnode1.getIndex());
                            this.addNextState(tool, s, fp, tnode1, oos, dgraph);
                        }
                    }
                }
                ++cnt;
            }
            cnt = 0;
            Action[] actions = tool.getActions();
            for (int i = 0; i < actions.length; ++i) {
                StateVec nextStates = tool.getNextStates(actions[i], s);
                int nextCnt = nextStates.size();
                for (int j = 0; j < nextCnt; ++j) {
                    TLCState s1 = nextStates.elementAt(j);
                    if (tool.isInModel(s1) && tool.isInActions(s, s1)) {
                        long fp1 = s1.fingerPrint();
                        BitVector checkActionRes = oos.checkAction(tool, s, s1, new BitVector(alen), 0);
                        boolean isDone = dgraph.isDone(fp1);
                        for (int k = 0; k < tnode.nextSize(); ++k) {
                            TBGraphNode tnode1 = tnode.nextAt(k);
                            int tidx1 = tnode1.getIndex();
                            long ptr1 = dgraph.getPtr(fp1, tidx1);
                            int total = actions.length * nextCnt * tnode.nextSize();
                            if (tnode1.isConsistent(s1, tool) && (ptr1 == -1L || !node.transExists(fp1, tidx1))) {
                                node.addTransition(fp1, tidx1, slen, alen, checkActionRes, 0, total - cnt);
                                this.writer.writeState(s, tnode, s1, tnode1, checkActionRes, 0, alen, (short)1, IStateWriter.Visualization.DOTTED);
                                if (ptr1 == -1L) {
                                    dgraph.recordNode(fp1, tidx1);
                                    if (isDone) {
                                        this.addNextState(tool, s1, fp1, tnode1, oos, dgraph);
                                    }
                                }
                            }
                            ++cnt;
                        }
                        continue;
                    }
                    ++cnt;
                }
            }
            if (numSucc < node.succSize()) {
                node.realign();
                dgraph.addNode(node);
            }
        }

        @Override
        public AbstractDiskGraph getDiskGraph() {
            return this.dgraph;
        }
    }

    static abstract class AbstractLiveChecker
    implements ILiveChecker {
        protected final ILivenessStateWriter writer;
        protected final OrderOfSolution oos;

        public AbstractLiveChecker(OrderOfSolution oos, ILivenessStateWriter writer) {
            this.oos = oos;
            this.writer = writer;
        }

        @Override
        public OrderOfSolution getSolution() {
            return this.oos;
        }

        @Override
        public void close() throws IOException {
            if (!ModelChecker.VETO_CLEANUP) {
                this.getDiskGraph().close();
            }
            this.writer.close();
        }
    }
}

