/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.utils.LogWriter;

public class ColorSpaceConvertor {
    public static boolean isUsingARGB = false;

    public static BufferedImage convertFromICCCMYK(int n, int n2, byte[] byArray) {
        BufferedImage bufferedImage = null;
        try {
            int n3 = n * n2 * 4;
            if (byArray.length < n3) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            return ColorSpaceConvertor.profileConvertCMYKImageToRGB(byArray, n, n2);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception  " + exception + " converting from ICC colorspace");
            }
            exception.printStackTrace();
            return bufferedImage;
        }
    }

    public static BufferedImage convertToRGB(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 1) {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                new ColorConvertOp(ColorSpaces.hints).filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + exception.toString() + " converting to RGB");
                }
            }
            catch (Error error) {
                error.printStackTrace();
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error " + error.toString() + " converting to RGB");
                }
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    public static BufferedImage convertToARGB(BufferedImage bufferedImage) {
        block3: {
            if (bufferedImage.getType() != 2) {
                try {
                    BufferedImage bufferedImage2 = bufferedImage;
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
                    ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                    colorConvertOp.filter(bufferedImage2, bufferedImage);
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception " + exception + " creating argb image");
                }
            }
        }
        isUsingARGB = true;
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block4: {
            bufferedImage = null;
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 4;
            double d = -1.0;
            double d2 = -1.12;
            double d3 = -1.12;
            double d4 = -1.21;
            double d5 = 255.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n4 = 0;
            for (int i = 0; i < n3; i += 4) {
                double d9 = (double)(byArray[i] & 0xFF) / d5;
                double d10 = (double)(byArray[i + 1] & 0xFF) / d5;
                double d11 = (double)(byArray[i + 2] & 0xFF) / d5;
                double d12 = (double)(byArray[i + 3] & 0xFF) / d5;
                if (d != d9 || d2 != d10 || d3 != d11 || d4 != d12) {
                    double d13 = 1.0;
                    double d14 = ColorSpaceConvertor.clip01(d9 + d12);
                    double d15 = ColorSpaceConvertor.clip01(d10 + d12);
                    double d16 = ColorSpaceConvertor.clip01(d11 + d12);
                    double d17 = (d13 - d14) * (d13 - d15) * (d13 - d16);
                    double d18 = d14 * (d13 - d15) * (d13 - d16);
                    double d19 = (d13 - d14) * d15 * (d13 - d16);
                    double d20 = (d13 - d14) * (d13 - d15) * d16;
                    double d21 = (d13 - d14) * d15 * d16;
                    double d22 = d14 * (d13 - d15) * d16;
                    double d23 = d14 * d15 * (d13 - d16);
                    d6 = d5 * ColorSpaceConvertor.clip01(d17 + 0.9137 * d19 + 0.9961 * d20 + 0.9882 * d21);
                    d7 = d5 * ColorSpaceConvertor.clip01(d17 + 0.6196 * d18 + d20 + 0.5176 * d22);
                    d8 = d5 * ColorSpaceConvertor.clip01(d17 + 0.7804 * d18 + 0.5412 * d19 + 0.0667 * d21 + 0.2118 * d22 + 0.4863 * d23);
                    d = d9;
                    d2 = d10;
                    d3 = d11;
                    d4 = d12;
                }
                byArray2[n4++] = (byte)d6;
                byArray2[n4++] = (byte)d7;
                byArray2[n4++] = (byte)d8;
            }
            try {
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage profileConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block4: {
            ColorSpace colorSpace = DeviceCMYKColorSpace.getColorSpaceInstance();
            bufferedImage = null;
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 4;
            float f = -1.0f;
            float f2 = -1.0f;
            float f3 = -1.0f;
            float f4 = -1.0f;
            float[] fArray = new float[3];
            int n4 = 0;
            for (int i = 0; i < n3; i += 4) {
                float f5 = (float)(byArray[i] & 0xFF) / 255.0f;
                float f6 = (float)(byArray[i + 1] & 0xFF) / 255.0f;
                float f7 = (float)(byArray[i + 2] & 0xFF) / 255.0f;
                float f8 = (float)(byArray[i + 3] & 0xFF) / 255.0f;
                if (f != f5 || f2 != f6 || f3 != f7 || f4 != f8) {
                    fArray = colorSpace.toRGB(new float[]{f5, f6, f7, f8});
                    f = f5;
                    f2 = f6;
                    f3 = f7;
                    f4 = f8;
                }
                byArray2[n4++] = (byte)(fArray[0] * 255.0f);
                byArray2[n4++] = (byte)(fArray[1] * 255.0f);
                byArray2[n4++] = (byte)(fArray[2] * 255.0f);
            }
            try {
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertYCbCrToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block11: {
            bufferedImage = null;
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 3;
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            for (int i = 0; i < n3; i += 3) {
                int n11 = byArray[i] & 0xFF;
                int n12 = byArray[1 + i] & 0xFF;
                int n13 = byArray[2 + i] & 0xFF;
                if (n7 != n11 || n8 != n12 || n9 != n13) {
                    float f = 298.082f * (float)n11;
                    n4 = (int)((double)((f + 408.583f * (float)n13) / 256.0f) - 222.921);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if ((n5 = (int)((f - 100.291f * (float)n12 - 208.12f * (float)n13) / 256.0f + 135.576f)) < 0) {
                        n5 = 0;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    if ((n6 = (int)((f + 516.412f * (float)n12) / 256.0f - 276.836f)) < 0) {
                        n6 = 0;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    n7 = n11;
                    n8 = n12;
                    n9 = n13;
                }
                byArray2[n10++] = (byte)n4;
                byArray2[n10++] = (byte)n5;
                byArray2[n10++] = (byte)n6;
            }
            try {
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!LogWriter.isOutput()) break block11;
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage convertIndexedToFlat(int n, int n2, int n3, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        int[] nArray;
        int[] nArray2 = new int[]{0, 1, 2};
        int[] nArray3 = new int[]{0, 1, 2, 3};
        int n4 = 3;
        int n5 = 0;
        if (byArray2 != null) {
            n5 = byArray2.length;
        }
        if (bl) {
            nArray = nArray3;
            n4 = 4;
        } else {
            nArray = nArray2;
        }
        int n6 = n2 * n3 * n4;
        byte[] byArray3 = new byte[n6];
        int n7 = 0;
        float f = 0.0f;
        block0 : switch (n) {
            case 8: {
                int n8 = 0;
                for (int i = 0; i < byArray.length - 1; ++i) {
                    if (bl2) {
                        f = (float)(byArray[i] & 0xFF) / 255.0f;
                    } else {
                        n7 = (byArray[i] & 0xFF) * 3;
                    }
                    if (n8 >= n6) break block0;
                    if (bl2) {
                        if (f > 0.0f) {
                            byArray3[n8++] = (byte)((float)(255 - byArray2[0]) * f);
                            byArray3[n8++] = (byte)((float)(255 - byArray2[1]) * f);
                            byArray3[n8++] = (byte)((float)(255 - byArray2[2]) * f);
                        } else {
                            n8 += 3;
                        }
                    } else if (n7 < n5) {
                        byArray3[n8++] = byArray2[n7];
                        byArray3[n8++] = byArray2[n7 + 1];
                        byArray3[n8++] = byArray2[n7 + 2];
                    }
                    if (!bl) continue;
                    byArray3[n8++] = n7 == 0 && f == 0.0f ? -1 : 0;
                }
                break;
            }
            case 4: {
                ColorSpaceConvertor.flatten4bpc(n2, byArray, byArray2, bl, n6, byArray3);
                break;
            }
            case 2: {
                ColorSpaceConvertor.flatted2bpc(n2, byArray, byArray2, bl, n6, byArray3);
                break;
            }
            case 1: {
                ColorSpaceConvertor.flatten1bpc(n2, byArray, byArray2, bl, n6, 255, byArray3);
            }
        }
        BufferedImage bufferedImage = bl ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 1);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray3, byArray3.length);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2 * n4, n4, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private static void flatten4bpc(int n, byte[] byArray, byte[] byArray2, boolean bl, int n2, byte[] byArray3) {
        int n3 = 0;
        int[] nArray = new int[]{4, 0};
        int n4 = 0;
        block0: for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                int n5 = (byArray[i] >> nArray[j] & 0xF) * 3;
                if (n3 >= n2) continue block0;
                byArray3[n3++] = byArray2[n5];
                byArray3[n3++] = byArray2[n5 + 1];
                byArray3[n3++] = byArray2[n5 + 2];
                if (bl) {
                    byArray3[n3++] = n5 == 0 ? (byte)0 : 0;
                }
                if (++n4 != n) continue;
                n4 = 0;
                j = 8;
            }
        }
    }

    public static void flatten1bpc(int n, byte[] byArray, byte[] byArray2, boolean bl, int n2, int n3, byte[] byArray3) {
        int n4 = 0;
        int n5 = 0;
        block0: for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n6 = (byArray[i] >> 7 - j & 1) * 3;
                if (n4 >= n2) continue block0;
                if (bl) {
                    if (n6 == 0) {
                        byArray3[n4++] = byArray2[n6];
                        byArray3[n4++] = byArray2[n6 + 1];
                        byArray3[n4++] = byArray2[n6 + 2];
                        byArray3[n4++] = (byte)n3;
                    } else {
                        byArray3[n4++] = byArray2[n6];
                        byArray3[n4++] = byArray2[n6 + 1];
                        byArray3[n4++] = byArray2[n6 + 2];
                        byArray3[n4++] = 0;
                    }
                } else {
                    byArray3[n4++] = byArray2[n6];
                    byArray3[n4++] = byArray2[n6 + 1];
                    byArray3[n4++] = byArray2[n6 + 2];
                }
                if (++n5 != n) continue;
                n5 = 0;
                j = 8;
            }
        }
    }

    public static void flatted2bpc(int n, byte[] byArray, byte[] byArray2, boolean bl, int n2, byte[] byArray3) {
        int n3 = 0;
        int[] nArray = new int[]{6, 4, 2, 0};
        int n4 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 4 && n3 < n2; ++j) {
                int n5;
                if (byArray2 == null) {
                    n5 = byArray[i] << nArray[3 - j] & 0xC0;
                    if (n5 == 192) {
                        n5 = 255;
                    }
                    byArray3[n3++] = (byte)n5;
                } else {
                    n5 = (byArray[i] >> nArray[j] & 3) * 3;
                    byArray3[n3++] = byArray2[n5];
                    byArray3[n3++] = byArray2[n5 + 1];
                    byArray3[n3++] = byArray2[n5 + 2];
                    if (bl) {
                        byArray3[n3++] = n5 == 0 ? (byte)0 : 0;
                    }
                }
                if (++n4 != n) continue;
                n4 = 0;
                j = 8;
            }
        }
    }

    public static BufferedImage iccConvertCMYKImageToRGB(byte[] byArray, int n, int n2) throws IOException {
        ColorSpace colorSpace = DeviceCMYKColorSpace.getColorSpaceInstance();
        ColorSpace colorSpace2 = GenericColorSpace.getColorSpaceInstance();
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace2, new int[]{8, 8, 8}, false, false, 1, 0);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, ColorSpaces.hints);
        int n3 = n * n2 * 4;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n3; i += 4) {
            int n11 = byArray[i] & 0xFF;
            int n12 = byArray[i + 1] & 0xFF;
            int n13 = byArray[i + 2] & 0xFF;
            int n14 = byArray[i + 3] & 0xFF;
            if (n11 != n4 || n12 != n5 || n13 != n6 || n14 != n7) {
                double d = (double)n11 + 1.402 * (double)n13 - 179.456;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 255.0) {
                    d = 255.0;
                }
                double d2 = (double)n11 - 0.34414 * (double)n12 - 0.71414 * (double)n13 + 135.45984;
                if (d2 < 0.0) {
                    d2 = 0.0;
                } else if (d2 > 255.0) {
                    d2 = 255.0;
                }
                double d3 = (double)n11 + 1.772 * (double)n12 - 226.816;
                if (d3 < 0.0) {
                    d3 = 0.0;
                } else if (d3 > 255.0) {
                    d3 = 255.0;
                }
                n8 = 255 - (int)d;
                n9 = 255 - (int)d2;
                n10 = 255 - (int)d3;
                n4 = n11;
                n5 = n12;
                n6 = n13;
                n7 = n14;
            }
            byArray[i] = (byte)n8;
            byArray[i + 1] = (byte)n9;
            byArray[i + 2] = (byte)n10;
        }
        WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n * 4, 4, new int[]{0, 1, 2, 3}, null);
        WritableRaster writableRaster2 = ((ColorModel)componentColorModel).createCompatibleWritableRaster(n, n2);
        colorConvertOp.filter(writableRaster, writableRaster2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        bufferedImage.setData(writableRaster2);
        return bufferedImage;
    }

    public static BufferedImage convertColorspace(BufferedImage bufferedImage, int n) {
        block2: {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), n);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + exception + " converting image");
            }
        }
        return bufferedImage;
    }

    private static double clip01(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public static WritableRaster createCompatibleWritableRaaster(ColorModel colorModel, int n, int n2) {
        return colorModel.createCompatibleWritableRaster(n, n2);
    }

    public static Raster createInterleavedRaster(byte[] byArray, int n, int n2) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int[] nArray = new int[]{0, 1, 2};
        return Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
    }

    public static void drawImage(Graphics2D graphics2D, BufferedImage bufferedImage, AffineTransform affineTransform, ImageObserver imageObserver) {
        graphics2D.drawImage(bufferedImage, affineTransform, imageObserver);
    }
}

