/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class Vector_Path
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private GeneralPath[] items = new GeneralPath[this.max_size];

    public Vector_Path() {
    }

    protected static int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_Path(int n) {
        this.max_size = n;
        this.items = new GeneralPath[this.max_size];
    }

    public final GeneralPath[] get() {
        return this.items;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            System.arraycopy(this.items, n + 1, this.items, n, this.current_item - 1 - n);
            this.items[this.current_item - 1] = new GeneralPath();
        } else {
            this.items[0] = new GeneralPath();
        }
        --this.current_item;
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final void set(GeneralPath[] generalPathArray) {
        this.items = generalPathArray;
    }

    public final GeneralPath elementAt(int n) {
        if (n >= this.max_size) {
            return null;
        }
        return this.items[n];
    }

    public final void addElement(GeneralPath generalPath) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = generalPath;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(GeneralPath generalPath, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = generalPath;
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            GeneralPath[] generalPathArray = this.items;
            this.items = new GeneralPath[this.max_size];
            System.arraycopy(generalPathArray, 0, this.items, 0, n2);
            this.increment_size = Vector_Path.incrementSize(this.increment_size);
        }
    }

    public void setCurrent_item(int n) {
        this.current_item = n;
    }

    public void trim() {
        GeneralPath[] generalPathArray = new GeneralPath[this.current_item];
        System.arraycopy(this.items, 0, generalPathArray, 0, this.current_item);
        this.items = generalPathArray;
        this.max_size = this.current_item;
    }

    public void setSize(int n) {
        this.current_item = n;
    }
}

