/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.graphviz;

import com.abstratt.graphviz.GraphVizActivator;
import com.abstratt.graphviz.ProcessController;
import com.abstratt.pluginutils.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class GraphViz {
    private static final String DOT_EXTENSION = ".dot";
    private static final String TMP_FILE_PREFIX = "graphviz";
    private static final int MAX_DOT_LENGTH_TO_LOG = 262144;

    public static void generate(InputStream input, String format, int dimensionX, int dimensionY, IPath outputLocation) throws CoreException {
        MultiStatus status = new MultiStatus(GraphVizActivator.ID, 0, "Errors occurred while running Graphviz", null);
        File dotInputFile = null;
        File dotOutputFile = outputLocation.toFile();
        ByteArrayOutputStream dotContents = new ByteArrayOutputStream();
        try {
            dotInputFile = File.createTempFile(TMP_FILE_PREFIX, DOT_EXTENSION);
            FileOutputStream tmpDotOutputStream = null;
            try {
                IOUtils.copy((InputStream)input, (OutputStream)dotContents);
                tmpDotOutputStream = new FileOutputStream(dotInputFile);
                IOUtils.copy((InputStream)new ByteArrayInputStream(dotContents.toByteArray()), (OutputStream)tmpDotOutputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tmpDotOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)tmpDotOutputStream);
            IStatus result = GraphViz.runDot(format, dimensionX, dimensionY, dotInputFile, dotOutputFile);
            status.add(result);
            System.out.println(dotContents.toString());
            if (!result.isOK()) {
                LogUtils.debug((String)GraphVizActivator.ID, (String)"A problem was detected, dumping DOT output to console");
                System.out.println(dotContents.toString());
            }
            if (dotOutputFile.isFile() && dotOutputFile.length() > 0L) {
                return;
            }
        }
        catch (IOException e) {
            status.add((IStatus)new Status(4, GraphVizActivator.ID, "", (Throwable)e));
        }
        finally {
            dotInputFile.delete();
            IOUtils.closeQuietly((InputStream)input);
        }
        throw new CoreException((IStatus)status);
    }

    public static byte[] load(InputStream input, String format, int dimensionX, int dimensionY) throws CoreException {
        MultiStatus status = new MultiStatus(GraphVizActivator.ID, 0, "Errors occurred while running Graphviz", null);
        File dotInputFile = null;
        File dotOutputFile = null;
        ByteArrayOutputStream dotContents = new ByteArrayOutputStream();
        try {
            dotInputFile = File.createTempFile(TMP_FILE_PREFIX, DOT_EXTENSION);
            dotOutputFile = File.createTempFile(TMP_FILE_PREFIX, "." + format);
            dotOutputFile.delete();
            byte[] contentsAsArray = null;
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileOutputStream tmpDotOutputStream = new FileOutputStream(dotInputFile);){
                IOUtils.copy((InputStream)input, (OutputStream)dotContents);
                contentsAsArray = dotContents.toByteArray();
                IOUtils.copy((InputStream)new ByteArrayInputStream(contentsAsArray), (OutputStream)tmpDotOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            IStatus result = GraphViz.runDot(format, dimensionX, dimensionY, dotInputFile, dotOutputFile);
            status.add(result);
            status.add(GraphViz.logInput(contentsAsArray));
            if (dotOutputFile.isFile()) {
                if (!result.isOK() && Platform.inDebugMode()) {
                    LogUtils.log((IStatus)status);
                }
                byte[] byArray = FileUtils.readFileToByteArray((File)dotOutputFile);
                return byArray;
            }
        }
        catch (IOException e) {
            status.add((IStatus)new Status(4, GraphVizActivator.ID, "", (Throwable)e));
        }
        finally {
            dotInputFile.delete();
            dotOutputFile.delete();
            IOUtils.closeQuietly((InputStream)input);
        }
        throw new CoreException((IStatus)status);
    }

    public static IStatus runDot(String format, int dimensionX, int dimensionY, File dotInput, File dotOutput) {
        double dpi = 96.0;
        double widthInInches = (double)dimensionX / dpi;
        double heightInInches = (double)dimensionY / dpi;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-o" + dotOutput.getAbsolutePath());
        cmd.add("-T" + format);
        if (widthInInches > 0.0 && heightInInches > 0.0) {
            cmd.add("-Gsize=" + widthInInches + ',' + heightInInches);
        }
        cmd.add(dotInput.getAbsolutePath());
        return GraphViz.runDot(cmd.toArray(new String[cmd.size()]));
    }

    private static IStatus logInput(byte[] dotContents) {
        String dotInput = new String(dotContents, 0, Math.min(dotContents.length, 262144), StandardCharsets.UTF_8);
        return new Status(1, GraphVizActivator.ID, "dot input was:\n" + dotInput, null);
    }

    public static IStatus runDot(String ... options) {
        IPath dotFullPath = GraphVizActivator.getInstance().getDotLocation();
        if (dotFullPath == null || dotFullPath.isEmpty()) {
            return new Status(4, GraphVizActivator.ID, "dot.exe/dot not found in PATH. Please install it from graphviz.org, update the PATH or specify the absolute path in the preferences.");
        }
        if (!dotFullPath.toFile().isFile()) {
            return new Status(4, GraphVizActivator.ID, "Could not find Graphviz dot at \"" + dotFullPath + "\"");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(dotFullPath.toOSString());
        String commandLineExtension = GraphVizActivator.getInstance().getCommandLineExtension();
        if (commandLineExtension != null) {
            String[] tokens = commandLineExtension.split(" ");
            cmd.addAll(Arrays.asList(tokens));
        }
        cmd.addAll(Arrays.asList(options));
        ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
        try {
            ProcessController controller = new ProcessController(90000L, cmd.toArray(new String[cmd.size()]), null, dotFullPath.removeLastSegments(1).toFile());
            controller.forwardErrorOutput(errorOutput);
            controller.forwardOutput(System.out);
            controller.forwardInput(System.in);
            int exitCode = controller.execute();
            if (exitCode != 0) {
                return new Status(2, GraphVizActivator.ID, "Graphviz exit code: " + exitCode + "." + GraphViz.createContentMessage(errorOutput));
            }
            if (errorOutput.size() > 0) {
                return new Status(2, GraphVizActivator.ID, GraphViz.createContentMessage(errorOutput));
            }
            return Status.OK_STATUS;
        }
        catch (ProcessController.TimeOutException timeOutException) {
            return new Status(4, GraphVizActivator.ID, "Graphviz process did not finish in a timely way." + GraphViz.createContentMessage(errorOutput));
        }
        catch (InterruptedException e) {
            return new Status(4, GraphVizActivator.ID, "Unexpected exception executing Graphviz." + GraphViz.createContentMessage(errorOutput), (Throwable)e);
        }
        catch (IOException e) {
            return new Status(4, GraphVizActivator.ID, "Unexpected exception executing Graphviz." + GraphViz.createContentMessage(errorOutput), (Throwable)e);
        }
    }

    private static String createContentMessage(ByteArrayOutputStream errorOutput) {
        if (errorOutput.size() == 0) {
            return "";
        }
        return " dot produced the following error output: \n" + errorOutput;
    }
}

