/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Collection;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GreedyCycleRemoval;

public class GreedyFeedbackArcGraphTransformer<V, E>
implements Function<Graph<V, E>, Graph<V, E>> {
    Function<E, E> edgeFactory;

    public GreedyFeedbackArcGraphTransformer(Function<E, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    @Override
    public Graph<V, E> apply(Graph<V, E> graph) {
        GreedyCycleRemoval<V, E> greedyCycleRemoval = new GreedyCycleRemoval<V, E>(graph);
        Collection<E> feedbackArcs = greedyCycleRemoval.getFeedbackArcs();
        for (E se : feedbackArcs) {
            V source = graph.getEdgeSource(se);
            V target = graph.getEdgeTarget(se);
            graph.removeEdge(se);
            E newEdge = this.edgeFactory.apply(se);
            graph.addEdge(target, source, newEdge);
        }
        return graph;
    }
}

