/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.util.NeighborCache;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jungrapht.visualization.layout.util.synthetics.SE;
import org.jungrapht.visualization.layout.util.synthetics.SV;
import org.jungrapht.visualization.layout.util.synthetics.SVTransformedGraphSupplier;
import org.jungrapht.visualization.layout.util.synthetics.SyntheticSE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleLayoutReduceEdgeCrossing<V, E> {
    private static final Logger log = LoggerFactory.getLogger(CircleLayoutReduceEdgeCrossing.class);
    private Graph<V, E> originalGraph;
    private Graph<SV<V>, SE<E>> svGraph;
    private Comparator<SV<V>> ascendingDegreeComparator = Comparator.comparingInt(v -> this.svGraph.degreeOf((SV<SV>)v));
    private List<SV<V>> tableList = new LinkedList<SV<V>>();
    private Map<SV<V>, List<SV<V>>> tableMap = new HashMap<SV<V>, List<SV<V>>>();
    private V[] vertices;
    NeighborCache<SV<V>, SE<E>> neighborCache;

    public CircleLayoutReduceEdgeCrossing(Graph<V, E> originalGraph) {
        this.originalGraph = originalGraph;
        SVTransformedGraphSupplier<V, E> transformedGraphSupplier = new SVTransformedGraphSupplier<V, E>(originalGraph);
        this.svGraph = transformedGraphSupplier.get();
        this.neighborCache = new NeighborCache<SV<SV<V>>, SE<SE<E>>>(this.svGraph);
    }

    public List<V> getVertexOrderedList() {
        this.buildTable();
        ArrayList<V> vertexList = new ArrayList<V>();
        ArrayList<SV<V>> waveFrontNodes = new ArrayList<SV<V>>();
        ArrayList<SV<V>> waveCenterNodes = new ArrayList<SV<V>>();
        ArrayList<SE<E>> removalList = new ArrayList<SE<E>>();
        int n = this.svGraph.vertexSet().size();
        for (int counter = 0; counter < n - 3; ++counter) {
            SV<V> currentNode = waveFrontNodes.size() > 0 ? (SV<V>)waveFrontNodes.remove(0) : (waveCenterNodes.size() > 0 ? (SV)waveCenterNodes.remove(0) : this.tableList.get(0));
            List<SV<V>> adjacentNodes = this.tableMap.get(currentNode);
            for (int i = 0; i < adjacentNodes.size() - 1; ++i) {
                SV<V> w;
                SV<V> v = adjacentNodes.get(i);
                if (this.svGraph.containsEdge(v, w = adjacentNodes.get(i + 1)) || this.svGraph.containsEdge(w, v)) {
                    log.trace("currentNode: {} edge v, w: {},{} exists", currentNode, v, w);
                    SE<E> edge = this.svGraph.getEdge(v, w);
                    removalList.add(edge);
                } else {
                    log.trace("currentNode: {} edge v, w: {},{} does not exist", currentNode, v, w);
                    SyntheticSE syntheticSE = new SyntheticSE();
                    this.svGraph.addEdge(v, w, syntheticSE);
                    removalList.add(syntheticSE);
                }
                this.tableMap.get(v).remove(currentNode);
                this.tableMap.get(w).remove(currentNode);
            }
            HashSet<SE<SE<E>>> losers = new HashSet<SE<SE<E>>>(this.svGraph.incomingEdgesOf(currentNode));
            losers.addAll(this.svGraph.outgoingEdgesOf(currentNode));
            this.svGraph.removeAllEdges(losers);
            this.svGraph.removeVertex(currentNode);
            this.neighborCache = new NeighborCache<SV<SV<V>>, SE<SE<E>>>(this.svGraph);
            waveCenterNodes.clear();
            waveCenterNodes.addAll(waveFrontNodes);
            waveCenterNodes.sort(this.ascendingDegreeComparator);
            waveFrontNodes.clear();
            waveFrontNodes.addAll((Collection)this.tableMap.get(currentNode));
            waveFrontNodes.sort(this.ascendingDegreeComparator);
            this.buildTable();
        }
        this.svGraph = new SVTransformedGraphSupplier<V, E>(this.originalGraph).get();
        this.svGraph.removeAllEdges(removalList);
        if (log.isTraceEnabled()) {
            log.trace("removed losers to get {}", (Object)this.svGraph);
        }
        this.neighborCache = new NeighborCache<SV<SV<V>>, SE<SE<E>>>(this.svGraph);
        DepthFirstIterator<SV<V>, SE<E>> dfi = new DepthFirstIterator<SV<V>, SE<E>>(this.svGraph);
        while (dfi.hasNext()) {
            vertexList.add(((SV)dfi.next()).getVertex());
        }
        for (SV<V> v : this.svGraph.vertexSet()) {
            if (!vertexList.contains(v.getVertex())) {
                List<SV<V>> neighbors = this.neighborCache.neighborListOf(v);
                List inList = neighbors.stream().map(nn -> nn.getVertex()).filter(vertexList::contains).collect(Collectors.toList());
                if (inList.size() == 0) {
                    vertexList.add(v.getVertex());
                } else if (inList.size() == 1) {
                    int idx = vertexList.indexOf(inList.get(0));
                    vertexList.add(idx, v.getVertex());
                } else {
                    int[] idxes = new int[inList.size()];
                    for (int i = 0; i < inList.size(); ++i) {
                        idxes[i] = vertexList.indexOf(inList.get(i));
                    }
                    boolean consecutive = false;
                    for (int j = 0; j < idxes.length - 1; ++j) {
                        if (Math.abs(idxes[j] - idxes[j + 1]) != 1) continue;
                        vertexList.add(Math.max(idxes[j], idxes[j + 1]), v.getVertex());
                        consecutive = true;
                        break;
                    }
                    if (!consecutive) {
                        vertexList.add(idxes[0], v.getVertex());
                    }
                }
            }
            this.vertices = vertexList.toArray(new Object[0]);
        }
        return CircleLayoutReduceEdgeCrossing.postProcessing(this.originalGraph, vertexList);
    }

    private void buildTable() {
        this.tableList.clear();
        this.tableMap.clear();
        HashMap otherMap = new HashMap();
        for (SV<V> v : this.svGraph.vertexSet()) {
            this.tableList.add(v);
            this.tableMap.put(v, this.neighborCache.neighborsOf(v).stream().sorted(this.ascendingDegreeComparator).collect(Collectors.toCollection(LinkedList::new)));
            this.tableList.sort(this.ascendingDegreeComparator);
        }
    }

    public static <V, E> int countCrossings(Graph<V, E> graph, V[] vertices) {
        HashMap vertexListPositions = new HashMap();
        IntStream.range(0, vertices.length).forEach(i -> vertexListPositions.put(vertices[i], i));
        int numberOfCrossings = 0;
        LinkedHashSet openEdgeList = new LinkedHashSet();
        LinkedList<V> verticesSeen = new LinkedList<V>();
        for (Object v : vertices) {
            log.trace("for vertex {}", (Object)v);
            verticesSeen.add(v);
            ArrayList<E> incidentEdges = new ArrayList<E>(graph.edgesOf(v));
            incidentEdges.sort((e, f) -> {
                int deltaf;
                Object oppe = Graphs.getOppositeVertex(graph, e, v);
                Object oppf = Graphs.getOppositeVertex(graph, f, v);
                int idxv = (Integer)vertexListPositions.get(v);
                int idxe = (Integer)vertexListPositions.get(oppe);
                int idxf = (Integer)vertexListPositions.get(oppf);
                int deltae = idxv - idxe;
                if (deltae < 0) {
                    deltae += vertices.length;
                }
                if ((deltaf = idxv - idxf) < 0) {
                    deltaf += vertices.length;
                }
                return Integer.compare(deltae, deltaf);
            });
            for (Object e2 : incidentEdges) {
                V opposite = Graphs.getOppositeVertex(graph, e2, v);
                if (!verticesSeen.contains(opposite)) {
                    openEdgeList.add(e2);
                } else {
                    openEdgeList.remove(e2);
                    for (int i2 = verticesSeen.indexOf(opposite) + 1; i2 < verticesSeen.indexOf(v); ++i2) {
                        Object tween = verticesSeen.get(i2);
                        numberOfCrossings = (int)((long)numberOfCrossings + graph.edgesOf(tween).stream().filter(openEdgeList::contains).count());
                        log.trace("numberOfCrossings now {}", (Object)numberOfCrossings);
                    }
                }
                log.trace("added edge {}", e2);
            }
        }
        return numberOfCrossings;
    }

    public static <V, E> List<V> postProcessing(Graph<V, E> graph, List<V> list) {
        Object[] array = list.toArray();
        HashMap<Object, Integer> vertexListPositions = new HashMap<Object, Integer>();
        IntStream.range(0, array.length).forEach(i -> vertexListPositions.put(array[i], i));
        int currentCrossings = CircleLayoutReduceEdgeCrossing.countCrossings(graph, array);
        log.trace("originalCrossings: {}", (Object)currentCrossings);
        int originalCrossings = currentCrossings;
        LinkedList<Integer> positions = new LinkedList<Integer>();
        for (int i2 = 0; i2 < 9; ++i2) {
            for (V v : graph.vertexSet()) {
                positions.clear();
                if (graph.degreeOf(v) <= 1) continue;
                ArrayList<E> incidentEdges = new ArrayList<E>(graph.edgesOf(v));
                V one = Graphs.getOppositeVertex(graph, incidentEdges.get(0), v);
                V two = Graphs.getOppositeVertex(graph, incidentEdges.get(1), v);
                int idxOne = (Integer)vertexListPositions.get(one);
                int idxTwo = (Integer)vertexListPositions.get(two);
                IntStream.range(idxOne + 1, idxTwo).forEach(positions::add);
                if (positions.isEmpty()) {
                    positions.add(idxOne - 1);
                    positions.add(idxOne + 1);
                }
                for (int pos = 0; pos < positions.size(); ++pos) {
                    int vpos = (Integer)vertexListPositions.get(v);
                    CircleLayoutReduceEdgeCrossing.swap(array, vpos, pos);
                    vertexListPositions.put(array[pos], pos);
                    vertexListPositions.put(array[vpos], vpos);
                    int newCrossings = CircleLayoutReduceEdgeCrossing.countCrossings(graph, array);
                    if (newCrossings < currentCrossings) {
                        currentCrossings = newCrossings;
                        log.trace("reduced crossings to {}", (Object)currentCrossings);
                        continue;
                    }
                    CircleLayoutReduceEdgeCrossing.swap(array, vpos, pos);
                    vertexListPositions.put(array[pos], pos);
                    vertexListPositions.put(array[vpos], vpos);
                }
            }
            if (currentCrossings < originalCrossings) continue;
            log.trace("break {} >= {}", (Object)currentCrossings, (Object)originalCrossings);
            break;
        }
        return Arrays.asList(array);
    }

    private static <T> void swap(T[] array, int i, int j) {
        T temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

