/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.value.IBoolValue;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.KSubsetValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;

public class FiniteSetsExt {
    private FiniteSetsExt() {
    }

    @TLAPlusOperator(identifier="Quantify", module="FiniteSetsExt", warn=false)
    public static Value quantify(Value value, OpValue opValue) {
        Value value2;
        if (!(value instanceof EnumerableValue)) {
            throw new EvalException(2169, new String[]{"first", "Quantify", "set", Values.ppr((String)value.toString())});
        }
        int n = 0;
        ValueEnumeration valueEnumeration = ((SetEnumValue)value.toSetEnum()).elements();
        Value[] valueArray = new Value[1];
        while ((value2 = valueEnumeration.nextElement()) != null) {
            valueArray[0] = value2;
            Value value3 = opValue.eval(valueArray, 0);
            if (value3 instanceof IBoolValue) {
                if (!((BoolValue)value3).val) continue;
                ++n;
                continue;
            }
            throw new EvalException(2169, new String[]{"second", "Quantify", "boolean-valued operator", Values.ppr((String)opValue.toString())});
        }
        assert (0 <= n && n <= value.size());
        return IntValue.gen((int)n);
    }

    @TLAPlusOperator(identifier="kSubset", module="FiniteSetsExt", warn=false)
    public static Value kSubset(Value value, Value value2) {
        SetEnumValue setEnumValue = (SetEnumValue)value2.toSetEnum();
        if (setEnumValue == null) {
            throw new EvalException(2283, new String[]{"second", "kSubset", "set", Values.ppr((String)value2.toString())});
        }
        if (!(value instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"first", "kSubset", "natural number", Values.ppr((String)value.toString())});
        }
        int n = ((IntValue)value).val;
        if (n < 0 || setEnumValue.size() < n) {
            return SetEnumValue.EmptySet;
        }
        if (n == 0) {
            return new SubsetValue((Value)SetEnumValue.EmptySet);
        }
        return new KSubsetValue(n, (Value)setEnumValue, setEnumValue.cm);
    }

    @TLAPlusOperator(identifier="FoldSet", module="FiniteSetsExt", warn=false)
    public static Value foldSet(OpValue opValue, Value value, Enumerable enumerable) {
        Value value2;
        Value[] valueArray = new Value[2];
        valueArray[1] = value;
        ValueEnumeration valueEnumeration = enumerable.elements();
        while ((value2 = valueEnumeration.nextElement()) != null) {
            valueArray[0] = value2;
            valueArray[1] = opValue.eval(valueArray, 0);
        }
        return valueArray[1];
    }
}

