/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import java.util.Arrays;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.FunctionValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;

public final class Functions {
    private Functions() {
    }

    @TLAPlusOperator(identifier="IsInjective", module="Functions", warn=false)
    public static BoolValue IsInjective(Value value) {
        if (value instanceof TupleValue) {
            return Functions.isInjectiveNonDestructive(((TupleValue)value).elems);
        }
        if (value instanceof FcnRcdValue && ((FcnRcdValue)value).intv != null && ((FcnRcdValue)value).intv.low == 1) {
            return Functions.isInjectiveNonDestructive(((FcnRcdValue)value).values);
        }
        Value value2 = value.toTuple();
        if (value2 != null) {
            return Functions.isInjectiveDestructive(((TupleValue)value2).elems);
        }
        if (value instanceof SetOfRcdsValue) {
            return Functions.isInjectiveNonDestructive(((SetOfRcdsValue)value).values);
        }
        if (value instanceof FcnRcdValue) {
            return Functions.isInjectiveNonDestructive(((FcnRcdValue)value).values);
        }
        throw new EvalException(2283, new String[]{"IsInjective", "function", Values.ppr((String)value.toString())});
    }

    private static BoolValue isInjectiveDestructive(Value[] valueArray) {
        Arrays.sort(valueArray);
        for (int i = 1; i < valueArray.length; ++i) {
            if (!valueArray[i - 1].equals(valueArray[i])) continue;
            return BoolValue.ValFalse;
        }
        return BoolValue.ValTrue;
    }

    private static BoolValue isInjectiveNonDestructive(Value[] valueArray) {
        for (int i = 0; i < valueArray.length; ++i) {
            for (int j = i + 1; j < valueArray.length; ++j) {
                if (!valueArray[i].equals(valueArray[j])) continue;
                return BoolValue.ValFalse;
            }
        }
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="AntiFunction", module="Functions", warn=false)
    public static Value antiFunction(Value value) {
        Value[] valueArray;
        Value[] valueArray2;
        FcnRcdValue fcnRcdValue = (FcnRcdValue)value.normalize().toFcnRcd();
        if (fcnRcdValue == null) {
            throw new EvalException(2283, new String[]{"AntiFunction", "functions", Values.ppr((String)value.toString())});
        }
        if (fcnRcdValue.intv != null) {
            valueArray2 = fcnRcdValue.getDomainAsValues();
        } else {
            valueArray = fcnRcdValue.getDomainAsValues();
            valueArray2 = Arrays.copyOf(valueArray, valueArray.length);
        }
        valueArray = Arrays.copyOf(fcnRcdValue.values, fcnRcdValue.values.length);
        return new FcnRcdValue(valueArray, valueArray2, false).normalize();
    }

    @TLAPlusOperator(identifier="FoldFunction", module="Functions", warn=false)
    public static Value foldFunction(OpValue opValue, Value value, Value value2) {
        if (!(value2 instanceof FunctionValue)) {
            throw new EvalException(2169, new String[]{"third", "FoldFunction", "function", Values.ppr((String)value2.toString())});
        }
        return Functions.foldFunctionOnSet(opValue, value, value2, ((FunctionValue)value2).getDomain());
    }

    @TLAPlusOperator(identifier="FoldFunctionOnSet", module="Functions", warn=false)
    public static Value foldFunctionOnSet(OpValue opValue, Value value, Value value2, Value value3) {
        Value value4;
        if (!(value2 instanceof FunctionValue)) {
            throw new EvalException(2169, new String[]{"third", "FoldFunctionOnSet", "function", Values.ppr((String)value2.toString())});
        }
        FunctionValue functionValue = (FunctionValue)value2;
        if (!(value3 instanceof Enumerable)) {
            throw new EvalException(2169, new String[]{"fourth", "FoldFunctionOnSet", "set", Values.ppr((String)value3.toString())});
        }
        Enumerable enumerable = (Enumerable)value3;
        Value[] valueArray = new Value[2];
        valueArray[1] = value;
        ValueEnumeration valueEnumeration = enumerable.elements();
        while ((value4 = valueEnumeration.nextElement()) != null) {
            valueArray[0] = functionValue.apply(value4, 0);
            valueArray[1] = opValue.eval(valueArray, 0);
        }
        return valueArray[1];
    }
}

