/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.graphviz.ui;

import java.io.File;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileBrowserField
extends Composite {
    private Text text;
    private Button button;

    public FileBrowserField(Composite parent) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2052);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileBrowserField.this.valueChanged();
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FileBrowserField.this.valueChanged();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)gridData);
        this.button = new Button((Composite)this, 8);
        this.button.setText("Browse");
        this.button.setFont(this.getFont());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newValue = FileBrowserField.this.doBrowse();
                if (newValue != null) {
                    FileBrowserField.this.setText(newValue);
                }
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FileBrowserField.this.button = null;
            }
        });
    }

    protected String doBrowse() {
        File d;
        File f = new File(this.text.getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getFile(f)) == null) {
            return null;
        }
        return d.getAbsolutePath();
    }

    private File getFile(File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public String getText() {
        return this.text != null ? this.text.getText() : "";
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setText(String value) {
        if (value == null) {
            value = "";
        }
        if (!this.text.getText().equals(value)) {
            this.text.setText(value);
            this.valueChanged();
        }
    }

    public void valueChanged() {
    }
}

