/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.imageviewer;

import com.abstratt.imageviewer.IGraphicalContentProvider;
import com.abstratt.pluginutils.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractGraphicalContentProvider
implements IGraphicalContentProvider {
    private Image image;
    private Point suggestedSize;
    private ContentLoader loaderJob = new ContentLoader();
    public static final ISchedulingRule CONTENT_LOADING_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public void dispose() {
        this.loaderJob.cancel();
        this.disposeImage();
    }

    public void setImage(Image newImage) {
        this.disposeImage();
        this.image = newImage;
    }

    public Image createErrorImage(Display display, Point size, IStatus status) {
        Image errorImg = new Image((Device)display, size.x, size.y);
        GC gc = new GC((Drawable)errorImg);
        StringBuffer output = new StringBuffer("Errors generating an image.");
        if (!status.isOK()) {
            output.append("More details in the log file.");
        }
        output.append("\n\n");
        gc.drawText(this.renderMessage(status, output), 10, 10);
        gc.dispose();
        return errorImg;
    }

    private String renderMessage(IStatus status, StringBuffer output) {
        output.append(status.getMessage());
        if (status.getException() != null) {
            output.append("\n" + status.getException());
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            output.append("\n");
            this.renderMessage(child, output);
            ++n2;
        }
        return output.toString();
    }

    private void disposeImage() {
        if (this.image == null) {
            return;
        }
        this.image.dispose();
        this.image = null;
    }

    @Override
    public final Image getImage() {
        return this.image;
    }

    protected Point getSuggestedSize() {
        return this.suggestedSize;
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.disposeImage();
        if (newInput != null) {
            this.loaderJob.asyncLoadImage(newInput, viewer);
        }
    }

    @Override
    public void setSuggestedSize(Point suggestedSize) {
        this.suggestedSize = suggestedSize;
    }

    protected void reload() {
        this.loaderJob.schedule(200L);
    }

    @Override
    public abstract Image loadImage(Display var1, Point var2, Object var3) throws CoreException;

    @Override
    public void saveImage(Display display, Point suggestedSize, Object input, IPath location, IGraphicalContentProvider.GraphicFileFormat fileFormat) throws CoreException {
        int swtFileFormat = this.getSWTFileFormat(fileFormat);
        Image toSave = this.loadImage(Display.getDefault(), new Point(0, 0), input);
        try {
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{toSave.getImageData()};
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(204800);
            imageLoader.save((OutputStream)buffer, swtFileFormat);
            try {
                FileUtils.writeByteArrayToFile((File)location.toFile(), (byte[])buffer.toByteArray());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.abstratt.imageviewer", "Error saving image", (Throwable)e));
            }
        }
        finally {
            toSave.dispose();
        }
    }

    private int getSWTFileFormat(IGraphicalContentProvider.GraphicFileFormat fileFormat) {
        switch (fileFormat) {
            case BITMAP: {
                return 0;
            }
            case GIF: {
                return 2;
            }
            case JPEG: {
                return 4;
            }
            case TIFF: {
                return 6;
            }
        }
        return 5;
    }

    class ContentLoader
    extends Job {
        private static final long IMAGE_LOAD_DELAY = 100L;
        static final String JOB_FAMILY = "ContentLoader";
        private Object input;
        private Viewer viewer;

        public ContentLoader() {
            super("Image loading job");
            this.setSystem(true);
            this.setPriority(10);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            monitor.beginTask("loading image", 100);
            ContentLoader.getJobManager().beginRule(CONTENT_LOADING_RULE, monitor);
            try {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                AbstractGraphicalContentProvider.this.disposeImage();
                monitor.worked(50);
                try {
                    AbstractGraphicalContentProvider.this.setImage(AbstractGraphicalContentProvider.this.loadImage(Display.getDefault(), AbstractGraphicalContentProvider.this.getSuggestedSize(), this.input));
                }
                catch (CoreException e) {
                    if (!e.getStatus().isOK()) {
                        LogUtils.log((IStatus)e.getStatus());
                    }
                    AbstractGraphicalContentProvider.this.setImage(AbstractGraphicalContentProvider.this.createErrorImage(Display.getDefault(), AbstractGraphicalContentProvider.this.getSuggestedSize(), e.getStatus()));
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.worked(20);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(20);
                        if (ContentLoader.this.viewer != null) {
                            ContentLoader.this.viewer.refresh();
                        }
                    }
                });
            }
            finally {
                ContentLoader.getJobManager().endRule(CONTENT_LOADING_RULE);
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return JOB_FAMILY.equals(family);
        }

        private void asyncLoadImage(Object input, Viewer viewer) {
            ContentLoader.getJobManager().cancel((Object)JOB_FAMILY);
            this.input = input;
            if (viewer.getControl().isDisposed() || !viewer.getControl().isVisible()) {
                return;
            }
            this.viewer = viewer;
            this.schedule(100L);
        }
    }
}

