/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.imageviewer;

import com.abstratt.imageviewer.Activator;
import com.abstratt.imageviewer.IGraphicalContentProvider;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.ConstructorUtils;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GraphicalViewer
extends ContentViewer {
    private Canvas canvas;
    private boolean adjustToCanvas = true;
    private boolean imageRedrawRequested;

    public GraphicalViewer(Composite parent) {
        this.canvas = new Canvas(parent, 0);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GraphicalViewer.this.canvas.setBounds(GraphicalViewer.this.canvas.getParent().getClientArea());
                GraphicalViewer.this.requestImageRedraw();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GraphicalViewer.this.redrawImageIfRequested();
                GC gc = e.gc;
                GraphicalViewer.this.paintCanvas(gc);
            }
        });
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Control getControl() {
        return this.canvas;
    }

    private Rectangle getDrawingBounds(Image image) {
        Rectangle imageBounds = image.getBounds();
        Rectangle canvasBounds = this.canvas.getBounds();
        double hScale = (double)canvasBounds.width / (double)imageBounds.width;
        double vScale = (double)canvasBounds.height / (double)imageBounds.height;
        double scale = Math.min(1.0, Math.min(hScale, vScale));
        int width = (int)((double)imageBounds.width * scale);
        int height = (int)((double)imageBounds.height * scale);
        int x = (canvasBounds.width - width) / 2;
        int y = (canvasBounds.height - height) / 2;
        return new Rectangle(x, y, width, height);
    }

    private Image getImage(Point point) {
        IGraphicalContentProvider provider = (IGraphicalContentProvider)this.getContentProvider();
        if (provider == null) {
            return null;
        }
        return provider.getImage();
    }

    public ISelection getSelection() {
        return null;
    }

    protected void inputChanged(Object newInput, Object oldInput) {
        this.refresh();
    }

    public boolean isAdjustToCanvas() {
        return this.adjustToCanvas;
    }

    private void paintCanvas(GC gc) {
        Image image = this.getImage();
        if (image == null || image.isDisposed()) {
            return;
        }
        Rectangle drawingBounds = this.getDrawingBounds(image);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, drawingBounds.x, drawingBounds.y, drawingBounds.width, drawingBounds.height);
    }

    public Image getImage() {
        return this.getImage(this.canvas.getSize());
    }

    public void redrawImage() {
        if (this.getContentProvider() == null) {
            return;
        }
        Class<?> contentProviderClass = this.getContentProvider().getClass();
        try {
            this.setContentProvider((IContentProvider)ConstructorUtils.invokeConstructor(contentProviderClass, (Object[])new Object[0]));
        }
        catch (NoSuchMethodException e) {
            Activator.logUnexpected(null, e);
        }
        catch (IllegalAccessException e) {
            Activator.logUnexpected(null, e);
        }
        catch (InvocationTargetException e) {
            Activator.logUnexpected(null, e);
        }
        catch (InstantiationException e) {
            Activator.logUnexpected(null, e);
        }
    }

    protected void redrawImageIfRequested() {
        if (this.imageRedrawRequested) {
            this.redrawImage();
        }
        this.imageRedrawRequested = false;
    }

    public void refresh() {
        if (!this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    private void requestImageRedraw() {
        this.imageRedrawRequested = true;
    }

    public void setAdjustToCanvas(boolean adjustToCanvas) {
        this.adjustToCanvas = adjustToCanvas;
        this.requestImageRedraw();
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (contentProvider != null) {
            if (!(contentProvider instanceof IGraphicalContentProvider)) {
                throw new IllegalArgumentException(IGraphicalContentProvider.class.getName());
            }
            if (this.adjustToCanvas && !this.canvas.isDisposed()) {
                ((IGraphicalContentProvider)contentProvider).setSuggestedSize(this.canvas.getSize());
            }
        }
        super.setContentProvider(contentProvider);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        throw new UnsupportedOperationException();
    }
}

